<?php $this->load->view("partial/header_print"); ?>
<div class="content-page">
	<!-- Start content -->
	<div class="content">
		<?php
		if (isset($error_message)) {
			echo "<div class='alert alert-dismissible alert-danger'>" . $error_message . "</div>";
			exit;
		}
		?>

		<?php $this->load->view('partial/print_receipt', array('print_after_sale', $print_after_sale, 'selected_printer' => 'receipt_printer')); ?>

		<div class="print_hide" id="control_buttons" style="text-align:right">
			<a href="javascript:printdoc();">
				<div class="btn btn-info btn-sm" , id="show_print_button"><?php echo '<span class="glyphicon glyphicon-print">&nbsp</span>' . $this->lang->line('common_print'); ?></div>
			</a>
			<?php echo anchor("stockintake", '<span class="glyphicon glyphicon-save">&nbsp</span> Continue Stock Taking', array('class' => 'btn btn-info btn-sm', 'id' => 'show_sales_button')); ?>
		</div>

		<div id="receipt_wrapper">
			<div id="receipt_header">
				<?php
				if ($this->config->item('company_logo') != '') {
				?>
					<div id="company_name"><img id="image" src="<?php echo base_url('uploads/' . $this->config->item('company_logo')); ?>" alt="company_logo" /></div>
				<?php
				}
				?>

				<?php
				if ($this->config->item('receipt_show_company_name')) {
				?>
					<div id="company_name"><?php echo $this->config->item('company'); ?></div>
				<?php
				}
				?>


				<!-- <div id="company_address"><?php echo nl2br($branch_address); ?></div> -->
				<div id="company_address"><?php echo nl2br($this->config->item('address')); ?></div>
				<div id="company_phone"><?php echo $this->config->item('phone'); ?></div>
				<!-- <div id="company_phone"><?php echo $branch_number; ?></div> -->
				<div id="sale_receipt"><b><?php echo $receipt_title; ?></b></div>
				<div id="sale_time"><b><?php echo $transaction_time ?></b></div>
			</div>

			<div id="receipt_general_info">
				<div class="clearfix">
					<div class="pull-right">
						<?php
						if (isset($title)) {
						?>
							<div id="customer"><?php echo '<b>' . " Title</b>: " . $title; ?></div>
						<?php
						}
						?>
						<?php
						if (!empty($reference)) {
						?>
							<div id="reference"><?php echo '<b>Description</b>: ' . $description; ?></div>
						<?php
						}
						?>
					</div>

					<div class="pull-left">
						<div id="sale_id"><?php echo '<b>'. " Stock ID</b>: " . $stock_id; ?></div>

						<div id="employee"><?php echo '<b>' . $user_role . "</b>: " . $employee; ?></div>
						<div id="employee"><?php echo '<b>Date</b>: ' . ucfirst($transaction_date); ?></div>

					</div>
				</div>
			</div>
			<!--end of general info-->
			<div class="table-responsive">
				<table id="receipt_items" class="table">
					<thead class="thead-light">
						<tr>
							<th style="width:3%; color: #495057; background-color: #e9ecef;border-color: #dee2e6;"><?php echo 'S/N.'; ?></th>
							<th style="width:10%; color: #495057; background-color: #e9ecef;border-color: #dee2e6;"><?php echo 'Item No.'; ?></th>
							<th style="width:30%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;"><?php echo $this->lang->line('items_item'); ?></th>

							<th style="width:3%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Current Quantity</th>
							<th style="width:3%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Stock Taking Quantity</th>
							<th style="width:3%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Variance Quantity</th>


							<th style="width:10%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Cost Price</th>
							<th style="width:10%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Retail Price</th>

							<th style="width:7%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Current Stock Total</th>
							<th style="width:7%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Stock Taking Total</th>
							<th style="width:7%;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Variance Amount</th>

							<th style="width:7%;text-align:right;color: #495057; background-color: #e9ecef;border-color: #dee2e6;"><?php echo 'Cost Total' ?></th>
						</tr>
					</thead>
					<?php
					$sn = 1;
					foreach (array_reverse($cart, TRUE) as $line => $item) {
					?>
						<tr>
							<td><?php echo $sn++; ?></td>
							<td><?php echo $item['item_number']; ?></td>
							<td><?php echo $item['name']; ?></td>

							<td><?php echo to_quantity_decimals(abs($item['current_quantity'])); ?></td>
							<td><?php echo to_quantity_decimals(abs($item['quantity_purchased'])); ?></td>
							<td><?php echo to_quantity_decimals(abs($item['current_quantity'])) - to_quantity_decimals(abs($item['quantity_purchased'])); ?></td>

							<td><?php echo to_currency($item['price']); ?></td>
							<td><?php echo to_currency($item['unit_price']); ?></td>

							<td><?php echo to_quantity_decimals($item['current_quantity']) * $item['price']; ?></td>
							<td><?php echo to_quantity_decimals($item['quantity_purchased']) * $item['price']; ?></td>
							<td><?php echo (to_quantity_decimals($item['quantity_purchased']) * $item['price']) - (to_quantity_decimals($item['current_quantity']) * $item['price']); ?></td>
							<!-- <td><?php echo to_quantity_decimals($item['quantity']); ?></td> -->

							<td><div class="total-value"><?php echo to_currency(abs($item['total'])); ?></div></td>
						</tr>

					<?php
					}
					?>
					<tr>
						<th colspan="10" style='text-align:right;border-top:2px solid #000000;'>Grand Cost Total</th>
						<td colspan="2" style='border-top:2px solid #000000;'>
							<div class="total-value"><?php echo to_currency(abs($total)); ?></div>
						</td>
					</tr>
					<?php
					if ($mode != 'requisition') {
					?>
						<tr>
							<!-- <th colspan="3" style='text-align:right;'><?php echo $this->lang->line('sales_payment'); ?></th> -->
							<!-- <td colspan="2"> -->
							<!-- <div class="total-value"><?php echo $payment_type; ?></div> -->
							<!-- </td> -->
						</tr>

						<?php if (isset($amount_change)) {
						?>
							<tr>
								<th colspan="4" style='text-align:right;'><?php echo $this->lang->line('sales_amount_tendered'); ?></th>
								<td colspan="2">
									<div class="total-value"><?php echo to_currency(abs($amount_tendered)); ?></div>
								</td>
							</tr>

							<tr>
								<th colspan="4" style='text-align:right;'><?php echo $this->lang->line('sales_change_due'); ?></th>
								<td colspan="2">
									<div class="total-value"><?php echo $amount_change; ?></div>
								</td>
							</tr>
						<?php
						}
						?>
					<?php
					}
					?>
				</table>
			</div>
			<?php //print_r($cart)
			?>

			<div id='barcode'>
				<img src='data:image/png;base64,<?php echo $barcode; ?>' /><br>
				<?php echo 'STCK ' . $stock_id; ?>
			</div>
		</div>
	</div>
</div>


<?php $this->load->view("partial/footer"); ?>