<?php
class Inventory extends CI_Model
{
	public function __construct(){
        parent::__construct();
        $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
    }
	public function insert($inventory_data)
	{
		return $this->db->insert('inventory', $inventory_data);
	}
	public function insert_expiry($inventory_data)
	{
		$this->db->insert('item_expiry', $inventory_data);
	}
	public function insert_batch($inventory_data)
	{
		if (count($inventory_data) == 1) {
			$this->insert($inventory_data);
		} elseif (count($inventory_data) > 1) {
			return $this->db->insert_batch('inventory', $inventory_data);
		}
	}

	public function get_inventory_data_for_item($item_id, $location_id = FALSE, $start = null, $end = null)
	{

		$this->db->select("inventory.*, people.first_name AS firstname, people.last_name AS lastname");
		$this->db->from('inventory AS inventory');
		$this->db->join('people AS people', 'people.person_id = inventory.trans_user','left');
		$this->db->where('trans_items', $item_id);
		if ($location_id != FALSE) {
			$this->db->where('trans_location', $location_id);
		}
		if ($start != null) {
			$this->db->where('trans_date >=', $start);
		}
		if ($end != null) {
			$this->db->where('trans_date <=', $end);
		}
		$this->db->order_by('trans_date', 'desc');

		$data=$this->db->get();
		//echo $this->db->last_query(); exit();
		return $data;
	}

	public function reset_quantity($item_id)
	{
		$inventory_sums = $this->Inventory->get_inventory_sum($item_id);
		foreach ($inventory_sums as $inventory_sum) {
			if ($inventory_sum['sum'] > 0) {
				return $this->Inventory->insert(
					array(
						'trans_inventory' => -1 * $inventory_sum['sum'],
						'trans_items' => $item_id,
						'trans_location' => $inventory_sum['location_id'],
						'trans_comment' => $this->lang->line('items_is_deleted'),
						'trans_user' => $this->Employee->get_logged_in_employee_info()->person_id
					)
				);
			}
		}
		return TRUE;
	}

	public function get_inventory_sum($item_id)
	{
		$this->db->select('SUM(trans_inventory) AS sum, MAX(trans_location) AS location_id');
		$this->db->from('inventory');
		$this->db->where('trans_items', $item_id);
		$this->db->group_by('trans_location');

		return $this->db->get()->result_array();
	}
}
