<?php $this->load->view("partial/header_print"); ?>
<div class="content-page">
	<!-- Start content -->
	<div class="content">
		<?php
		if (isset($error_message)) {
			echo "<div class='alert alert-dismissible alert-danger'>" . $error_message . "</div>";
			exit;
		}
//		var_dump($this->_ci_cached_vars);
		?>

		<?php $this->load->view('partial/print_receipt', array('print_after_sale', $print_after_sale, 'selected_printer' => 'receipt_printer')); ?>

		<div class="print_hide" id="control_buttons" style="text-align:right">
			<a href="javascript:printdoc();">
				<div class="btn btn-info btn-sm" , id="show_print_button"><?php echo '<span class="glyphicon glyphicon-print">&nbsp</span>' . $this->lang->line('common_print'); ?></div>
			</a>
			<?php //echo anchor("items/request_item", '<span class="glyphicon glyphicon-save">&nbsp</span> New Request', array('class' => 'btn btn-info btn-sm', 'id' => 'show_sales_button')); ?>
		</div>

		<div id="receipt_wrapper">
			<div id="receipt_header">
				<?php
				if ($this->config->item('company_logo') != '') {
				?>
					<div id="company_name"><img id="image" src="<?php echo base_url('uploads/' . $branch_details["logo"]); ?>" alt="company_logo" /></div>
				<?php
				}
				?>

				<?php
				if ($this->config->item('receipt_show_company_name')) {
				?>
					<div id="company_name"><?php echo $branch_details["location_name"]; ?></div>
				<?php
				}
				?>

				<div id="company_address"><b><?php echo nl2br($branch_details["location_address"]); ?></b></div>
				<div id="company_phone"><b><?php echo $branch_details["location_number"]; ?></b></div>
				<div id="sale_receipt"><b><?php echo $receipt_title; ?></b></div>
				<div id="sale_time"><b><?php echo $transaction_time ?></b></div>
			</div>

			<div id="receipt_general_info">
				<div class="clearfix">
					<div class="pull-right">

						<div id="customer"><?php echo "<b>TO</b>: " . $to_branch; ?></div>

					</div>

					<div class="pull-left">
						<div id="sale_id"><?php echo "<b>Transfer ID</b>: PUSH " . $transfer_id; ?></div>

						<div id="employee"><?php echo '<b>' . $user_role . "</b>: " . $employee; ?></div>
                        <div id="customer"><?php echo "<b>Date</b>: " . $transaction_time; ?></div>

					</div>
				</div>
			</div>
			<!--end of general info-->
			<div class="table-responsive">
				<table id="receipt_items" class="table">
					<thead class="thead-light">
						<tr>

							<th style="color: #495057; background-color: #e9ecef;border-color: #dee2e6;">S/N</th>
							<th style="color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Product Name</th>
							<th style="color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Item Number</th>
							<th style="color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Transferred Qty</th>

							<th style="color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Cost Price</th>
                            <th style="color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Retail Price</th>
                            <th style="color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Wholesale Price</th>
							<th style="text-align:right;color: #495057; background-color: #e9ecef;border-color: #dee2e6;">Total</th>
						</tr>
					</thead>
					<?php
					$total = 0;
					$sn = 1;
					if(isset($push) && is_string($push)){
					    $push = json_decode($push,true);
                    }
					foreach ($push as $line => $item) {
						$total += $item['quantity'] * $item['transfer_price'];
					?>
						<tr>
							<td><?php echo $sn++; ?></td>
							<td><?php echo wordwrap($item['name'],20,'<br />'); ?></td>
							<td><?php echo $item['item_number']; ?></td>
							<td><?php echo to_quantity_decimals(abs($item['quantity'])); ?>
								<?=($item['pack_type']=='pack')?' Pack':'';?>
							</td>
							<td><?php echo to_currency($item['cost_price']);
								?></td>

                            <td>
                            <?php 
	                           	if($item['unit_price']==$item['transfer_price']){
	                            	echo to_currency($item['unit_price']);
	                            }else{
	                            	echo 0;
	                            }
	                        ?>
                            </td>

                            <td>
                            <?php 
                            if($item['whole_price']==$item['transfer_price']){
                            	echo to_currency($item['whole_price']);
                            }else{
                            	echo 0;
                            }
                            
                            ?>
                            	
                            </td>

							<td>
								<div class="total-value"><?php echo to_currency($item['quantity'] * $item['transfer_price']); ?></div>
							</td>
						</tr>


					<?php
					}
					?>
					<tr>
						<th colspan="8" style='text-align:right;border-top:2px solid #000000;'>Grand Total</th>
						<td colspan="3" style='border-top:2px solid #000000;'>
							<div class="total-value"><?php echo to_currency(abs($total)); ?></div>
						</td>
					</tr>

				</table>
			</div>
			<?php //print_r($cart)
			?>

			<div id='barcode'>
				<img src='data:image/png;base64,<?php echo $barcode; ?>' /><br>
				<?php echo 'PUSH ' . $transfer_id; ?>
			</div>

            <br />
            <br />
            <br />
            <div id="receipt_bottom" style="padding-left: 100px;padding-right: 100px">
                <div class="clearfix">
                    <div class="pull-right mr-5">

                        <div id="transferer">-----------------------------------------</div>
                        <p>Transferred by(name and signature)</p>

                    </div>

                    <div class="pull-left ml-5">
                        <div id="receiver">-----------------------------------------</div>
                        <p>Received by(name and signature)</p>

                    </div>

                </div>
            </div>
            <br />
            <br />
            <br />
            <div style="text-align: center">
                <div class="clearfix">
                    <div >
                        <div id="witness">-----------------------------------------</div>
                        <p>Witnessed by(name and signature)</p>

                    </div>
                </div>
            </div>
		</div>
	</div>
</div>


<?php $this->load->view("partial/footer"); ?>
