<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

require_once("Secure_Controller.php");

class Home extends Secure_Controller
{
	public function __construct()
	{
		parent::__construct();
	}




// 	public function sync_data($wearhouse_id)
// 	{
// 		$sync_tables = ['ipos_sales'];
// 		$url = 'https://3access.co.uk/admin/tenants/manually_insert_tenant'; // the URL you want to request
// 		$ch = curl_init();
// 		curl_setopt($ch, CURLOPT_URL, $url);
// 		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
// 		curl_setopt($ch, CURLOPT_TIMEOUT, 60); // Set timeout to 60 seconds
// 		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60); // Set connect timeout to 60 seconds
// 		$response = (array) json_decode(curl_exec($ch));
// 		if (curl_errno($ch)) {
// 			dd('Curl error: ' . curl_error($ch));
// 		}
// 		curl_close($ch);

// 		$index = 0;
// 		foreach ($response as $k => $v) {
// 			if (!$index) {
// 				$this->db->empty_table($k);
// 			}
// 			$index++;
// 			$v = array_map('get_object_vars', $v);
// 			$this->db->insert_batch($k, $v);
// 		}
// 	}

	public function index()
	{
		$logged_in_employee_info = $this->Employee->get_logged_in_employee_info();
		$this->load->model("Branch", "br");
		$brDet = $this->br->branch_details($logged_in_employee_info->branch_id);
		$this->session->set_userdata("branch_id", $logged_in_employee_info->branch_id);
		$this->session->set_userdata("branch_name", $brDet->location_name);
		$data = array();
		$this->load->model('reports/Specific_employee');
		$model = $this->Specific_employee;
		$data['expiryItemsCount'] = $model->getExpiryItemsCount(90, $logged_in_employee_info->branch_id);

		//getBelowReorderLevelCount
		$this->load->model('reports/Detailed_receivings');
		$model = $this->Detailed_receivings;
		$data['reorderLevelItemsCount'] = $model->getBelowReorderLevelCount($logged_in_employee_info->branch_id);


		// Graph Data Start
		$employee_id = 'all';
		$location_id = $logged_in_employee_info->branch_id;
		//$location_id = 'all';
		$sale_type = 'all';
		$credit = 'all';
		$vatable = 'all';
		$customer_id = 'all';
		$discount = 'all';
		$payment_type = 'all';

		$supplier = 'all';
		$receiving_type = 'receiving';

		/*$from_location_id ='all'; 
		$to_location_id = 'all';*/
		$from_location_id = $location_id;
		$to_location_id = 'all';

		for ($i = 11; $i >= 1; $i--) {
			$start_date = date("Y-m-d", strtotime(date('Y-m-01') . " -$i months"));
			$end_date = date("Y-m-t", strtotime(date('Y-m-01') . " -$i months"));

			// Start Sale Report Graph
			$inputs = array('start_date' => $start_date, 'end_date' => $end_date, 'employee_id' => $employee_id, 'location_id' => $location_id, 'sale_type' => $sale_type,  'credit' => $credit, 'vatable' => $vatable, 'customer_id' => $customer_id, 'discount' => $discount, 'payment_type' => $payment_type);
			$this->load->model('reports/Specific_employee');
			$model = $this->Specific_employee;

			$report_data = $model->getSalesData($inputs);

			$totals = array(
				'total' => 0
			);

			foreach ($report_data as $row) {
				$totals['total'] = $totals['total'] + $row['amount'] - $row['discount'];
			}

			$salesvalue[] = $totals['total'];
			// End Sale Report Graph




			// Start Recieving Report Graph
			$recieving_inputs = array('start_date' => $start_date, 'end_date' => $end_date, 'receiving_type' => $receiving_type, 'location_id' => $location_id, 'employee_id' => $employee_id, 'supplier' => $supplier);

			$this->load->model('reports/Detailed_receivings');
			$recieving_model = $this->Detailed_receivings;

			$recieving_report_data = $recieving_model->getAllReceivings($recieving_inputs);

			$total = 0;
			foreach ($recieving_report_data as $key => $row) {
				//add current to the overral total
				$total += $row['cost'];
			}

			$recieving_report_value[] = $total;
			// End Recieving Report Graph

			// Start Transfer Report Graph

			$transfer_inputs = array('start_date' => $start_date, 'end_date' => $end_date, 'employee_id' => $employee_id, 'from_location_id' => $from_location_id, 'to_location_id' => $to_location_id);

			$this->load->model('reports/Detailed_receivings');
			$model = $this->Detailed_receivings;

			$transfer_data = $model->getTransferData($transfer_inputs);

			$transfer_total = 0;
			foreach ($transfer_data as $row) {
				$transfer_total += $row['total'];
			}

			$transfer_total_value[] = $transfer_total;

			// End Transfer Report Graph
		}

		$date = new DateTime('now');
		$date->modify('first day of this month');

		$start_date = $date->format('Y-m-d');
		$date->modify('last day of this month');

		$end_date = $date->format('Y-m-t');

		// Start Sale Report Graph
		$inputs = array('start_date' => $start_date, 'end_date' => $end_date, 'employee_id' => $employee_id, 'location_id' => $location_id, 'sale_type' => $sale_type,  'credit' => $credit, 'vatable' => $vatable, 'customer_id' => $customer_id, 'discount' => $discount, 'payment_type' => $payment_type);
		$this->load->model('reports/Specific_employee');
		$model = $this->Specific_employee;

		$report_data = $model->getSalesData($inputs);

		$totals = array(
			'total' => 0
		);

		foreach ($report_data as $row) {
			$totals['total'] = $totals['total'] + $row['amount'] - $row['discount'];
		}

		$salesvalue[] = $totals['total'];
		// Start Sale Report Graph



		// Start Recieving Report Graph
		$recieving_inputs = array('start_date' => $start_date, 'end_date' => $end_date, 'receiving_type' => $receiving_type, 'location_id' => $location_id, 'employee_id' => $employee_id, 'supplier' => $supplier);

		$this->load->model('reports/Detailed_receivings');
		$recieving_model = $this->Detailed_receivings;

		$recieving_report_data = $recieving_model->getAllReceivings($recieving_inputs);

		$total = 0;
		foreach ($recieving_report_data as $key => $row) {
			//add current to the overral total
			$total += $row['cost'];
		}

		$recieving_report_value[] = $total;
		// End Recieving Graph


		// Start Transfer Report Graph

		$transfer_inputs = array('start_date' => $start_date, 'end_date' => $end_date, 'employee_id' => $employee_id, 'from_location_id' => $from_location_id, 'to_location_id' => $to_location_id);

		$this->load->model('reports/Detailed_receivings');
		$model = $this->Detailed_receivings;

		$transfer_data = $model->getTransferData($transfer_inputs);

		$transfer_total = 0;
		foreach ($transfer_data as $row) {
			$transfer_total += $row['total'];
		}

		$transfer_total_value[] = $transfer_total;

		// End Transfer Report Graph

		// Graph Data End



		//added this for permission control
		if (($logged_in_employee_info->role) == 3) {
			$data['sales'] = $salesvalue;
			$data['recieving'] = $recieving_report_value;
			$data['transfer'] = $transfer_total_value;
			// echo "<pre>";
			//         print_r($data); exit();
			$this->load->view('admin_dash', $data);
		} elseif (($logged_in_employee_info->role) == 7) {
			$this->load->view('cashier_dash', $data);
		} elseif (($logged_in_employee_info->role) == 4) {
			$this->load->view('invent_home', $data);
		} elseif (($logged_in_employee_info->role) == 6) {
			$this->load->view('lab_account_home', $data);
		} elseif (($logged_in_employee_info->role) == 9) {
			$this->load->view('lab_result_home', $data);
		} elseif (($logged_in_employee_info->role) == 5) {
			$this->load->view('sales_home', $data);
		} elseif (($logged_in_employee_info->role) == 10) {
			$this->load->view('md', $data);
		} elseif (($logged_in_employee_info->role) == 13 || ($logged_in_employee_info->role) == 14) {
			$this->load->view('manager', $data);
		}
		//		elseif (($logged_in_employee_info->role) == 14) {
		//			$this->load->view('manager', $data);
		//		}
		elseif (($logged_in_employee_info->role) == 12) {
			$this->load->view('account', $data);
		} else {
			//this is for role number 0 or 14

			//lekan's comment: this also serve custom roles


			$this->load->view('home', $data);
		}
	}
	public function check_stock()
	{
		$today = date("Y-m-d");
		$lastDay = date("t", strtotime($today));
		$firstDay = 03;

		$dayOfToday = explode("-", $today);

		//		if ($lastDay == $dayOfToday[2]) {
		//			//record closing stock
		//			$this->Item->record_stock(date("m"), date("Y"), false);
		//		} else
		if ($firstDay == $dayOfToday[2]) {
			//record opening stock
			$branch_id = $this->Employee->get_logged_in_employee_info()->branch_id;
			$this->Item->record_stock(date("Y-m-d H:i:s"), $branch_id);
		}
	}

	public function logout()
	{
		$this->track_page('logout', 'logout');

		$this->Employee->logout();
	}
}
