<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Sale_lib
{
	private $CI;

	public function __construct()
	{
		$this->CI = &get_instance();
		$this->CI->load->library('tax_lib');
		$this->CI->load->model('enums/Rounding_code');
	}
	public function set_modulecart($cart_data)
	{
		$this->CI->session->set_userdata('module_cart', $cart_data);
	}
	public function empty_modulecart()
	{
		$this->CI->session->unset_userdata('module_cart');
	}
	public function get_modulecart()
	{
		if (!$this->CI->session->userdata('module_cart')) {
			$this->set_modulecart(array());
		}

		return $this->CI->session->userdata('module_cart');
	}
	public function set_balance_id($cart_data)
	{
		$this->CI->session->set_userdata('balance_id', $cart_data);
	}
	public function empty_balance_id()
	{
		$this->CI->session->unset_userdata('balance_id');
	}
	public function get_balance_id()
	{
		if (!$this->CI->session->userdata('balance_id')) {
			$this->set_balance_id(array());
		}

		return $this->CI->session->userdata('balance_id');
	}
	public function set_pill($cart_data)
	{
		$this->CI->session->set_userdata('pill_cart', $cart_data);
	}
	public function empty_pill()
	{
		$this->CI->session->unset_userdata('pill_cart');
	}
	public function get_pill()
	{
		if (!$this->CI->session->userdata('pill_cart')) {
			$this->set_pill(array());
		}

		return $this->CI->session->userdata('pill_cart');
	}

	//pricer check
	public function set_price_check($item)
	{
		$this->CI->session->set_userdata('price_check', $item);
	}
	public function empty_price_check()
	{
		$this->CI->session->unset_userdata('price_check');
	}
	public function get_price_check()
	{
		if (!$this->CI->session->userdata('price_check')) {
			$this->set_price_check(array());
		}

		return $this->CI->session->userdata('price_check');
	}

	public function get_line_sequence_options()
	{
		return array(

			'0' => $this->CI->lang->line('sales_entry'),
			'1' => $this->CI->lang->line('sales_group_by_type'),
			'2' => $this->CI->lang->line('sales_group_by_category')
		);
	}

	public function get_register_mode_options()
	{
		return array(
			'sale' => $this->CI->lang->line('sales_receipt'),
			'sale_invoice' => $this->CI->lang->line('sales_invoice'),
			'sale_quote' => $this->CI->lang->line('sales_quote')
		);
	}

	public function get_cart()
	{
		if (!$this->CI->session->userdata('sales_cart')) {
			$this->set_cart(array());
		}

		return $this->CI->session->userdata('sales_cart');
	}
	public function register_return($line){
        if (!$this->CI->session->userdata('return_register')) {
            $this->CI->session->set_userdata('return_register', [$line]);
        }else{
            $registered = $this->CI->session->userdata('return_register');
            $registered[] = $line;
            $this->CI->session->set_userdata('return_register', $registered);
        }
    }
    public function remove_registered($line){
	    $registered = $this->get_registered_returns();
	    if(($key = array_search($line,$registered)) !== false){
	        unset($registered[$key]);
        }
        $this->CI->session->set_userdata('return_register', $registered);
	}
	public function clear_registered_returns(){
        unset($_SESSION['return_register']);
        unset($_SESSION['coppyitems']);
    }
    public function get_registered_returns(){
        if (!$this->CI->session->userdata('return_register')) {
            $this->CI->session->set_userdata('return_register', []);
        }
        return $this->CI->session->userdata('return_register');
    }
	public function get_lab_accountcart()
	{
		if (!$this->CI->session->userdata('lab_accountcart')) {
			$this->set_lab_accountcart(array());
		}

		return $this->CI->session->userdata('lab_accountcart');
	}
	public function get_lab_resultcart()
	{
		if (!$this->CI->session->userdata('lab_resultcart')) {
			$this->set_lab_resultcart(array());
		}

		return $this->CI->session->userdata('lab_resultcart');
	}
	public function get_labcart()
	{
		if (!$this->CI->session->userdata('lab_cart')) {
			$this->set_labcart(array());
		}

		return $this->CI->session->userdata('lab_cart');
	}



	public function sort_and_filter_cart($cart)
	{
		if (empty($cart)) {
			return $cart;
		}

		$filtered_cart = array();

		foreach ($cart as $k => $v) {
			if ($v['print_option'] == '0') {
				$filtered_cart[] = $v;
			}
		}

		// Entry sequence (this will render kits in the expected sequence)
		if ($this->CI->config->item('line_sequence') == '0') {
			$sort = array();
			foreach ($filtered_cart as $k => $v) {
				$sort['line'][$k] = $v['line'];
			}
			array_multisort($sort['line'], SORT_ASC, $filtered_cart);
		}
		// Group by Stock Type (nonstock first - type 1, stock next - type 0)
		elseif ($this->CI->config->item('line_sequence') == '1') {
			$sort = array();
			foreach ($filtered_cart as $k => $v) {
				$sort['stock_type'][$k] = $v['stock_type'];
				$sort['description'][$k] = $v['description'];
				$sort['name'][$k] = $v['name'];
			}
			array_multisort($sort['stock_type'], SORT_DESC, $sort['description'], SORT_ASC, $sort['name'], SORT_ASC . $filtered_cart);
		}
		// Group by Item Category
		elseif ($this->CI->config->item('line_sequence') == '2') {
			$sort = array();
			foreach ($filtered_cart as $k => $v) {
				$sort['category'][$k] = $v['stock_type'];
				$sort['description'][$k] = $v['description'];
				$sort['name'][$k] = $v['name'];
			}
			array_multisort($sort['category'], SORT_DESC, $sort['description'], SORT_ASC, $sort['name'], SORT_ASC, $filtered_cart);
		}
		// Group by entry sequence in descending sequence (the Standard)
		else {
			$sort = array();
			foreach ($filtered_cart as $k => $v) {
				$sort['line'][$k] = $v['line'];
			}
			array_multisort($sort['line'], SORT_ASC, $filtered_cart);
		}

		return $filtered_cart;
	}

	public function set_cart($cart_data,$item_ids = [])
	{
		$this->CI->session->set_userdata('sales_cart', $cart_data);
        $this->CI->session->set_userdata('cart_items_ids', $item_ids);
	}
	public function set_lab_resultcart($cart_data)
	{
		$this->CI->session->set_userdata('lab_resultcart', $cart_data);
	}
	public function set_lab_accountcart($cart_data)
	{
		$this->CI->session->set_userdata('lab_accountcart', $cart_data);
	}
	public function set_labcart($cart_data)
	{
		$this->CI->session->set_userdata('lab_cart', $cart_data);
	}


	public function empty_cart()
	{
		$this->CI->session->unset_userdata('sales_cart');
	}
	public function empty_lab_accountcart()
	{
		$this->CI->session->unset_userdata('lab_accountcart');
	}

	public function empty_labcart()
	{
		$this->CI->session->unset_userdata('lab_cart');
	}
	public function empty_lab_resultcart()
	{
		$this->CI->session->unset_userdata('lab_resultcart');
	}


	public function get_comment()
	{
		// avoid returning a NULL that results in a 0 in the comment if nothing is set/available
		$comment = $this->CI->session->userdata('sales_comment');

		return empty($comment) ? '' : $comment;
	}

	public function set_comment($comment)
	{
		$this->CI->session->set_userdata('sales_comment', $comment);
	}

	public function clear_comment()
	{
		$this->CI->session->unset_userdata('sales_comment');
	}

	public function get_invoice_number()
	{
		return $this->CI->session->userdata('sales_invoice_number');
	}

	public function get_quote_number()
	{
		return $this->CI->session->userdata('sales_quote_number');
	}

	public function set_invoice_number($invoice_number, $keep_custom = FALSE)
	{
		$current_invoice_number = $this->CI->session->userdata('sales_invoice_number');
		if (!$keep_custom || empty($current_invoice_number)) {
			$this->CI->session->set_userdata('sales_invoice_number', $invoice_number);
		}
	}

	public function set_quote_number($quote_number, $keep_custom = FALSE)
	{
		$current_quote_number = $this->CI->session->userdata('sales_quote_number');
		if (!$keep_custom || empty($current_quote_number)) {
			$this->CI->session->set_userdata('sales_quote_number', $quote_number);
		}
	}

	public function clear_invoice_number()
	{
		$this->CI->session->unset_userdata('sales_invoice_number');
	}

	public function clear_quote_number()
	{
		$this->CI->session->unset_userdata('sales_quote_number');
	}

	public function set_suspended_id($suspended_id)
	{
		$this->CI->session->set_userdata('suspended_id', $suspended_id);
	}

	public function get_suspended_id()
	{
		return $this->CI->session->userdata('suspended_id');
	}

	public function is_invoice_mode()
	{
		return ($this->CI->session->userdata('sales_invoice_number_enabled') == 'true' ||
			$this->CI->session->userdata('sales_mode') == 'sale_invoice' || ($this->CI->session->userdata('sales_invoice_number_enabled') == '1') &&
			$this->CI->config->item('invoice_enable') == TRUE);
	}

	public function is_sale_by_receipt_mode()
	{
		return ($this->CI->session->userdata('sales_mode') == 'sale');
	}

	public function is_quote_mode()
	{
		return ($this->CI->session->userdata('sales_mode') == 'sale_quote');
	}

	public function set_invoice_number_enabled($invoice_number_enabled)
	{
		return $this->CI->session->set_userdata('sales_invoice_number_enabled', $invoice_number_enabled);
	}

	public function is_print_after_sale()
	{
		return ($this->CI->session->userdata('sales_print_after_sale') == 'true' ||
			$this->CI->session->userdata('sales_print_after_sale') == '1');
	}

	public function set_print_after_sale($print_after_sale)
	{
		return $this->CI->session->set_userdata('sales_print_after_sale', $print_after_sale);
	}

	public function get_email_receipt()
	{
		return $this->CI->session->userdata('sales_email_receipt');
	}

	public function set_email_receipt($email_receipt)
	{
		$this->CI->session->set_userdata('sales_email_receipt', $email_receipt);
	}

	public function clear_email_receipt()
	{
		$this->CI->session->unset_userdata('sales_email_receipt');
	}

	// Multiple Payments
	public function get_payments()
	{
		if (!$this->CI->session->userdata('sales_payments')) {
			$this->set_payments(array());
		}

		return $this->CI->session->userdata('sales_payments');
	}
	public function get_sales_id()
	{
		if (!$this->CI->session->userdata('sales_id')) {
			$this->set_sales_id(array());
		}

		return $this->CI->session->userdata('sales_id');
	}
	public function set_sales_id($payments_data)
	{
		$this->CI->session->set_userdata('sales_id', $payments_data);
	}
	public function empty_sales_id()
	{
		$this->CI->session->unset_userdata('sales_id');
	}

	public function get_transfer_id()
	{
		if (!$this->CI->session->userdata('transfer_id')) {
			$this->set_transfer_id(array());
		}

		return $this->CI->session->userdata('transfer_id');
	}
	public function set_transfer_id($payments_data)
	{
		$this->CI->session->set_userdata('transfer_id', $payments_data);
	}
	public function empty_transfer_id()
	{
		$this->CI->session->unset_userdata('transfer_id');
	}


	// Multiple Payments
	public function set_payments($payments_data)
	{
		$this->CI->session->set_userdata('sales_payments', $payments_data);
	}

	// Multiple Payments
	public function add_payment($payment_id, $payment_amount)
	{
		$payments = $this->get_payments();
		if (isset($payments[$payment_id])) {
			//payment_method already exists, add to payment_amount
			$payments[$payment_id]['payment_amount'] = bcadd($payments[$payment_id]['payment_amount'], $payment_amount);
		} else {
			//add to existing array
			$payment = array($payment_id => array('payment_type' => $payment_id, 'payment_amount' => $payment_amount));

			$payments += $payment;
		}

		$this->set_payments($payments);
	}

	// Multiple Payments
	public function edit_payment($payment_id, $payment_amount)
	{
		$payments = $this->get_payments();
		if (isset($payments[$payment_id])) {
			$payments[$payment_id]['payment_type'] = $payment_id;
			$payments[$payment_id]['payment_amount'] = $payment_amount;
			$this->set_payments($payments);

			return TRUE;
		}

		return FALSE;
	}

	// Multiple Payments
	public function delete_payment($payment_id)
	{
		$payments = $this->get_payments();
		unset($payments[urldecode($payment_id)]);
		$this->set_payments($payments);
	}

	// Multiple Payments
	public function empty_payments()
	{
		$this->CI->session->unset_userdata('sales_payments');
	}

	// Multiple Payments
	public function get_payments_total()
	{
		$subtotal = 0;
		$this->reset_cash_flags();
		foreach ($this->get_payments() as $payments) {
			$subtotal = bcadd($payments['payment_amount'], $subtotal);
			if ($this->CI->session->userdata('cash_rounding') && $this->CI->lang->line('sales_cash') != $payments['payment_type']) {
				$this->CI->session->set_userdata('cash_rounding', 0);
			}
		}

		return $subtotal;
	}

	public function get_cash_rounding()
	{
	}

	/*
	 * Returns 'subtotal', 'total', 'cash_total', 'payment_total', 'amount_due', 'cash_amount_due', 'paid_in_full'
	 * 'subtotal', 'discounted_subtotal', 'tax_exclusive_subtotal'
	 */
	public function get_totals_lab()
	{
		$cash_rounding = $this->CI->session->userdata('cash_rounding');

		$totals = array();

		$subtotal = 0;
		$discounted_subtotal = 0.00;
		$tax_exclusive_subtotal = 0;
		$initial_cost = 0.00;
		foreach ($this->get_labcart() as $item) {
			//$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
			//$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
			if ($item['stock_name'] == "WholeSale") {
				$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], FALSE));
			} else {
				$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
			}
			if ($item['stock_name'] == "WholeSale") {
				$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], TRUE));
			} else {
				$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
			}
			if ($this->CI->config->config['tax_included']) {
				$tax_exclusive_subtotal = bcadd($tax_exclusive_subtotal, $this->get_item_total_tax_exclusive($item['item_id'], $item['quantity'], $item['price'], $item['discount'], TRUE));
			}
		}

		$totals['subtotal'] = $subtotal;
		$totals['discounted_subtotal'] = $discounted_subtotal;
		$totals['tax_exclusive_subtotal'] = $tax_exclusive_subtotal;

		$total = $discounted_subtotal;
		if ($this->CI->config->config['tax_included']) {
			$totals['total'] = $total;
		} else {
			foreach ($this->get_taxes() as $sales_tax) {
				$total = bcadd($total, $sales_tax['sale_tax_amount']);
			}
			$totals['total'] = $total;
		}

		if ($cash_rounding) {
			$cash_total = $this->check_for_cash_rounding($total);
			$totals['cash_total'] = $cash_total;
		} else {
			$cash_total = $total;
		}

		$totals['cash_total'] = $cash_total;

		$payment_total = $this->get_payments_total();
		$totals['payment_total'] = $payment_total;

		$amount_due = bcsub($total, $payment_total);
		$totals['amount_due'] = $amount_due;

		$cash_amount_due = bcsub($cash_total, $payment_total);
		$totals['cash_amount_due'] = $cash_amount_due;

		if ($cash_rounding) {
			$current_due = $cash_amount_due;
		} else {
			$current_due = $amount_due;
		}

		if ($this->get_mode() == 'return') {
			$totals['payments_cover_total'] = $current_due >= 0;
		} else {
			$totals['payments_cover_total'] =  $current_due <= 0;
		}

		return $totals;
	}
	public function get_totals_old()
	{
		$cash_rounding = $this->CI->session->userdata('cash_rounding');

		$totals = array();

		$subtotal = 0;
		$discounted_subtotal = 0;
		$total_vat = 0.00;
		$customer_id = $this->get_customer();
		foreach ($this->get_cart() as $item) {

			if (strtolower($item['stock_name']) == "wholesale") {
				$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], FALSE));
			} else {
				//if customer has a sale_markup
				if ($customer_id > 0) {
					$customer = $this->CI->Customer->get_info($customer_id);
					
					if($customer->company_id > 0){
						$company = $this->CI->Customer->get_company_info($customer->company_id);
						if ($company->sale_markup > 0) {
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $company->sale_markup, $item['discount'], FALSE));
						}
						else{
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
						}
					}elseif ($customer->sale_markup > 0) {
						$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $customer->sale_markup, $item['discount'], FALSE));
					}else{
						$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
					}


					//normal code
					// if ($customer->sale_markup > 0) {
					// 	$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $customer->sale_markup, $item['discount'], FALSE));
					// }else{
					// 	$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
					// }
				}else{
					$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
				}
			}

			//another
			if (strtolower($item['stock_name']) == "wholesale") {
				$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], TRUE));
			} else {
				//if customer has a sale_markup
				if ($customer_id > 0) {
					$customer = $this->CI->Customer->get_info($customer_id);
					// if sale markup

					if($customer->company_id > 0){
						$company = $this->CI->Customer->get_company_info($customer->company_id);
						if ($company->sale_markup > 0) {
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'] * $company->sale_markup, $item['discount'], TRUE));
						}
						else{
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
						}
					}elseif ($customer->sale_markup > 0) {
						$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'] * $customer->sale_markup, $item['discount'], TRUE));
					}else{
						$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
					}


					//normal code
					// if ($customer->sale_markup > 0) {
					// 	$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'] * $customer->sale_markup, $item['discount'], TRUE));
					// }else{
					// 	$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
					// }
				}else{
					$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
				}
			}

			// calculate VAT for VATable items
			if (strtolower($item["apply_vat"]) == "yes") {

				$total_vat += $item['vat']; //vat is already calculated when an item is added or edited
			}
		}

		//check whether the customer has discount percent.
		//if yes, calculate and remove it from the total the customer supposed to pay
		// $customer_id = $this->get_customer();
		if ($customer_id > 0) {
			$customer = $this->CI->Customer->get_info($customer_id);

			if($customer->company_id > 0){
				$company = $this->CI->Customer->get_company_info($customer->company_id);
				if ($company->discount > 0) {
					// $customer_discount = round(($company->discount / 100) * $discounted_subtotal, 2);
					$customer_discount = round(($company->discount / 100) * $discounted_subtotal, 3); //by3dp
					$discounted_subtotal = $discounted_subtotal - $customer_discount;
				}
			}elseif ($customer->discount_percent > 0) {
				// $customer_discount = round(($customer->discount_percent / 100) * $discounted_subtotal, 2);
				$customer_discount = round(($customer->discount_percent / 100) * $discounted_subtotal, 3); //by3dp
				$discounted_subtotal = $discounted_subtotal - $customer_discount;
			}
		}

		//normal code
		// if ($customer_id > 0) {
		// 	$customer = $this->CI->Customer->get_info($customer_id);
		// 	if ($customer->discount_percent > 0) {
		// 		$customer_discount = round(($customer->discount_percent / 100) * $discounted_subtotal, 2);
		// 		$discounted_subtotal = $discounted_subtotal - $customer_discount;
		// 	}
		// }

		$total_vat = $total_vat;

		$discounted_subtotal = $discounted_subtotal;
		$totals['total_vat'] = $total_vat;
		$totals['subtotal'] = $subtotal;
		$totals['discounted_subtotal'] = $discounted_subtotal;

		$total = $discounted_subtotal;
		$totals['total'] = $total;

		if ($cash_rounding) {
			$cash_total = $this->check_for_cash_rounding($total);
			$totals['cash_total'] = $cash_total;
		} else {
			$cash_total = $total;
		}

		$totals['cash_total'] = $cash_total;

		$payment_total = $this->get_payments_total();
		$totals['payment_total'] = $payment_total;

		$amount_due = bcsub($total + $total_vat, $payment_total);
		$totals['amount_due'] = $amount_due;

		$cash_amount_due = bcsub($cash_total + $total_vat, $payment_total);
		$totals['cash_amount_due'] = $cash_amount_due;

		if ($cash_rounding) {
			$current_due = $cash_amount_due;
		} else {
			$current_due = $amount_due;
		}

		if ($this->get_mode() == 'return') {
			$totals['payments_cover_total'] = $current_due >= 0;
		} else {
			$totals['payments_cover_total'] =  $current_due <= 0;
		}

		return $totals;
	}

	public function get_totals_old_vat()
	{
		$cash_rounding = $this->CI->session->userdata('cash_rounding');

		$totals = array();

		$subtotal = 0;
		$discounted_subtotal = 0;
		$total_vat = 0.00;
		$customer_id = $this->get_customer();

		//new VAT implementation

		//remove VAT price from VATable items
		//use the remainder as VAT
		//set the VAT price into VAT
		foreach ($this->get_cart() as $item) {

			//get subtotals
			if (strtolower($item['stock_name']) == "wholesale") {
				$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], FALSE));
			} else {

				//if customer exists
					//if customer has company
						//if company has a markup: price = cost * company_salemarkup
						//else: price =  selling price
					//else if customer has markup: price = cost * customer_salemarkup
					//else: price = selling price
				//else: price = selling price

				if($customer_id > 0){
					$customer = $this->CI->Customer->get_info($customer_id);
					if($customer->company_id > 0){
						$company = $this->CI->Customer->get_company_info($customer->company_id);
						if ($company->markup > 0) {
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $company->markup, $item['discount'], FALSE));
						}else{
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
						}
					}elseif($customer->sale_markup > 0){
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $customer->sale_markup, $item['discount'], FALSE));
						}else{
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
						}
				}else{
					$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
				}
			}
			
			//get discounted total
			if (strtolower($item['stock_name']) == "wholesale") {
				$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], TRUE));
			} else {

				if($customer_id > 0){
					$customer = $this->CI->Customer->get_info($customer_id);
					if($customer->company_id > 0){
						$company = $this->CI->Customer->get_company_info($customer->company_id);
						if ($company->markup > 0) {
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $company->markup, $item['discount'], TRUE));
						}else{
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
						}
					}elseif($customer->sale_markup > 0){
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $customer->sale_markup, $item['discount'], TRUE));
						}else{
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
						}
				}else{
					$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
				}
			}

			// calculate VAT for VATable items
			if (strtolower($item["apply_vat"]) == "yes") {
				$total_vat += $item['vat']; //vat is already calculated when an item is added or edited
				// $total_vat += get_nearest_five($item['vat']); //vat is already calculated when an item is added or edited
				//get_nearest_five
			}
		}

		//check whether the customer has discount percent.
		//if yes, calculate and remove it from the total the customer supposed to pay
		// $customer_id = $this->get_customer();
		if ($customer_id > 0) {
			$customer = $this->CI->Customer->get_info($customer_id);
			if($customer->company_id > 0){
				$company = $this->CI->Customer->get_company_info($customer->company_id);
				if($company->discount > 0){
					// $customer_discount = round(($company->discount / 100) * $discounted_subtotal, 2);
					$customer_discount = round(($company->discount / 100) * $discounted_subtotal, 3); //by3dp
					$discounted_subtotal = $discounted_subtotal - $customer_discount;
				}
			}elseif ($customer->discount_percent > 0) {
				// $customer_discount = round(($customer->discount_percent / 100) * $discounted_subtotal, 2);
				$customer_discount = round(($customer->discount_percent / 100) * $discounted_subtotal, 3); //by3dp
				$discounted_subtotal = $discounted_subtotal - $customer_discount;
			}
		}

		// $total_vat = get_nearest_five($total_vat);
		$total_vat = $total_vat;

		$discounted_subtotal = $discounted_subtotal;
		$totals['total_vat'] = $total_vat;
		$totals['subtotal'] = $subtotal;
		$totals['discounted_subtotal'] = $discounted_subtotal;

		$total = $discounted_subtotal;
		$totals['total'] = $total;

		if ($cash_rounding) {
			$cash_total = $this->check_for_cash_rounding($total);
			$totals['cash_total'] = $cash_total;
		} else {
			$cash_total = $total;
		}

		$totals['cash_total'] = $cash_total;

		$payment_total = $this->get_payments_total();
		$totals['payment_total'] = $payment_total;

		$amount_due = bcsub($total + $total_vat, $payment_total);
		$totals['amount_due'] = $amount_due;

		$cash_amount_due = bcsub($cash_total + $total_vat, $payment_total);
		$totals['cash_amount_due'] = $cash_amount_due;

		if ($cash_rounding) {
			$current_due = $cash_amount_due;
		} else {
			$current_due = $amount_due;
		}

		if ($this->get_mode() == 'return') {
			$totals['payments_cover_total'] = $current_due >= 0;
		} else {
			$totals['payments_cover_total'] =  $current_due <= 0;
		}

		return $totals;
	}
	
	public function get_totals()
	{
		$cash_rounding = $this->CI->session->userdata('cash_rounding');

		$totals = array();

		$subtotal = 0;
		$discounted_subtotal = 0;
		$total_vat = 0.00;
		$customer_id = $this->get_customer();
		$sale_mode = $this->get_mode();

		//new VAT implementation

		//remove VAT price from VATable items
		//use the remainder as VAT
		//set the VAT price into VAT
		foreach ($this->get_cart() as $item) {

			//get subtotals
			if (strtolower($item['stock_name']) == "wholesale") {
				$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], FALSE));
			} else {

				if($customer_id > 0){
					$customer = $this->CI->Customer->get_info($customer_id);
					if($customer->company_id > 0){
						$company = $this->CI->Customer->get_company_info($customer->company_id);
						if ($company->markup > 0) {
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $company->markup, $item['discount'], FALSE));
						}else{
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
						}
					}elseif($customer->sale_markup > 0){
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $customer->sale_markup, $item['discount'], FALSE));
						}else{
							$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
						}
				}else{
					$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
				}
			}
			
			//get discounted total
			if (strtolower($item['stock_name']) == "wholesale") {
				$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], TRUE));
			} else {

				if($customer_id > 0){
					$customer = $this->CI->Customer->get_info($customer_id);
					if($customer->company_id > 0){
						$company = $this->CI->Customer->get_company_info($customer->company_id);
						if ($company->markup > 0) {
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $company->markup, $item['discount'], TRUE));
						}else{
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
						}
					}elseif($customer->sale_markup > 0){
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['cost'] * $customer->sale_markup, $item['discount'], TRUE));
						}else{
							$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
						}
				}else{
					$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
				}
			}

			// calculate VAT for VATable items
			if (strtolower($item["apply_vat"]) == "yes") {
				$total_vat += $item['vat']; //vat is already calculated when an item is added or edited
				// $total_vat += get_nearest_five($item['vat']); //vat is already calculated when an item is added or edited
				//get_nearest_five
			}
		}

		//check whether the customer has discount percent.
		//if yes, calculate and remove it from the total the customer supposed to pay
		// $customer_id = $this->get_customer();
		if ($customer_id > 0) {
			$customer = $this->CI->Customer->get_info($customer_id);
			if($customer->company_id > 0){
				$company = $this->CI->Customer->get_company_info($customer->company_id);
				if($company->discount > 0){
					$customer_discount = round(($company->discount / 100) * $discounted_subtotal, 3); //by3dp
					// $customer_discount = round(($company->discount / 100) * $discounted_subtotal, 2);
					$discounted_subtotal = $discounted_subtotal - $customer_discount;
				}
			}elseif ($customer->discount_percent > 0) {
				$customer_discount = round(($customer->discount_percent / 100) * $discounted_subtotal, 3); //by3dp
				// $customer_discount = round(($customer->discount_percent / 100) * $discounted_subtotal, 2);
				$discounted_subtotal = $discounted_subtotal - $customer_discount;
			}
		}

		// $total_vat = get_nearest_five($total_vat);
//		$total_vat = $total_vat;

//		$discounted_subtotal = $discounted_subtotal;
		$totals['total_vat'] = $total_vat;
		$totals['subtotal'] = $subtotal;
		$totals['discounted_subtotal'] = $discounted_subtotal;

		$total = $discounted_subtotal;
		$totals['total'] = $total;

		if ($cash_rounding) {
			$cash_total = $this->check_for_cash_rounding($total);
			$totals['cash_total'] = $cash_total;
		} else {
			$cash_total = $total;
		}

		$totals['cash_total'] = $cash_total;

		$payment_total = $this->get_payments_total();
		$totals['payment_total'] = $payment_total;

//		echo "Payment Total: ".$payment_total;
//        echo "Total: ".$total;
//        echo "Vat Total: ".$total_vat;
//        exit();

		$amount_due = bcsub($total + $total_vat, $payment_total);
		$totals['amount_due'] = $amount_due;

		$cash_amount_due = bcsub($cash_total + $total_vat, $payment_total);
		$totals['cash_amount_due'] = $cash_amount_due;

		if ($cash_rounding) {
			$current_due = $cash_amount_due;
		} else {
			$current_due = $amount_due;
		}

		if ($this->get_mode() == 'return') {
			$totals['payments_cover_total'] = $current_due >= 0;
		} else {
			$totals['payments_cover_total'] =  $current_due <= 0;
		}

		return $totals;
	}

	function get_nearest_five($amount)
{
    // $amount = round($amount);
    $amount = ceil($amount);
    $remaining_to_reach_five = 5 - ($amount % 5);
    // if ($remaining_to_reach_five != 5 && $remaining_to_reach_five != 0) {
    if ($remaining_to_reach_five != 5) {
        return $amount + $remaining_to_reach_five;
    } else {
        return $amount;
    }
}


	public function get_totals_pill()
	{
		$cash_rounding = $this->CI->session->userdata('cash_rounding');

		$totals = array();

		$subtotal = 0;
		$discounted_subtotal = 0;
		$tax_exclusive_subtotal = 0;
		foreach ($this->get_pill() as $item) {
			//$subtotal = bcadd($subtotal, $this->get_item_total($item['no_of_days'], $item['price'], $item['reminder_value'], FALSE));
			$discounted_subtotal = bcadd($discounted_subtotal, (24 / $item['reminder_value']) * $item['no_of_days'] * $item['price']);

			$subtotal = (24 / $item['reminder_value']) * $item['no_of_days'] * $item['price'];


			//$discounted_subtotal =(24/$item['reminder_value'])*$item['no_of_days']*$item['price'];


		}

		$totals['subtotal'] = $subtotal;
		$totals['discounted_subtotal'] = $discounted_subtotal;
		$totals['tax_exclusive_subtotal'] = $tax_exclusive_subtotal;

		$total = $discounted_subtotal;
		if ($this->CI->config->config['tax_included']) {
			$totals['total'] = $total;
		} else {
			foreach ($this->get_taxes() as $sales_tax) {
				$total = bcadd($total, $sales_tax['sale_tax_amount']);
			}
			$totals['total'] = $total;
		}

		if ($cash_rounding) {
			$cash_total = $this->check_for_cash_rounding($total);
			$totals['cash_total'] = $cash_total;
		} else {
			$cash_total = $total;
		}

		$totals['cash_total'] = $cash_total;

		$payment_total = $this->get_payments_total();
		$totals['payment_total'] = $payment_total;

		$amount_due = bcsub($total, $payment_total);
		$totals['amount_due'] = $amount_due;

		$cash_amount_due = bcsub($cash_total, $payment_total);
		$totals['cash_amount_due'] = $cash_amount_due;

		if ($cash_rounding) {
			$current_due = $cash_amount_due;
		} else {
			$current_due = $amount_due;
		}

		if ($this->get_mode() == 'return') {
			$totals['payments_cover_total'] = $current_due >= 0;
		} else {
			$totals['payments_cover_total'] =  $current_due <= 0;
		}

		return $totals;
	}





	// Multiple Payments
	public function get_amount_due()
	{
		// Payment totals need to be identified first so that we know whether or not there is a non-cash payment involved
		$payment_total = $this->get_payments_total();
		$sales_total = $this->get_total();
		$amount_due = bcsub($sales_total, $payment_total);
		$precision = $this->CI->config->item('currency_decimals');
		$rounded_due = bccomp(round($amount_due, $precision, PHP_ROUND_HALF_EVEN), 0, $precision);
		// take care of rounding error introduced by round tripping payment amount to the browser
		return $rounded_due == 0 ? 0 : $amount_due;
	}

	public function is_payment_covering_total()
	{

		if ($this->get_mode() == 'return') {
			return $this->get_amount_due() >= 0;
		} else {
			return $this->get_amount_due() <= 0;
		}
	}

	public function get_customer()
	{
		if (!$this->CI->session->userdata('sales_customer')) {
			$this->set_customer(-1);
		}

		return $this->CI->session->userdata('sales_customer');
	}

	public function set_customer($customer_id)
	{
		$this->CI->session->set_userdata('sales_customer', $customer_id);
	}

	public function remove_customer()
	{
		$this->CI->session->unset_userdata('sales_customer');
	}

	public function get_employee()
	{
		if (!$this->CI->session->userdata('sales_employee')) {
			$this->set_employee(-1);
		}

		return $this->CI->session->userdata('sales_employee');
	}

	public function set_employee($employee_id)
	{
		$this->CI->session->set_userdata('sales_employee', $employee_id);
	}

	public function remove_employee()
	{
		$this->CI->session->unset_userdata('sales_employee');
	}

	public function get_mode()
	{
		if (!$this->CI->session->userdata('sales_mode')) {
			if ($this->CI->config->config['invoice_enable'] == '1') {
				$this->set_mode($this->CI->config->config['default_register_mode']);
			} else {
				$this->set_mode('sale');
			}
		}

		return $this->CI->session->userdata('sales_mode');
	}

	public function set_mode($mode)
	{
		$this->CI->session->set_userdata('sales_mode', $mode);
		$this->change_mode_quantity_sign($mode);
	}

	public function clear_mode()
	{
		$this->CI->session->unset_userdata('sales_mode');
	}

	public function get_dinner_table()
	{
		if (!$this->CI->session->userdata('dinner_table')) {
			if ($this->CI->config->item('dinner_table_enable') == TRUE) {
				$this->set_dinner_table(1);
			}
		}

		return $this->CI->session->userdata('dinner_table');
	}

	public function set_dinner_table($dinner_table)
	{
		$this->CI->session->set_userdata('dinner_table', $dinner_table);
	}

	public function clear_table()
	{
		$this->CI->session->unset_userdata('dinner_table');
	}

	public function get_sale_location()
	{
		if (!$this->CI->session->userdata('sales_location')) {
			$this->set_sale_location($this->CI->Stock_location->get_default_location_id());
		}

		return $this->CI->session->userdata('sales_location');
	}

	public function set_sale_location($location)
	{
		$this->CI->session->set_userdata('sales_location', $location);
	}

	public function set_payment_type($payment_type)
	{
		$this->CI->session->set_userdata('payment_type', $payment_type);
	}

	public function get_payment_type()
	{
		return $this->CI->session->userdata('payment_type');
	}

	public function clear_sale_location()
	{
		$this->CI->session->unset_userdata('sales_location');
	}

	public function set_giftcard_remainder($value)
	{
		$this->CI->session->set_userdata('sales_giftcard_remainder', $value);
	}

	public function get_giftcard_remainder()
	{
		return $this->CI->session->userdata('sales_giftcard_remainder');
	}

	public function clear_giftcard_remainder()
	{
		$this->CI->session->unset_userdata('sales_giftcard_remainder');
	}

	public function set_rewards_remainder($value)
	{
		$this->CI->session->set_userdata('sales_rewards_remainder', $value);
	}

	public function get_rewards_remainder()
	{
		return $this->CI->session->userdata('sales_rewards_remainder');
	}

	public function clear_rewards_remainder()
	{
		$this->CI->session->unset_userdata('sales_rewards_remainder');
	}

	// public function add_item(&$item_id, $retail_or_whole_sale = 'retail', $quantity = 1, $item_location, $discount = 0, $price = NULL, $description = NULL, $serialnumber = NULL, $include_deleted = FALSE, $print_option = '0', $stock_type = '0',$qty_selected='retail',$reference=0)
	public function add_item(&$item_id, $quantity, $item_location, $discount = 0, $price = NULL, $description = NULL, $serialnumber = NULL, $include_deleted = FALSE, $print_option = '0', $stock_type = '0', $qty_selected = 'retail', $reference = 0, $apply_vat = "NO", $vat = 0,$new_sale = true)
	{
	    // echo 'VAT: ' . $vat . '<br />';
		$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);
		//echo "item location : ".$item_location; exit();
//		var_dump($item_info);
//		exit();
		$num_expired = $this->CI->Sale->get_total_expired_item($item_id);
		$item_quantity = $this->CI->Item_quantity->get_item_quantity($item_id,$item_location)->quantity;

		$cal=$item_quantity;
		//echo " cal : ".$cal; exit();

		if(($num_expired - $item_quantity)>= 0 && $new_sale){
		    return FALSE;
        }
		//make sure item exists		
		if (empty($item_info)) {
//			$item_id = -1;
			return FALSE;
		}
		$aj_req = $this->CI->session->userdata('aj_req');
		$last_inserted = $this->CI->session->userdata('last_inserted');
		$cart_item_ids = $this->CI->session->userdata('cart_item_ids') == null ? [] : $this->CI->session->userdata('cart_item_ids');
		if(!$last_inserted){
		    $last_inserted = 1;
        }
		$item_id = $item_info->item_id;

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_cart();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updateKey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxKey = 0;                       //Highest key so far
		$itemAlreadyInSale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updateKey = 0;                    //Key to use to update(quantity)
		if(!$aj_req){
            foreach ($items as $item) {
                //We primed the loop so maxKey is 0 the first time.
                //Also, we have stored the key in the element itself so we can compare.

                if ($maxKey < $item['line']) {
                    $maxKey = $item['line'];
                }

                if ($item['item_id'] == $item_id && $item['item_location'] == $item_location && $item['reference'] == $reference && $item['qty_selected'] == $qty_selected)
                    // if($item['item_id'] == $item_id && $item['reference']==$reference && $item['qty_selected'] == $retail_or_whole_sale)
                {
                    $itemAlreadyInSale = TRUE;
                    $updateKey = $item['line'];
                    if (!$item_info->is_serialized) {
                        $quantity = bcadd($quantity, $items[$updateKey]['quantity']);
                    }
                }
                if ($item['item_id'] == $item_id && $item['item_location'] == $item_location && $item['reference'] == $reference && $item['qty_selected'] == $qty_selected)
                    // if($item['item_id'] == $item_id && $item['reference']==$reference && $item['qty_selected'] == $retail_or_whole_sale)
                {
                    $itemAlreadyInSale = TRUE;
                    $updateKey = $item['line'];
                }
            }
        }else{
		    if(in_array($item_id,$cart_item_ids)){
		        $itemAlreadyInSale = true;
            }
        }

//		$insertkey = $maxKey + 1;
        $insertkey = $last_inserted + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.

		$vatForThisItem = 0;
		$vat_applied = $item_info->apply_vat;

		//cutomer
		$customer_id = $this->get_customer();
		
		//first, fix price
		$originalSellingPrice = $item_info->unit_price;
		$originalCostPrice = $item_info->cost_price;

		$sellingPrice = 0;
		if($customer_id > 0){
			$customer = $this->CI->Customer->get_info($customer_id);
			if($customer->company_id > 0){
				$company = $this->CI->Customer->get_company_info($customer->company_id);
				if($company->markup > 0){
					$sellingPrice = $originalCostPrice * $company->markup;
				}else{
					$sellingPrice = $originalSellingPrice;
				}
			}elseif($customer->sale_markup > 0){
				$sellingPrice = $originalCostPrice * $customer->sale_markup;
			}else{
				$sellingPrice = $originalSellingPrice;
			}
		}else{
			$sellingPrice = $originalSellingPrice;
		}

		if (is_null($price) && $reference == 0) {
			if (strtolower($item_info->apply_vat) == 'yes') {
				//new formula
				$configuredAppVat = $this->CI->config->item('vat');
//				var_dump($configuredAppVat);
//				exit();
				$vatCalc = ($configuredAppVat / 100);

				// $exclOfVat = $item_info->unit_price - round(($item_info->unit_price * $vatCalc), 3);
				// $vatForThisItem = $item_info->unit_price - $exclOfVat;

				$exclOfVat = $sellingPrice - round(($sellingPrice * $vatCalc), 3);
				$vatForThisItem = $sellingPrice - $exclOfVat;

				$totalVat = floatval($this->getTotalVat()) + $vatForThisItem;
				$this->setTotalVat($totalVat);
				$price = $exclOfVat;
			} else {
				$price = $sellingPrice;
			}
		} elseif (is_null($price) && $reference == 1) { //reference 1 means the item is pill reminder
			$price = $this->CI->config->config['price_pill'];
			//$price = 2;
		} else {
			//else, $price is not null, this happens when items are added while fetching sales history,
			//not adding items for the first time during sales
			$vat_applied = $apply_vat;
			$vatForThisItem = $vat; 
		}

		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here
		if ($print_option == '1') {
			if ($price == 0) {
				$print_option = '2';
			} else {
				$print_option = '0';
			}
		}

		$cost = $item_info->cost_price;
		$total = $this->get_item_total($quantity, $price, $discount);
		$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		
		$mode = $this->get_mode();
		if( $mode == "sale" ) {
		    $vatForThisItem = bcmul( abs($vatForThisItem), 1);
		}
		
		if( $mode == "return" ) {
		    $vatForThisItem = bcmul( abs($vatForThisItem), -1); 
		}
		
// 		echo 'Price: ' . $price . '<br />';
// 		echo 'Quantity: ' . $quantity . '<br />';
// 		echo 'Discount: ' . $discount . '<br />';
// 		echo 'Total: ' . $total . '<br />';
// 		echo 'Tax Total: ' . $vatForThisItem . '<br />';
// 		var_dump( gmp_sign($quantity) );

		//$total = $this->get_item_total($quantity, $price, $discount);
		//$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		//Item already exists and is not serialized, add to quantity
		$no_of_days = 1;
		$reminder_value = 1;
		$time_started = date('Y-m-d H:i:s');
		if (!$itemAlreadyInSale || $item_info->is_serialized) {
//		    echo "hello";
            $s_loc = $this->CI->Stock_location->get_location_name($item_location);
            $batches = $this->CI->Item->fetch_item_batches($item_id,$item_location);

            $selected_batch = $this->CI->Item->fetch_item_sale_default_batches($item_id,$item_location);
//            var_dump($batches);
//            exit();
			$item = array(
				$insertkey => array(
					'item_id' => $item_id,
					'item_location' => $item_location,
					'stock_name' => $s_loc,
					's_type'=> $s_loc == $this->CI->lang->line('wholesale')?'wholesale':'retail',
					'line' => $insertkey,
					'name' => $item_info->name,
					'item_number' => $item_info->item_number,
					'description' => $description != NULL ? $description : $item_info->description,
					'serialnumber' => $serialnumber != NULL ? $serialnumber : '',
					'allow_alt_description' => $item_info->allow_alt_description,
					'batches'=>$batches,
					'batch_no'=>$selected_batch,
					'is_serialized' => $item_info->is_serialized,
					'quantity' => $quantity,
					'qty_selected' => $qty_selected,
					'discount' => $discount,
					'in_stock' => $this->CI->Item_quantity->get_item_quantity($item_id, $item_location)->quantity,
					// 'price' => get_nearest_five($price),
					'price' => $price,
					'cost' => get_nearest_five($cost),
					'wholeprice' => get_nearest_five($item_info->whole_price),
					// 'total' => get_nearest_five($total),
					'total' => $total,
					'discounted_total' => get_nearest_five($discounted_total),
					'print_option' => '1',
					'stock_type' => $stock_type,
					'tax_category_id' => $item_info->tax_category_id,
					'time_started' => $time_started,
					'reference' => $reference,
					'reminder_value' => $reminder_value,
					'reminder_amount' => 0, //$reminder_amount,
					'no_of_days' => $no_of_days,
					'period' => 0, //$period,
					'apply_vat' => $vat_applied,
					'vat' => round($vatForThisItem, 2)
				)
			);
			//add to existing array
//            var_dump($item);
//            echo " <br> item <br>";
			$items += $item;

//			var_dump($items);
//            echo " <br> items <br>";
			$cart_item_ids[] = $item_id;
            $this->CI->session->set_userdata('last_inserted', $insertkey);
		} else {
			$line = &$items[$updateKey];
			$line['quantity'] = $quantity;
			$line['total'] = $total;
			$line['discounted_total'] = $discounted_total;
		}


		$this->set_cart($items,$item_id);
//		var_dump($items);
//		echo "<br> after set cart <br>";
//
//		var_dump($this->get_cart());
//        echo "<br> what is saved cart <br>";
//        exit();

		return TRUE;
	}

	public function recheck_items(){

		$newItems = array();
		$insertkey = 1;
		$item_location = $this->get_sale_location();

		foreach ($this->get_cart() as $item) {

			$item_id = $item['item_id'];

			$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);

			//make sure item exists		
			if (empty($item_info)) {
				$item_id = -1;
				return FALSE;
			}

			$item_id = $item_info->item_id;

			$vatForThisItem = 0;
			$vat_applied = $item_info->apply_vat;

			//start here
			$qty_type = $item['qty_selected'];
			$priceToSaleWith = 0; //we'll send this price to perform the calculation

			//check if current mode is retail or wholesale
			if ($qty_type == 'retail') {
				$priceToSaleWith = parse_decimals($item_info->unit_price);
			} else {
				$priceToSaleWith = parse_decimals($item_info->whole_price*$item_info->pack);
			}
			//ends here

			//cutomer
			$customer_id = $this->get_customer();
			
			//first, fix price
			// $originalSellingPrice = $item_info->unit_price;
			$originalSellingPrice = $priceToSaleWith;
			$originalCostPrice = $item_info->cost_price;

			$sellingPrice = 0;
			if($customer_id > 0){
				$customer = $this->CI->Customer->get_info($customer_id);
				if($customer->company_id > 0){
					$company = $this->CI->Customer->get_company_info($customer->company_id);
					if($company->markup > 0){
						$sellingPrice = $originalCostPrice * $company->markup;
					}else{
						$sellingPrice = $originalSellingPrice;
					}
				}elseif($customer->sale_markup > 0){
					$sellingPrice = $originalCostPrice * $customer->sale_markup;
				}else{
					$sellingPrice = $originalSellingPrice;
				}
			}else{
				$sellingPrice = $originalSellingPrice;
			}

			if (strtolower($item_info->apply_vat) == 'yes') {
				//new formula
				$configuredAppVat = $this->CI->config->item('vat');
				$vatCalc = ($configuredAppVat / 100);

				$exclOfVat = $sellingPrice - round(($sellingPrice * $vatCalc), 3);
				$vatForThisItem = $sellingPrice - $exclOfVat;
				
				$vatForThisItem = $item['vat']; // need to set the calculated vat

				$totalVat = floatval($this->getTotalVat()) + $vatForThisItem;
				$this->setTotalVat($totalVat);
				$price = $exclOfVat;
			} else {
				$price = $sellingPrice;
			}
			$print_option = '0';

			$cost = $item_info->cost_price;
			$total = $this->get_item_total($item['quantity'], $price, $item['discount']);
			$discounted_total = $this->get_item_total($item['quantity'], $price, $item['discount'], TRUE);

			$no_of_days = 1;
			$reminder_value = 1;
			$time_started = date('Y-m-d H:i:s');

			$new = array(
				'item_id' => $item_id,
				'item_location' => $item_location,
				'stock_name' => $this->CI->Stock_location->get_location_name($item_location),
				'line' => $item['line'],
				'name' => $item_info->name,
				'item_number' => $item_info->item_number,
				'description' => $item_info->description,
				'serialnumber' => $item['serialnumber'],
				'allow_alt_description' => $item_info->allow_alt_description,
				'is_serialized' => $item_info->is_serialized,
				'quantity' => $item['quantity'],
				'qty_selected' => $item['qty_selected'],
				'discount' => $item['discount'],
				'batch_no'=> $item['batch_no'],
				'in_stock' => $this->CI->Item_quantity->get_item_quantity($item_id, $item_location)->quantity,
				// 'price' => get_nearest_five($price),
				'price' => $price,
				'cost' => get_nearest_five($cost),
				'wholeprice' => get_nearest_five($item_info->whole_price),
				// 'total' => get_nearest_five($total),
				'total' => $total,
				'discounted_total' => get_nearest_five($discounted_total),
				'print_option' => '1',
				'stock_type' => $item['stock_type'],
				'tax_category_id' => $item_info->tax_category_id,
				'time_started' => $item['time_started'],
				'reference' => $item['reference'],
				'reminder_value' => $item['reminder_value'],
				'reminder_amount' => 0, //$reminder_amount,
				'no_of_days' => $item['no_of_days'],
				'period' => 0, //$period,
				'apply_vat' => $item_info->apply_vat,
				'vat' => round($vatForThisItem, 2)
			);

			//add to existing array
			$newItems[$item['line']] = $new;
		}

		// echo "<pre>";
		// print_r($newItems);
		// echo "</pre>";
		// die();

		$this->set_cart($newItems);

		return TRUE;
	}


	public function add_item_pill(&$item_id, $period, $no_of_days, $time_started, $price = NULL)
	{
		$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);
		$pill_info = $this->CI->Item->get_info_pill($period);

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;
		$reminder_value = $pill_info->reminder_value;
		$reminder_amount = $pill_info->reminder_amount;

		$total = (24 / $reminder_value) * $no_of_days * $reminder_amount;

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_pill();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}

			if ($item['item_id'] == $item_id && $item['item_location'] == $item_location) {
				$itemalreadyinsale = TRUE;
				$updatekey = $item['line'];
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.


		//$price = $pill_info->reminder_amount;



		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here
		if ($print_option == '1') {
			if ($price == 0) {
				$print_option = '2';
			} else {
				$print_option = '0';
			}
		}

		//$total = $this->get_item_total($quantity, $price, $discount);



		$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);

		//$total = $this->get_item_total($quantity, $price, $discount);
		//$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		//Item already exists and is not serialized, add to quantity
		if (!$itemalreadyinsale || $item_info->is_serialized) {
			$item = array(
				$insertkey => array(
					'item_id' => $item_id,
					'time_started' => $time_started,
					'stock_name' => $this->CI->Stock_location->get_location_name($item_location),
					'line' => $insertkey,
					'name' => $item_info->name,
					'item_number' => $item_info->item_number,
					'reminder_value' => $reminder_value,
					'reminder_amount' => $reminder_amount,
					'no_of_days' => $no_of_days,
					'price' => $reminder_amount,
					'period' => $period,
					'item_location' => 1,
					'quantity' => 1,
					'discount' => 0,

					'total' => $total,
					'discounted_total' => $discounted_total,
					'print_option' => '1',


				)
			);
			//add to existing array
			$items += $item;
		} else {

			$line = &$items[$updatekey];
			$line['total'] = $total;
			$line['discounted_total'] = $discounted_total;
		}

		$this->set_pill($items);

		return TRUE;
	}
	public function edit_pill($line, $period, $no_of_days, $time_started)
	{
		$pill_info = $this->CI->Item->get_info_pill($period);
		$items = $this->get_pill();
		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['period'] = $period;
			$line['no_of_days'] = $no_of_days;
			$line['time_started'] = $time_started;
			$line['reminder_value'] = $pill_info->reminder_value;
			$line['price'] = $pill_info->reminder_amount;
			$price = $pill_info->reminder_amount;
			$reminder_value = $pill_info->reminder_value;
			$line['total'] = (24 / $reminder_value) * $no_of_days * $price;

			$this->set_pill($items);
		}

		return FALSE;
	}
	public function item_add_lab(&$item_id, $quantity = 1, $discount = 0, $price = NULL, $description = NULL, $serialnumber = NULL, $include_deleted = FALSE, $print_option = '0', $stock_type = '1')
	{
		
		$item_info = $this->CI->Item->get_labinfo_by_id_or_number($item_id);

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_lab_accountcart();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}

			if ($item['item_id'] == $item_id && $item['item_location'] == $item_location) {
				$itemalreadyinsale = TRUE;
				$updatekey = $item['line'];
				if (!$item_info->is_serialized) {
					$quantity = bcadd($quantity, $items[$updatekey]['quantity']);
				}
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.

		if (is_null($price)) {
			$price = $item_info->test_amount;
		} elseif ($price == 0) {
			$price = 0.00;
			$discount = 0.00;
		}
		if (is_null($wholeprice)) {
			$wholeprice = $item_info->custom5;
		} elseif ($wholeprice == 0) {
			$wholeprice = 0.00;
			$discount = 0.00;
		}

		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here
		if ($print_option == '1') {
			if ($price == 0) {
				$print_option = '2';
			} else {
				$print_option = '0';
			}
		}
		if ($this->CI->Stock_location->get_location_name($item_location) == 'WholeSale') {
			$total = $this->get_item_total($quantity, $wholeprice, $discount);
		} else {
			$total = $this->get_item_total($quantity, $price, $discount);
		}
		if ($this->CI->Stock_location->get_location_name($item_location) == 'WholeSale') {
			$discounted_total = $this->get_item_total($quantity, $wholeprice, $discount, TRUE);
		} else {
			$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		}
		//$total = $this->get_item_total($quantity, $price, $discount);
		//$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		//Item already exists and is not serialized, add to quantity
		if (!$itemalreadyinsale || $item_info->is_serialized) {
			$item = array(
				$insertkey => array(
					'item_id' => $item_info->item_id,
					'item_location' => 1,
					'stock_name' => 'warehouse',
					'line' => $insertkey,
					'name' => $item_info->test_name,
					'description' => $description != NULL ? $description : $item_info->description,
					'serialnumber' => $serialnumber != NULL ? $serialnumber : '',
					'allow_alt_description' => 0,
					'is_serialized' => 0,
					'quantity' => $quantity,
					'discount' => $discount,
					'in_stock' => 3,
					'price' => $item_info->test_amount,
					'wholeprice' => 3000,
					'total' => $item_info->test_amount,
					'discounted_total' => 7000,
					'print_option' => '1',
					'stock_type' => 1,
					'tax_category_id' => $item_info->tax_category_id
				)
			);
			//add to existing array
			$items += $item;
		} else {
			$line = &$items[$updatekey];
			$line['quantity'] = $quantity;
			$line['total'] = $total;
			$line['discounted_total'] = $discounted_total;
		}

		$this->set_lab_accountcart($items);

		return TRUE;
	}
	public function get_labaccount_totals()
	{
		$cash_rounding = $this->CI->session->userdata('cash_rounding');

		$totals = array();

		$subtotal = 0;
		$discounted_subtotal = 0;
		$tax_exclusive_subtotal = 0;
		foreach ($this->get_lab_accountcart() as $item) {
			//$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
			//$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
			if ($item['stock_name'] == "WholeSale") {
				$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], FALSE));
			} else {
				$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], FALSE));
			}
			if ($item['stock_name'] == "WholeSale") {
				$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['wholeprice'], $item['discount'], TRUE));
			} else {
				$discounted_subtotal = bcadd($discounted_subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], TRUE));
			}
		}

		$totals['subtotal'] = $subtotal;
		$totals['discounted_subtotal'] = $discounted_subtotal;
		$totals['tax_exclusive_subtotal'] = $tax_exclusive_subtotal;

		$total = $discounted_subtotal;
		if ($this->CI->config->config['tax_included']) {
			$totals['total'] = $total;
		} else {
			foreach ($this->get_taxes() as $sales_tax) {
				$total = bcadd($total, $sales_tax['sale_tax_amount']);
			}
			$totals['total'] = $total;
		}

		if ($cash_rounding) {
			$cash_total = $this->check_for_cash_rounding($total);
			$totals['cash_total'] = $cash_total;
		} else {
			$cash_total = $total;
		}

		$totals['cash_total'] = $cash_total;

		$payment_total = $this->get_payments_total();
		$totals['payment_total'] = $payment_total;

		$amount_due = bcsub($total, $payment_total);
		$totals['amount_due'] = $amount_due;

		$cash_amount_due = bcsub($cash_total, $payment_total);
		$totals['cash_amount_due'] = $cash_amount_due;

		if ($cash_rounding) {
			$current_due = $cash_amount_due;
		} else {
			$current_due = $amount_due;
		}

		if ($this->get_mode() == 'return') {
			$totals['payments_cover_total'] = $current_due >= 0;
		} else {
			$totals['payments_cover_total'] =  $current_due <= 0;
		}

		return $totals;
	}



	public function edit_result($line, $test_name, $test_comment, $extra_name, $o_name, $h_name)
	{
		$items = $this->get_lab_resultcart();
		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['test_name'] = $test_name;
			$line['test_comment'] = $test_comment;
			$line['extra_name'] = $extra_name;
			$line['o_name'] = $o_name;
			$line['h_name'] = $h_name;
			$this->set_lab_resultcart($items);
		}

		return FALSE;
	}
	public function edit_received_items($line, $received_quantity, $batch_no, $expiry)
	{
		$items = $this->get_push();
		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['batch_no'] = $batch_no;
			$line['expiry'] = $expiry;
			$line['received_quantity'] = $received_quantity;
			$this->set_push($items);
		}

		return FALSE;
	}
	public function edit_pushed_items($line, $received_quantity, $batch_no, $expiry)
	{
		$items = $this->get_push();
		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['batch_no'] = $batch_no;
			$line['expiry'] = $expiry;
			$line['quantity'] = $quantity;
			$this->set_push($items);
		}

		return FALSE;
	}

	public function edit_requested_items($line, $received_quantity, $batch_no, $expiry)
	{
		$items = $this->get_push();
		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['batch_no'] = $batch_no;
			$line['expiry'] = $expiry;
			$line['quantity'] = $quantity;
			$this->set_push($items);
		}

		return FALSE;
	}

	public function add_lab_cart($grants_data)
	{
		$items = array();
		//$items = $this->get_cart();
		$insertkey = 1;
		foreach ($grants_data as $row => $value) {
			$item_info = $this->CI->Item->get_labinfo_by_id_or_number($value);
			$item = array($row => array(
				'name' => $item_info->test_name,
				'item_id' => $item_info->item_id,
				'item_location' => 1,
				'stock_name' => $this->CI->Stock_location->get_location_name($item_location),
				'line' => $row,
				'item_number' => $item_info->item_number,
				'allow_alt_description' => $item_info->allow_alt_description,
				'is_serialized' => 1,
				'quantity' => 1,
				'discount' => 0,
				'in_stock' => 15,
				'price' => $item_info->test_amount,
				'wholeprice' => 3000,
				'total' => $total,
				'discounted_total' => $discounted_total,
				'print_option' => $print_option,
				'stock_type' => '1',
				'tax_category_id' => '0'
			));
			$insertkey += 1;
			$items += $item;
		}

		
		//$items=+=$item;
		//$items=array('name'=>'Goueg');

		$this->set_labcart($items);
	}
	
	//transfer items
	public function get_transfer()
	{
		if (!$this->CI->session->userdata('transfer_cart')) {
			$this->set_transfer(array());
		}

		return $this->CI->session->userdata('transfer_cart');
	}
	public function set_transfer($push_data)
	{
		$this->CI->session->set_userdata('transfer_cart', $push_data);
	}
	public function empty_transfer()
	{
		$this->CI->session->unset_userdata('transfer_cart');
	}

	public function get_transfer_branch()
	{
		if (!$this->CI->session->userdata('transfer_branch')) {
			$this->set_transfer(array());
		}

		return $this->CI->session->userdata('transfer_branch');
	}
	public function set_transfer_branch($push_data)
	{
		$this->CI->session->set_userdata('transfer_branch', $push_data);
	}
	public function empty_transfer_branch()
	{
		$this->CI->session->unset_userdata('transfer_branch');
	}
	
	public function get_push()
	{
		if (!$this->CI->session->userdata('push_cart')) {
			$this->set_push(array());
		}

		return $this->CI->session->userdata('push_cart');
	}
	public function set_push($push_data)
	{
		$this->CI->session->set_userdata('push_cart', $push_data);
	}
	public function empty_push()
	{
		$this->CI->session->unset_userdata('push_cart');
	}
	public function get_reminder()
	{
		if (!$this->CI->session->userdata('reminder_cart')) {
			$this->set_reminder(array());
		}

		return $this->CI->session->userdata('reminder_cart');
	}
	public function set_reminder($push_data)
	{
		$this->CI->session->set_userdata('reminder_cart', $push_data);
	}
	public function empty_reminder()
	{
		$this->CI->session->unset_userdata('reminder_cart');
	}
	public function get_transfer_branch_id($location)
	{

		return $this->CI->Item->get_transfer_branch_id($location);
	}

	public function item_add_result(&$item_id, $print_option, $comment, $reference = 0, $extra_name = NULL, $o_name = NULL, $h_name = NULL)
	{
		//line is important in the parameter, if we need to use this function for result items from the database where line is not automatically generated
		$item_info = $this->CI->Item->get_labinfo_by_id_or_number($item_id);

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_lab_resultcart();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}

			if ($item['item_id'] == $item_id && $reference == 0) {
				$itemalreadyinsale = TRUE;
				$updatekey = $item['line'];
				if (!$item_info->is_serialized) {
					$quantity = bcadd(1, $items[$updatekey]['quantity']);
				}
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.



		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here


		//$total = $this->get_item_total($quantity, $price, $discount);
		//$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		//Item already exists and is not serialized, add to quantity
		if (!$itemalreadyinsale) {
			$item = array(
				$insertkey => array(
					'item_id' => $item_info->item_id,
					'test_code' => $item_info->test_code,
					'test_name' => $item_info->test_name,
					'test_unit' => $item_info->test_unit,
					'category' => $item_info->test_type,
					'test_subgroup' => $item_info->test_subgroup,
					'test_kind' => $item_info->test_kind,
					'test_comment' => $comment,
					'extra_name' => $extra_name,
					'o_name' => $o_name,
					'h_name' => $h_name,
					'line' => $insertkey,
					'reference' => $reference,
					'print_option' => 1,

				)
			);
			//add to existing array
			$items += $item;
		} else {
			$line = &$items[$updatekey];
		}

		$this->set_lab_resultcart($items);

		return TRUE;
	}
	public function item_add_result_pending(&$item_id, $print_option, $comment, $reference = 0, $extra_name = NULL, $o_name = NULL, $h_name = NULL, $line = -1)
	{
		//line is important in the parameter, if we need to use this function for result items from the database where line is not automatically generated
		$item_info = $this->CI->Item->get_labinfo_by_id_or_number($item_id);

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_lab_resultcart();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		$ind = count($items) + 1;

		$item  = array(
			'item_id' => $item_info->item_id,
			'test_code' => $item_info->test_code,
			'test_name' => $item_info->test_name,
			'test_unit' => $item_info->test_unit,
			'category' => $item_info->test_type,
			'test_subgroup' => $item_info->test_subgroup,
			'test_kind' => $item_info->test_kind,
			'test_comment' => $comment,
			'extra_name' => $extra_name,
			'o_name' => $o_name,
			'h_name' => $h_name,
			'line' => $line,
			'reference' => $reference,
			'print_option' => 1,

		);
		// $items[] = $item;
		$items[$ind] = $item;

		$this->set_lab_resultcart($items);

		return TRUE;
	}
	public function item_add_result_for_print(&$item_id, $print_option, $comment, $reference = 0, $line = 0, $extra_name = NULL, $o_name = NULL, $h_name = NULL)
	{
		$item_info = $this->CI->Item->get_labinfo_by_id_or_number($item_id);

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_lab_resultcart();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}

			if ($item['item_id'] == $item_id && $reference == 0) {
				$itemalreadyinsale = TRUE;
				$updatekey = $item['line'];
				if (!$item_info->is_serialized) {
					$quantity = bcadd(1, $items[$updatekey]['quantity']);
				}
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.



		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here


		//$total = $this->get_item_total($quantity, $price, $discount);
		//$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		//Item already exists and is not serialized, add to quantity
		if (!$itemalreadyinsale) {
			$item = array(
				$line => array(
					'item_id' => $item_info->item_id,
					'test_code' => $item_info->test_code,
					'test_name' => $item_info->test_name,
					'test_unit' => $item_info->test_unit,
					'category' => $item_info->test_type,
					'test_subgroup' => $item_info->test_subgroup,
					'test_kind' => $item_info->test_kind,
					'test_comment' => $comment,
					'extra_name' => $extra_name,
					'o_name' => $o_name,
					'h_name' => $h_name,
					'line' => $line,
					'reference' => $reference,
					'print_option' => 1,
				)
			);
			//add to existing array
			$items += $item;
		} else {
			$line = &$items[$updatekey];
		}

		$this->set_lab_resultcart($items);

		return TRUE;
	}

	public function add_item_push(&$item_id, $quantity, $request_from_branch_id, $request_to_branch_id = 0, $transfer_id = 0, $received_quantity = 0, $unaccounted = 0, $reference = 0, $batch_no = 0, $expiry = NULL,$is_id = false,$pack_type='single')
	{
		//echo "item id : ".$item_id; exit();
	    $loc = $this->get_sale_location();
//	    var_dump($item_id);
		$item_info = $this->CI->Item->get_info_by_id_or_number($item_id,false,$is_id);
		/*echo "<pre>";
		print_r($item_info); exit();*/

//		return $item_info;
		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;

		//check if item quantity is sufficient for this transfer

		$item_quant = $this->CI->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity;
		if ($item_quant < 1) {

			return FALSE;
		}

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_push();
		/// as per new requirement dated 04-03-2022
		$items_count=sizeof($items);
		if($items_count>0){
			/*echo "<pre>";
			print_r($items);*/
			$pack_type=$items[$items_count]['pack_type'];
			//echo "existing pack type : ".$pack_type; exit();
		}
		////////
		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updateKey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}
			if ($item['item_id'] == $item_id && $reference == 0) {
				$itemalreadyinsale = TRUE;
				$updateKey = $item['line'];
				if (!$item_info->is_serialized) {
					$quantity = bcadd($quantity, $items[$updatekey]['quantity']);
				}
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.

		if (is_null($price)) {
			$price = $item_info->unit_price;
		} elseif ($price == 0) {
			$price = 0.00;
			$discount = 0.00;
		}
		if (is_null($wholeprice)) {
			$wholeprice = $item_info->custom5;
		} elseif ($wholeprice == 0) {
			$wholeprice = 0.00;
			$discount = 0.00;
		}

		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here
		if ($print_option == '1') {
			if ($price == 0) {
				$print_option = '2';
			} else {
				$print_option = '0';
			}
		}
		if ($this->CI->Stock_location->get_location_name($request_from_branch_id) == 'WholeSale') {
			$total = $this->get_item_total($quantity, $wholeprice, $discount);
		} else {
			$total = $this->get_item_total($quantity, $price, $discount);
		}
		if ($this->CI->Stock_location->get_location_name($request_from_branch_id) == 'WholeSale') {
			$discounted_total = $this->get_item_total($quantity, $wholeprice, $discount, TRUE);
		} else {
			$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		}
		//$total = $this->get_item_total($quantity, $price, $discount);
		//$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		//Item already exists and is not serialized, add to quantity

		if($pack_type=="pack"){
			$cost_price=$item_info->cost_price*$item_info->pack;
			$unit_price=$item_info->unit_price*$item_info->pack;
			
			$whole_price=$item_info->whole_price*$item_info->pack;
			$transfer_price=$whole_price;
		}else{
			$cost_price=$item_info->cost_price;
			$unit_price=$item_info->unit_price;
			//$transfer_price=$cost_price;
			$transfer_price=$unit_price;
			$whole_price=$item_info->whole_price;
		}
		//echo "transfer : ".$transfer_price; exit();

		if (!$itemalreadyinsale) {
			$item = array($insertkey => array(
				'item_id' => $item_id,
				'cost_price' => $cost_price,
				'unit_price' => $unit_price,
				'transfer_price' => $transfer_price, //transfer_price is by default cost price
				'pack_type'=>$pack_type,
				'whole_price' => $whole_price,
				'item_location' => $request_from_branch_id,
				'location' => $request_to_branch_id != NULL ? $request_to_branch_id : 'None',
				'stock_name' => $this->CI->Stock_location->get_location_name($request_from_branch_id),
				'line' => $insertkey,
				'branch_transfer' => $this->CI->Item->get_transfer_branch_id($request_to_branch_id),
				'name' => $item_info->name,
				'item_number' => $item_info->item_number,
				'allow_alt_description' => $item_info->allow_alt_description,
				'is_serialized' => $item_info->is_serialized,
				'quantity' => $quantity,
				/*'quantity_type'= > $it*/
				'category'=>$item_info->category,
				'wholesale_markup'=>$item->wholesale_markup,
                'unit_price_markup'=>$item->unit_price_markup,
                'reorder_level'=>$item->reorder_level,
				'stock_type' => '0',
				'in_stock' => $this->CI->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity,
				'transfer_id' => $transfer_id,
				'received_quantity' => $received_quantity,
				'unaccounted' => $unaccounted,
				'reference' => $reference,
				'expiry' => $expiry,
				'batch_no' => $batch_no,
                'batches'=> $item_info->batch_numbers
			));
			//print_r($item); exit();
			//add to existing array
			$items += $item;
            $this->CI->session->set_userdata('last_inserted', $insertkey);
		} else {
//			$line = &$items[$updatekey];
            $line = $items[$updateKey];
            unset($items[$updateKey]);
			$line['quantity'] += $quantity;
			foreach ($items as $item_line=>$item){
                $items[$item_line]['line'] = $item_line;
            }
			$items[] = $line;
		}
		$this->set_push($items);


		return TRUE;
	}

	public function add_item_to_transfer(&$item_id, $quantity, $accepted_quantity = 0, $request_id)
	{
		$det=$this->CI->Receiving->get_specific_request_data($request_id);
		$print_option = 1;
		$request_to_branch_id = $det->request_from_branch_id;
		$request_from_branch_id = $det->request_to_branch_id;



		$item_info = $this->CI->Item->get_item_info_by_number($item_id);
		// $item_info = $this->Item->get_item_info_by_number($item_id);
		//print_r($item_info); exit();

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;

		//Get all items in the cart so far...
		$items = $this->get_transfer();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}
			if ($item['item_id'] == $item_id) {
				$itemalreadyinsale = TRUE;
				$updatekey = $item['line'];
				if (!$item_info->is_serialized) {
					$quantity = bcadd($quantity, $items[$updatekey]['quantity']);
				}
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.
		$price = $item_info->unit_price;

		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here
		if ($print_option == '1') {
			if ($price == 0) {
				$print_option = '2';
			} else {
				$print_option = '0';
			}
		}

		
		// if ($this->CI->Stock_location->get_location_name($request_from_branch_id) == 'WholeSale') {
		// 	$total = $this->get_item_total($quantity, $wholeprice, $discount);
		// } else {
		// 	$total = $this->get_item_total($quantity, $price, $discount);
		// }
		// if ($this->CI->Stock_location->get_location_name($request_from_branch_id) == 'WholeSale') {
		// 	$discounted_total = $this->get_item_total($quantity, $wholeprice, $discount, TRUE);
		// } else {
		// 	$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		// }


		if (!$itemalreadyinsale) {

			$item = array(
				'item_id' => $item_id,
				'cost_price' => $item_info->cost_price,
				'unit_price' => $item_info->unit_price,
				'transfer_price' => $item_info->cost_price, //transfer_price is by default cost price
				'whole_price' => $item_info->whole_price,
				'item_location' => $request_from_branch_id,
				'location' => $request_to_branch_id != NULL ? $request_to_branch_id : 'None',
				'stock_name' => $this->CI->Stock_location->get_location_name($request_from_branch_id),
				'line' => $insertkey,
				'branch_transfer' => $this->CI->Item->get_transfer_branch_id($request_to_branch_id),
				'name' => $item_info->name,
				'item_number' => $item_info->item_number,
				'allow_alt_description' => $item_info->allow_alt_description,
				'is_serialized' => $item_info->is_serialized,
				'quantity' => $quantity,
				'stock_type' => '0',
				'in_stock' => $this->CI->Item_quantity->get_item_quantity($item_id, 2)->quantity,
				'transfer_id' => $request_id,
				'accepted_quantity' => $accepted_quantity,
			);

			//add to existing array
			// $items += $item;
			array_push($items, $item);
			
		} else {
			$line = &$items[$updatekey];
			$line['quantity'] = $quantity;
		}
		
		$this->set_transfer($items);

		return TRUE;
	}


	public function add_item_request(&$item_id, $quantity, $request_from_branch_id, $request_to_branch_id = 0, $transfer_id = 0, $received_quantity = 0, $unaccounted = 0, $reference = 0, $batch_no = 0, $expiry = NULL)
	{
		$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;

		//Get all items in the cart so far...
		$items = $this->get_push();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}
			if ($item['item_id'] == $item_id && $reference == 0) {
				$itemalreadyinsale = TRUE;
				$updatekey = $item['line'];
				if (!$item_info->is_serialized) {
					$quantity = bcadd($quantity, $items[$updatekey]['quantity']);
				}
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.

		if (is_null($price)) {
			$price = $item_info->unit_price;
		} elseif ($price == 0) {
			$price = 0.00;
			$discount = 0.00;
		}
		if (is_null($wholeprice)) {
			$wholeprice = $item_info->custom5;
		} elseif ($wholeprice == 0) {
			$wholeprice = 0.00;
			$discount = 0.00;
		}

		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here
		if ($print_option == '1') {
			if ($price == 0) {
				$print_option = '2';
			} else {
				$print_option = '0';
			}
		}
		if ($this->CI->Stock_location->get_location_name($request_from_branch_id) == 'WholeSale') {
			$total = $this->get_item_total($quantity, $wholeprice, $discount);
		} else {
			$total = $this->get_item_total($quantity, $price, $discount);
		}
		if ($this->CI->Stock_location->get_location_name($request_from_branch_id) == 'WholeSale') {
			$discounted_total = $this->get_item_total($quantity, $wholeprice, $discount, TRUE);
		} else {
			$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		}

		if (!$itemalreadyinsale) {
			$item = array($insertkey => array(
				'item_id' => $item_id,
				'cost_price' => $item_info->cost_price,
				'unit_price' => $item_info->unit_price,
				'transfer_price' => $item_info->cost_price, //transfer_price is by default cost price
				'whole_price' => $item_info->whole_price,
				'item_location' => $request_from_branch_id,
				'location' => $request_to_branch_id != NULL ? $request_to_branch_id : 'None',
				'stock_name' => $this->CI->Stock_location->get_location_name($request_from_branch_id),
				'line' => $insertkey,
				'branch_transfer' => $this->CI->Item->get_transfer_branch_id($request_to_branch_id),
				'name' => $item_info->name,
				'item_number' => $item_info->item_number,
				'allow_alt_description' => $item_info->allow_alt_description,
				'is_serialized' => $item_info->is_serialized,
				'quantity' => $quantity,
				'stock_type' => '0',
				'in_stock' => $this->CI->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity,
				'transfer_id' => $transfer_id,
				'received_quantity' => $received_quantity,
				'unaccounted' => $unaccounted,
				'reference' => $reference,
				'expiry' => $expiry,
				'batch_no' => $batch_no,

			));
			//add to existing array
			$items += $item;
		} else {
			$line = &$items[$updatekey];
			$line['quantity'] = $quantity;
		}
		$this->set_push($items);

		return TRUE;
	}

	public function add_item_pull(&$item_id, $quantity, $request_from_branch_id, $request_to_branch_id = 0, $transfer_id = 0, $received_quantity = 0, $unaccounted = 0, $reference = 0, $batch_no = 0, $expiry = NULL)
	{
		$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;
		//check if item quantity is sufficient for this transfer

		$item_quant = $this->CI->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity;
		if ($item_quant < 1) {

			return FALSE;
		}
		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_push();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}
			if ($item['item_id'] == $item_id && $reference == 0) {
				$itemalreadyinsale = TRUE;
				$updatekey = $item['line'];
				if (!$item_info->is_serialized) {
					$quantity = bcadd($quantity, $items[$updatekey]['quantity']);
				}
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.

		if (is_null($price)) {
			$price = $item_info->unit_price;
		} elseif ($price == 0) {
			$price = 0.00;
			$discount = 0.00;
		}
		if (is_null($wholeprice)) {
			$wholeprice = $item_info->custom5;
		} elseif ($wholeprice == 0) {
			$wholeprice = 0.00;
			$discount = 0.00;
		}

		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here
		if ($print_option == '1') {
			if ($price == 0) {
				$print_option = '2';
			} else {
				$print_option = '0';
			}
		}
		if ($this->CI->Stock_location->get_location_name($request_from_branch_id) == 'WholeSale') {
			$total = $this->get_item_total($quantity, $wholeprice, $discount);
		} else {
			$total = $this->get_item_total($quantity, $price, $discount);
		}
		if ($this->CI->Stock_location->get_location_name($request_from_branch_id) == 'WholeSale') {
			$discounted_total = $this->get_item_total($quantity, $wholeprice, $discount, TRUE);
		} else {
			$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		}
		//$total = $this->get_item_total($quantity, $price, $discount);
		//$discounted_total = $this->get_item_total($quantity, $price, $discount, TRUE);
		//Item already exists and is not serialized, add to quantity
		$branch_location = $this->CI->Stock_location->get_location_name($request_to_branch_id);
		if (!$itemalreadyinsale) {
			$item = array($insertkey => array(
				'item_id' => $item_id,
				'item_location' => $request_from_branch_id,
				'location' => $branch_location,
				'stock_name' => $this->CI->Stock_location->get_location_name($request_from_branch_id),
				'line' => $insertkey,
				'branch_transfer' => $request_to_branch_id,
				'name' => $item_info->name,
				'item_number' => $item_info->item_number,
				'allow_alt_description' => $item_info->allow_alt_description,
				'is_serialized' => $item_info->is_serialized,
				'quantity' => $received_quantity,
				'stock_type' => '0',
				'in_stock' => $this->CI->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity,
				'transfer_id' => $transfer_id,
				'requested_quantity' => $quantity,
				'unaccounted' => $unaccounted,
				'reference' => $reference,
				'expiry' => $expiry,
				'batch_no' => $batch_no,

			));
			//add to existing array
			$items += $item;
		} else {
			$line = &$items[$updatekey];
			$line['quantity'] = $quantity;
		}
		$this->set_push($items);

		return TRUE;
	}
	public function add_item_reminder($reminder_id, $reminder_name, $reminder_amount, $reminder_value)
	{
		$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);

		//make sure item exists		

		$item_id = $item_info->item_id;

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_reminder();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.



		// For print purposes this simpifies line selection
		// 0 will print, 2 will not print.   The decision about 1 is made here


		$item = array($insertkey => array(
			'reminder_id' => $reminder_id,
			'reminder_name' => $reminder_name,
			'reminder_amount' => $reminder_amount,
			'reminder_value' => $reminder_value,
			'line' => $insertkey,

		));
		//add to existing array
		$items += $item;

		$this->set_reminder($items);

		return TRUE;
	}
	public function add_reciever_push(&$item_id, $quantity, $request_from_branch_id, $request_to_branch_id, $transfer_id, $received_quantity = 0, $unaccounted = 0, $reference = 0, $batch_no = 0, $expiry = NULL)
	{
		$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);

		//make sure item exists		
		if (empty($item_info)) {
			$item_id = -1;
			return FALSE;
		}

		$item_id = $item_info->item_id;

		// Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_push();

		//We need to loop through all items in the cart.
		//If the item is already there, get it's key($updatekey).
		//We also need to get the next key that we are going to use in case we need to add the
		//item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

		$maxkey = 0;                       //Highest key so far
		$itemalreadyinsale = FALSE;        //We did not find the item yet.
		$insertkey = 0;                    //Key to use for new entry.
		$updatekey = 0;                    //Key to use to update(quantity)

		foreach ($items as $item) {
			//We primed the loop so maxkey is 0 the first time.
			//Also, we have stored the key in the element itself so we can compare.

			if ($maxkey <= $item['line']) {
				$maxkey = $item['line'];
			}
		}

		$insertkey = $maxkey + 1;
		//array/cart records are identified by $insertkey and item_id is just another field.



		$item = array($insertkey => array(
			'item_id' => $item_id,
			'item_location' => $request_from_branch_id,
			'location' => $request_to_branch_id != NULL ? $request_to_branch_id : 'None',
			'stock_name' => $this->CI->Stock_location->get_location_name($request_from_branch_id),
			'line' => $insertkey,
			'branch_transfer' => $this->CI->Item->get_transfer_branch_id($request_to_branch_id),
			'name' => $item_info->name,
			'item_number' => $item_info->item_number,
			'allow_alt_description' => $item_info->allow_alt_description,
			'is_serialized' => $item_info->is_serialized,
			'quantity' => $quantity,
			'stock_type' => '0',
			'in_stock' => $this->CI->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity,
			'transfer_id' => $transfer_id,
			'received_quantity' => $received_quantity,
			'unaccounted' => $unaccounted,
			'reference' => $reference,
			'expiry' => $expiry,
			'batch_no' => $batch_no,

		));
		//add to existing array
		$items += $item;

		$this->set_push($items);

		return TRUE;
	}


	public function global_search($item_id)
	{
		$sglobal = $this->CI->Item->global_search_items($item_id);
		$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);

		foreach ($sglobal as $item => $value) {
			$item_id = $value['item_id'];
			$location_id = $value['location_id'];
			$sglob[] = array(
				'item' => $value['item_id'],
				'item_name' => $item_info->name,
				'quantity' => $value['qty'],
				'location_name' => $this->CI->Stock_location->get_location_name($location_id)
			);
		}
		return $sglob;
	}
	public function global_transfer_items($item_location)
	{
		$items_transfe = $this->CI->Item->global_transfer_items($item_location);


		return count($items_transfe);
	}
	public function notice_transfer_items($item_location)
	{
		$items_transfe = $this->CI->Item->global_transfer_items($item_location);


		return $items_transfe;
	}


	public function out_of_stock($item_id, $item_location)
	{
		//make sure item exists		
		if ($item_id != -1) {
			$item_info = $this->CI->Item->get_info_by_id_or_number($item_id);

			if ($item_info->stock_type == '0') {
				$item_quantity = $this->CI->Item_quantity->get_item_quantity($item_id, $item_location)->quantity;
				$quantity_added = $this->get_quantity_already_added($item_id, $item_location);

				$datetimenow = date('Y/m/d H:i:s');
				$datetimeexpire = $item_info->expiry;

				$datetimenowc = strtotime($datetimenow);
				$datetimeexpirec = strtotime($datetimeexpire);
				$des = $datetimeexpirec - $datetimenowc;
				$dd = $des / 86400;



				if ($item_quantity - $quantity_added < 0) {
					return $this->CI->lang->line('sales_quantity_less_than_zero');
				} elseif ($item_quantity - $quantity_added < $item_info->reorder_level) {
					return $this->CI->lang->line('sales_quantity_less_than_reorder_level');
				}
			}
		}

		return '';
	}

	public function get_quantity_already_added($item_id, $item_location)
	{
		$items = $this->get_cart();
		$quanity_already_added = 0;
		foreach ($items as $item) {
			if ($item['item_id'] == $item_id && $item['item_location'] == $item_location) {
				$quanity_already_added += $item['quantity'];
			}
		}

		return $quanity_already_added;
	}

	public function get_item_id($line_to_get)
	{
		$items = $this->get_cart();

		foreach ($items as $line => $item) {
			if ($line == $line_to_get) {
				return $item['item_id'];
			}
		}

		return -1;
	}
	public function change_mode_quantity_sign($mode)
	{

		$items = $this->get_cart();
		foreach ($items as &$item) {
			$quant = (int) $item['quantity'];
			if ($quant > 0 && $mode == 'return') {

				$item['quantity'] = (int) $item['quantity'] * -1;
			}
			if ($quant < 0 && $mode == 'sale') {
				$item['quantity'] = (int) $item['quantity'] * -1;
			}
		}
		$this->set_cart($items);
	}
	public function edit_item($line, $description, $serialnumber, $quantity, $discount, $price, $qty_selected,$batch_no=null)
	{

		$items = $this->get_cart();
        $mode = $this->get_mode();
        $registered_returns = [];
        if($mode == 'return'){
            $items_copy = $this->CI->session->userdata('coppyitems');
            if($items_copy == null){
                $items_copy = $items;
                $this->CI->session->set_userdata('coppyitems',$items_copy);
            }else{
                $items[$line] = $items_copy[$line];
            }
            $registered_returns = $this->get_registered_returns();
        }

		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['description'] = $description;
			$line['serialnumber'] = $serialnumber;
			$line['quantity'] = $quantity;
			$line['qty_selected'] = $qty_selected;
			$line['discount'] = $discount;
			if($batch_no){
                $line['batch_no'] = $batch_no;
            }


			// //before
			// $line['price'] = get_nearest_five($price);
			// $line['total'] = get_nearest_five($this->get_item_total($quantity, $price, $discount));
			// $discount_total = get_nearest_five($this->get_item_total($quantity, $price, $discount, TRUE));

			// $line['price'] = get_nearest_five($price);
			
			$vatForThisItem = 0;
			$itemPrice = $price;
			//echo "item price : ".$itemPrice; exit();
			if (strtolower($line['apply_vat']) == "yes") {
				
				$configuredAppVat = $this->CI->config->item('vat');
				$vatCalc = 1 + ($configuredAppVat / 100);
				$itemPrice = round(($itemPrice / $vatCalc), 3);
				
				$exclOfVat = round((($quantity * $price) / $vatCalc), 3);
				$vatForThisItem = ($quantity * $price) - $exclOfVat;

				$line['price'] = $itemPrice;
				$line['total'] = $this->get_item_total($quantity, $itemPrice, $discount);
				
				//old
				// $configuredAppVat = $this->CI->config->item('vat');
				// $vatForThisItem = round((($quantity * $price) * ($configuredAppVat / 100)), 2);


			}else{
				$line['price'] = get_nearest_five($itemPrice);
				$line['total'] = get_nearest_five($this->get_item_total($quantity, $itemPrice, $discount));
			}
			$line['vat'] =  $vatForThisItem;
			// $line['total'] = get_nearest_five($this->get_item_total($quantity, $price, $discount));
			$discount_total = get_nearest_five($this->get_item_total($quantity, $itemPrice, $discount, TRUE));

			$line['discounted_total'] = $discount_total;


			//check if there are identical items in the different lines
			$cur_line = $line['line'];

			//loop through the items except this line and check
			$line_to_remove = 0;
			$line_to_stay = 0;
			$total_quantity = 0;

			foreach ($items as $index => $item) {
			    if(!in_array($item['item_id'],$registered_returns) && $mode==='return'){
			        unset($items[$index]);
			        continue;
                }
				if ($item['line'] == $cur_line) {
					continue;
				} else {
					if ($line['item_id'] == $item['item_id'] && $line['item_location'] == $item['item_location'] && $line['qty_selected'] == $item['qty_selected']) {
						//remove new one. new one has higher index
						if ($item['line'] > $cur_line) {
							$line_to_remove = $item['line'];
							$line_to_stay = $cur_line;
						} else {
							$line_to_stay = $item['line'];
							$line_to_remove = $cur_line;
						}
						//calculate total quantitity
						//the reason for taking the bigger one is , adding both might cause out of stock

						$total_quantity = $items[$line_to_stay]['quantity'] + $items[$line_to_remove]['quantity'];

						//remove
						unset($items[$line_to_remove]);
						//increase the quantity of line to stay
						$items[$line_to_stay]['quantity'] = $total_quantity;

						//make_sure items has their line same as the index of the item on the array
						foreach ($items as $index => $itm) {
							if (isset($items[$index]['line'])) {
								$items[$index]['line'] = $index;
							}
						}
					}
				}
			} //End of the duplication removal

			//print_r($items); exit();

			$this->set_cart($items);
			return TRUE;
		}

		return FALSE;
	}
	public function edit_salepill_item($line, $time_started, $time_ended, $reminder_value, $no_of_days, $discount, $price)
	{
		$items = $this->get_cart();
		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['time_started'] = $time_started;
			$line['time_ended'] = $time_ended;
			$line['reminder_value'] = $reminder_value;
			$quantity = $reminder_value * $no_of_days;
			$line['quantity'] = $quantity;
			$line['no_of_days'] = $no_of_days;
			$line['discount'] = $discount;
			$line['price'] = $price;
			$line['total'] = $this->get_item_total($quantity, $price, $discount);
			$line['discounted_total'] = $this->get_item_total($quantity, $price, $discount, TRUE);
			$this->set_cart($items);
		}

		return FALSE;
	}


	public function edit_reminder($line, $reminder_amount)
	{
		$items = $this->get_reminder();
		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['reminder_amount'] = $reminder_amount;
			$this->set_reminder($items);
		}

		return FALSE;
	}
	public function edit_item_push($line, $item_name, $item_location, $quantity, $location, $branch_transfer, $batch_no = "", $expiry = null, $transfer_price = 0,$pack_type="single")
	{
		//echo "pack type : ".$pack_type; exit();
		$items = $this->get_push();

		if (isset($items[$line])) {
			$line = &$items[$line];
			$item_info = $this->CI->Item->get_info_by_id_or_number($line['item_id']);

			if($pack_type=="pack"){
				$cost_price=$item_info->cost_price*$item_info->pack;
				$unit_price=$item_info->unit_price*$item_info->pack;
				$whole_price=$item_info->whole_price*$item_info->pack;
				/// new modification as per the requirement 04-03-2022////
				$transfer_price=$whole_price;
				///////
			}else{
				$cost_price=$item_info->cost_price;
				$unit_price=$item_info->unit_price;
				$whole_price=$item_info->whole_price;
			}
			if($transfer_price==0){
				$transfer_price=$cost_price;
			}

			//echo "whole price : ".$whole_price; exit();
			
			//item cost or selling price must have changed through the update
			if ($line['transfer_price'] == $unit_price) {
				$line['unit_price'] = $unit_price;
				$line['cost_price'] = $cost_price;
			} else {
				$line['cost_price'] = $cost_price;
				$line['unit_price'] = $unit_price;
			}
			$line['whole_price']=$whole_price;
			$line['item_name'] = $item_name;
			$line['item_location'] = $item_location;
			$line['quantity'] = $quantity;
			$line['location'] = $location;
			$line['branch_transfer'] = $branch_transfer;
			$line['transfer_price'] = $transfer_price;
			if($pack_type!=""){
				$line['pack_type'] = $pack_type;
			}
			$this->set_push($items);
		}
		//Set all the location to be the same
		foreach ($items as $key => $item) {
			$items[$key]['branch_transfer'] = $branch_transfer;
		}
		/*echo "<pre>";
		print_r($items);
		exit();*/
		$this->set_push($items);
		return FALSE;
	}

	public function edit_item_request($line, $item_name, $item_location, $quantity, $location, $branch_transfer, $batch_no = "", $expiry = null)
	{
		$items = $this->get_push();

		if (isset($items[$line])) {
			$line = &$items[$line];
			$item_info = $this->CI->Item->get_info_by_id_or_number($line['item_id']);
			//item cost or selling price must have changed through the update
			if ($line['transfer_price'] == $item_info->unit_price) {
				// $line['transfer_price'] = $item_info->unit_price;
				$line['unit_price'] = $item_info->unit_price;
				$line['cost_price'] = $item_info->cost_price;
			} else {
				// $line['transfer_price'] = $item_info->cost_price;
				$line['cost_price'] = $item_info->cost_price;
				$line['unit_price'] = $item_info->unit_price;
			}

			$line['item_name'] = $item_name;
			$line['item_location'] = $item_location;
			$line['quantity'] = $quantity;
			$line['location'] = $location;
			$line['branch_transfer'] = $branch_transfer;
			// $line['transfer_price'] = $transfer_price;

			$this->set_push($items);
		}
		//Set all the location to be the same
		foreach ($items as $key => $item) {
			$items[$key]['branch_transfer'] = $branch_transfer;
		}
		$this->set_push($items);
		return FALSE;
	}

	public function edit_item_transfer($line, $item_name, $item_location, $quantity, $accepted_quantity, $location, $branch_transfer, $batch_no = "", $expiry = null)
	{
		$items = $this->get_transfer();

		// print_r($items[0]);
		// die();

		if (isset($items[$line])) {

			$line = &$items[$line];
			$item_info = $this->CI->Item->get_info_by_id_or_number($line['item_id']);
			//item cost or selling price must have changed through the update
			// if ($line['transfer_price'] == $item_info->unit_price) {
			// 	$line['transfer_price'] = $item_info->unit_price;
			// 	$line['unit_price'] = $item_info->unit_price;
			// 	$line['cost_price'] = $item_info->cost_price;
			// } else {
			// 	// $line['transfer_price'] = $item_info->cost_price;
			// 	$line['cost_price'] = $item_info->cost_price;
			// 	$line['unit_price'] = $item_info->unit_price;
			// }

			$line['transfer_price'] = $item_info->cost_price;
			$line['unit_price'] = $item_info->unit_price;
			$line['cost_price'] = $item_info->cost_price;

			$line['item_name'] = $item_name;
			$line['item_location'] = $item_location;
			$line['quantity'] = $quantity;
			$line['accepted_quantity'] = $accepted_quantity;
			$line['location'] = $location;
			$line['branch_transfer'] = $branch_transfer;
			// $line['transfer_price'] = $transfer_price;

			$this->set_transfer($items);
		}
		//Set all the location to be the same
		foreach ($items as $key => $item) {
			$items[$key]['branch_transfer'] = $branch_transfer;
		}
		$this->set_transfer($items);
		return FALSE;
	}

	public function edit_item_pull($line, $item_name, $item_location, $quantity, $location, $branch_transfer, $stock_name, $in_stock)
	{
		$items = $this->get_push();
		if (isset($items[$line])) {
			$line = &$items[$line];
			$line['item_name'] = $item_name;
			$line['item_location'] = $item_location;
			$line['quantity'] = $quantity;
			$line['location'] = $location;
			$line['branch_transfer'] = $branch_transfer;
			$line['stock_name'] = $stock_name;
			$line['in_stock'] = $in_stock;

			$this->set_push($items);
		}

		return FALSE;
	}


	public function delete_item($line)
	{
		$items = $this->get_cart();
		unset($items[$line]);
		//reset the line on the items
		foreach ($items as $index => $value) {
			$items[$index]['line'] = $index;
		}
		$this->set_cart($items);
	}
	public function delete_item_push($line)
	{
		$items = $this->get_push();
		unset($items[$line]);
		$this->set_push($items);
	}
	public function delete_item_test($line)
	{
		$items = $this->get_lab_resultcart();
		unset($items[$line]);
		$this->set_lab_resultcart($items);
	}
	public function delete_reference_push($reference)
	{
		$items = $this->get_push();
		unset($items[$reference]);
		$this->set_push($items);
	}

	public function return_entire_sale($receipt_sale_id)
	{
		//POS #
		$pieces = explode(' ', $receipt_sale_id);
		$sale_id = $pieces[1];

		$this->empty_cart();
		$this->remove_customer();

		foreach ($this->CI->Sale->get_sale_items_ordered($sale_id)->result() as $row) {
			$this->add_item($row->item_id, -$row->quantity_purchased, $row->item_location, $row->discount_percent, $row->item_unit_price, $row->description, $row->serialnumber, TRUE, $row->print_option, $row->print_option);
		}

		$this->set_customer($this->CI->Sale->get_customer($sale_id)->person_id);
	}

	public function add_item_kit($external_item_kit_id, $item_location, $discount, $price_option, $kit_print_option, &$stock_warning)
	{
		//KIT #
		$pieces = explode(' ', $external_item_kit_id);
		$item_kit_id = $pieces[1];
		$result = TRUE;

		foreach ($this->CI->Item_kit_items->get_info($item_kit_id) as $item_kit_item) {
			if ($price_option == '0') // all
			{
				$price = null;
			} elseif ($price_option == '1') // item kit only
			{
				$price = 0;
			} elseif ($price_option == '2') // item kit plus stock items (assuming materials)
			{
				if ($item_kit_item['stock_type'] == 0) // stock item
				{
					$price = null;
				} else {
					$price = 0;
				}
			}

			if ($kit_print_option == '0') // all
			{
				$print_option = '0'; // print always
			} elseif ($kit_print_option == '1') // priced
			{
				$print_option = '1'; // print if price not zero
			} elseif ($kit_print_option == '2') // kit only if price is not zero
			{
				$print_option = '2'; // Do not include in list
			}

			$result &= $this->add_item($item_kit_item['item_id'], $item_kit_item['quantity'], $item_location, $discount, $price, null, null, null, $print_option, $item_kit_item['stock_type']);

			if ($stock_warning == null) {
				$stock_warning = $this->out_of_stock($item_kit_item['item_id'], $item_location);
			}
		}

		return $result;
	}

	public function copy_entire_sale($sale_id,$for_returns = false,$for_receipt=false)
	{
		$this->empty_cart();
		$this->remove_customer();

		if($for_returns){
		    $saleSession = $this->CI->Sale->eligible_returns($sale_id);
            $this->CI->session->set_userdata('returned_sales', $sale_id);
        }else{
            $saleSession = $this->CI->Sale->get_sale_items_ordered($sale_id)->result();
        }

        // echo '<pre>'; print_r( $saleSession ); echo '</pre>';
        
		foreach ($saleSession as $row) {
			// $this->add_item($row->item_id, $row->quantity_purchased, $row->item_location, $row->discount_percent, $row->item_unit_price, $row->description, $row->serialnumber, TRUE, $row->print_option, '0', $row->qty_selected, 0, $row->apply_vat, $row->vat); //modifed for pill remainder
			$this->add_item($row->item_id, $row->quantity_purchased, $row->item_location, $row->discount_percent, $row->item_unit_price, $row->description, $row->serialnumber, TRUE, $row->print_option, '0', $row->qty_selected, $row->reference, $row->apply_vat, $row->vat,false);
		}
		
		// echo '<pre>'; print_r( $this->get_cart() ); die(); 

        if(!$for_returns){
            foreach ($this->CI->Sale->get_sale_payments($sale_id)->result() as $row) {
                $this->add_payment($row->payment_type, $row->payment_amount);
            }
        }

		$this->set_customer($this->CI->Sale->get_customer($sale_id)->person_id);
		$this->set_employee($this->CI->Sale->get_employee($sale_id)->person_id);
		$this->set_dinner_table($this->CI->Sale->get_dinner_table($sale_id));
	}



	public function get_cart_reordered($sale_id)
	{
		$this->empty_cart();
		foreach ($this->CI->Sale->get_sale_items_ordered($sale_id)->result() as $row) {
			$this->add_item(
				$row->item_id,
				$row->quantity_purchased,
				$row->item_location,
				$row->discount_percent,
				$row->item_unit_price,
				$row->description,
				$row->serialnumber,
				TRUE,
				$row->print_option,
				$row->stock_type,
				$row->qty_selected,
				$row->reference
			);
		}


		return $this->CI->session->userdata('sales_cart');
	}
	public function get_onlinesale_items_ordered($transfer_id)
	{
		$this->empty_cart();
		foreach ($this->CI->Sale->get_onlinesale_items_ordered($transfer_id)->result() as $row) {
			$this->add_item(
				$row->item_id,
				1,
				1,
				$row->discount_percent,
				$row->item_unit_price,
				$row->description,
				$row->serialnumber,
				TRUE,
				$row->print_option,
				$row->stock_type
			);
		}


		return $this->CI->session->userdata('sales_cart');
	}
	public function get_labcart_reordered($sale_id)
	{
		$this->empty_lab_accountcart();
		foreach ($this->CI->Sale->get_sale_items_ordered($sale_id)->result() as $row) {
			$this->item_add_lab(
				$row->item_id,
				$row->quantity_purchased,
				$row->item_location,
				$row->discount_percent,
				$row->item_unit_price,
				$row->description,
				$row->serialnumber,
				TRUE,
				$row->print_option,
				$row->stock_type
			);
		}

		return $this->CI->session->userdata('lab_accountcart');
	}
	public function get_labresultcart_reordered($sale_id)
	{
		$this->empty_lab_resultcart();
		foreach ($this->CI->Sale->get_result_items_ordered($sale_id)->result() as $row) {
			$this->item_add_result($row->item_id, $row->print_option, $row->test_comment, $row->reference, $row->extra_name, $row->o_name, $row->h_name);
		}

		return $this->CI->session->userdata('lab_resultcart');
	}
	public function get_printresult_items_ordered($sale_id, $status = 3)
	{
		$this->empty_lab_resultcart();
		$result = array();
		if ($status == 2) {
			$results = $this->CI->Sale->get_savedresult_items_ordered($sale_id)->result();
		} else {
			$results = $this->CI->Sale->get_printresult_items_ordered($sale_id)->result();
		}

		foreach ($results as $index => $row) {

			//$this->item_add_result($row->item_id, $row->print_option, $row->test_comment, $row->reference, $row->line, $row->extra_name, $row->o_name, $row->h_name);
			$this->item_add_result_for_print($row->item_id, $row->print_option, $row->test_comment, $row->reference, $row->line, $row->extra_name, $row->o_name, $row->h_name);
		}

		return $this->CI->session->userdata('lab_resultcart');
	}
	public function get_labsaveresultcart_reordered($sale_id)
	{
		$this->empty_lab_resultcart();
		$rs = $this->CI->Sale->get_savedresult_items_ordered($sale_id)->result();

		foreach ($rs as $row) {
			$this->item_add_result_pending($row->item_id, $row->print_option, $row->test_comment, $row->reference, $row->extra_name, $row->o_name, $row->h_name, $row->line);
			// $this->item_add_result($row->item_id, $row->print_option, $row->test_comment, $row->reference, $row->extra_name, $row->o_name, $row->h_name, $row->line);
		}

		return $this->CI->session->userdata('lab_resultcart');
	}
	public function get_pushedcart_reordered($transfer_id)
	{
		$this->empty_push();
		foreach ($this->CI->Sale->get_pushedcart_reordered($transfer_id)->result() as $row) {
			$this->add_item_push($row->item_id, $row->pushed_quantity, $row->request_from_branch_id, $row->request_to_branch_id, $row->transfer_id, $row->received_quantity, $row->unaccounted, $row->reference, $row->batch_no, $row->expiry);
		}

		return $this->CI->session->userdata('push_cart');
	}
	public function get_pulledcart_reordered($transfer_id)
	{
		$this->empty_push();
		foreach ($this->CI->Sale->get_pulledcart_reordered($transfer_id)->result() as $row) {
			$this->add_item_pull($row->item_id, $row->pulled_quantity, $row->request_to_branch_id, $row->request_from_branch_id, $row->transfer_id, $row->received_quantity, $row->unaccounted, $row->reference, $row->batch_no, $row->expiry);
		}

		return $this->CI->session->userdata('push_cart');
	}
	public function get_remindercart_reordered()
	{
		$this->empty_reminder();
		foreach ($this->CI->Sale->get_remindercart_reordered()->result() as $row) {
			$this->add_item_reminder($row->reminder_id, $row->reminder_name, $row->reminder_amount, $row->reminder_value);
		}

		return $this->CI->session->userdata('reminder_cart');
	}

	public function copy_entire_suspended_sale($sale_id)
	{
		$this->empty_cart();
		$this->remove_customer();

		foreach ($this->CI->Sale->get_sale_items($sale_id)->result() as $row) {
			$this->add_item(
				$row->item_id,
				$row->quantity_purchased,
				$row->item_location,
				$row->discount_percent,
				$row->item_unit_price,
				$row->description,
				$row->serialnumber,
				TRUE,
				$row->print_option,
				$row->stock_type
			);
		}

		foreach ($this->CI->Sale->get_sale_payments($sale_id)->result() as $row) {
			$this->add_payment($row->payment_type, $row->payment_amount);
		}

		$suspended_sale_info = $this->CI->Sale->get_info($sale_id)->row();
		$this->set_customer($suspended_sale_info->person_id);
		$this->set_comment($suspended_sale_info->comment);

		$this->set_invoice_number($suspended_sale_info->invoice_number);
		$this->set_quote_number($suspended_sale_info->quote_number);
		$this->set_dinner_table($suspended_sale_info->dinner_table_id);
	}

	public function copy_entire_suspended_tables_sale($sale_id)
	{
		$this->empty_cart();
		$this->remove_customer();

		foreach ($this->CI->Sale_suspended->get_sale_items($sale_id)->result() as $row) {
			$this->add_item(
				$row->item_id,
				$row->quantity_purchased,
				$row->item_location,
				$row->discount_percent,
				$row->item_unit_price,
				$row->description,
				$row->serialnumber,
				TRUE,
				$row->print_option,
				$row->stock_type
			);
		}

		foreach ($this->CI->Sale_suspended->get_sale_payments($sale_id)->result() as $row) {
			$this->add_payment($row->payment_type, $row->payment_amount);
		}

		$suspended_sale_info = $this->CI->Sale_suspended->get_info($sale_id)->row();
		$this->set_customer($suspended_sale_info->person_id);
		$this->set_comment($suspended_sale_info->comment);

		$this->set_invoice_number($suspended_sale_info->invoice_number);
		$this->set_quote_number($suspended_sale_info->quote_number);
		$this->set_dinner_table($suspended_sale_info->dinner_table_id);
	}
	public function clear_all_push()
	{
		$this->empty_push();
	}
    public function clear_auth_codes()
    {
        unset($_SESSION['sales_auth_code']);
        unset($_SESSION['sales_return_auth_code']);
    }

	public function clear_all()
	{
		$this->set_invoice_number_enabled(FALSE);
		$this->clear_table();
		$this->clear_auth_codes();
		$this->empty_push();
		$this->empty_balance_id();
		$this->empty_sales_id();
		$this->empty_transfer_id();
		$this->empty_lab_accountcart();
		$this->empty_lab_resultcart();
		$this->empty_cart();
		$this->clear_comment();
		$this->clear_email_receipt();
		$this->clear_invoice_number();
		$this->clear_quote_number();
		$this->clear_giftcard_remainder();
		$this->empty_payments();
		$this->remove_customer();
		$this->clear_cash_flags();
		$this->clear_registered_returns();//
        $this->CI->session->unset_userdata('not_for_sale');

    }
	public function clear_all_lab()
	{
		$this->empty_sales_id();
		$this->set_invoice_number_enabled(FALSE);
		$this->clear_table();
		$this->empty_lab_accountcart();
		$this->empty_lab_resultcart();
		$this->empty_labcart();
		$this->clear_comment();
		$this->clear_email_receipt();
		$this->clear_invoice_number();
		$this->clear_quote_number();
		$this->clear_giftcard_remainder();
		$this->empty_payments();
		$this->remove_customer();
		$this->clear_cash_flags();
	}

	public function clear_cash_flags()
	{
		$this->CI->session->unset_userdata('cash_rounding');
		$this->CI->session->unset_userdata('cash_mode');
		$this->CI->session->unset_userdata('payment_type');
	}

	public function reset_cash_flags()
	{
		if ($this->CI->lang->line('payment_options_order') != 'cashdebitcredit') {
			$cash_mode = 1;
		} else {
			$cash_mode = 0;
		}
		$this->CI->session->set_userdata('cash_mode', $cash_mode);

		if ($this->CI->config->config['cash_decimals'] < $this->CI->config->config['currency_decimals']) {
			$cash_rounding = 1;
		} else {
			$cash_rounding = 0;
		}
		$this->CI->session->set_userdata('cash_rounding', $cash_rounding);
	}

	public function is_customer_taxable()
	{


		//Do not charge sales tax if we have a customer that is not taxable
		//the code stub here was removed.
		//no tax is applied. this function is not removed yet in order to avoid code breakage
		//the stub here was calling $customer->taxable which was already removed from the db

		return true; //returning true, we assume every customer is taxable on the only tax we have(i.e VAT)
	}

	/*
	 * This returns taxes for VAT taxes and for pre 3.1.0 sales taxes.
	 */
	public function get_taxes()
	{

		$sales_taxes = array();
		//the code stub here was removed.
		//no tax is applied. this function is not removed yet in order to avoid code breakage

		return $sales_taxes;
	}



	public function get_discount()
	{
		$discount = 0;

		//check whether the customer has discount percent and add it to the individual item discount.

		$customer_id = $this->get_customer();
		$discount_percent = 0;
		$markup = 0;
		if ($customer_id > 0) {
			$customer = $this->CI->Customer->get_info($customer_id);

			//if customer is linked to a company
			if($customer->company_id > 0){
				$company = $this->CI->Customer->get_company_info($customer->company_id);
				if ($company->discount > 0) {
					$discount_percent = $company->discount;
					$markup = $company->markup;
				}
			}elseif ($customer->discount_percent > 0) {
				$discount_percent = $customer->discount_percent;
				$markup = $customer->sale_markup;
			}
			
			// if ($customer->discount_percent > 0) {
			// 	$discount_percent = $customer->discount_percent;
			// }
		}

		foreach ($this->get_cart() as $item) {
			if (($item['discount'] + $discount_percent) > 0) {
				$item_discount = $this->get_item_discount($item['quantity'], $markup == 0 ? $item['price'] : $item['cost'] * $markup, ($item['discount'] + $discount_percent));
				$discount = bcadd($discount, $item_discount);
			}
		}

		return $discount;
	}

	public function get_subtotal($include_discount = FALSE, $exclude_tax = FALSE)
	{
		return $this->calculate_subtotal($include_discount, $exclude_tax);
	}

	public function get_item_total_tax_exclusive($item_id, $quantity, $price, $discount_percentage, $include_discount = FALSE)
	{
		$tax_info = $this->CI->Item_taxes->get_info($item_id);
		$item_price = $this->get_item_total($quantity, $price, $discount_percentage, $include_discount);
		// only additive tax here
		foreach ($tax_info as $tax) {
			$tax_percentage = $tax['percent'];
			$item_price = bcsub($item_price, $this->get_item_tax($quantity, $price, $discount_percentage, $tax_percentage));
		}

		return $item_price;
	}

	public function get_item_total($quantity, $price, $discount_percentage, $include_discount = FALSE)
	{
		$total = bcmul($quantity, $price);
		if ($include_discount) {
			$discount_amount = $this->get_item_discount($quantity, $price, $discount_percentage);

			return bcsub($total, $discount_amount);
		}

		return $total;
	}

	public function get_item_discount($quantity, $price, $discount_percentage)
	{
		$total = bcmul($quantity, $price);
		$discount_fraction = bcdiv($discount_percentage, 100);

		return bcmul($total, $discount_fraction);
	}

	public function get_item_tax($quantity, $price, $discount_percentage, $tax_percentage)
	{
		$price = $this->get_item_total($quantity, $price, $discount_percentage, TRUE);
		if ($this->CI->config->config['tax_included']) {
			$tax_fraction = bcadd(100, $tax_percentage);
			$tax_fraction = bcdiv($tax_fraction, 100);
			$price_tax_excl = bcdiv($price, $tax_fraction);

			return bcsub($price, $price_tax_excl);
		}
		$tax_fraction = bcdiv($tax_percentage, 100);

		return bcmul($price, $tax_fraction);
	}

	public function calculate_subtotal($include_discount = FALSE, $exclude_tax = FALSE)
	{
		$subtotal = 0;
		foreach ($this->get_cart() as $item) {
			if ($exclude_tax && $this->CI->config->config['tax_included']) {
				$subtotal = bcadd($subtotal, $this->get_item_total_tax_exclusive($item['item_id'], $item['quantity'], $item['price'], $item['discount'], $include_discount));
			} else {
				$subtotal = bcadd($subtotal, $this->get_item_total($item['quantity'], $item['price'], $item['discount'], $include_discount));
				// calculate VAT for VATable items
				if (strtolower($item["apply_vat"]) == "yes") {
					/*$app_vat = $this->CI->config->item('vat') ? $this->CI->config->item('vat') : 5;
				$vat = bcmul(bcdiv($app_vat, 100), $item["price"]);
				$vat = bcmul($vat, $item['quantity']);
				$total_vat += $vat;*/
					$subtotal = bcadd($subtotal, $item['vat']);
				}
			}
		}

		return $subtotal;
	}

	public function get_total()
	{
		$total = $this->calculate_subtotal(TRUE);

		$cash_rounding = $this->CI->session->userdata('cash_rounding');

		// foreach ($this->get_taxes() as $sales_tax) {
		// 	$total = bcadd($total, $sales_tax['sale_tax_amount']);
		// }

		if ($cash_rounding) {
            return $this->check_for_cash_rounding($total);
		}
		return round($total,-1);
	}

	public function get_empty_tables()
	{
		return $this->CI->Dinner_table->get_empty_tables();
	}

	public function check_for_cash_rounding($total)
	{
		$cash_decimals = $this->CI->config->config['cash_decimals'];
		$cash_rounding_code = $this->CI->config->config['cash_rounding_code'];
		$rounded_total = $total;

		if ($cash_rounding_code == Rounding_code::HALF_UP) {
			$rounded_total = round($total, $cash_decimals, PHP_ROUND_HALF_UP);
		} elseif ($cash_rounding_code == Rounding_code::HALF_DOWN) {
			$rounded_total = round($total, $cash_decimals, PHP_ROUND_HALF_DOWN);
		} elseif ($cash_rounding_code == Rounding_code::HALF_EVEN) {
			$rounded_total = round($total, $cash_decimals, PHP_ROUND_HALF_EVEN);
		} elseif ($cash_rounding_code == Rounding_code::HALF_ODD) {
			$rounded_total = round($total, $cash_decimals, PHP_ROUND_HALF_UP);
		} elseif ($cash_rounding_code == Rounding_code::ROUND_UP) {
			$fig = (int) str_pad('1', $cash_decimals, '0');
			$rounded_total = (ceil($total * $fig) / $fig);
		} elseif ($cash_rounding_code == Rounding_code::ROUND_DOWN) {
			$fig = (int) str_pad('1', $cash_decimals, '0');
			$rounded_total = (floor($total * $fig) / $fig);
		} elseif ($cash_rounding_code == Rounding_code::HALF_FIVE) {
			$rounded_total = round($total / 5) * 5;
		}

		return round($rounded_total,-1);
	}

	public function set_auth_code($code,$for_returns = false)
	{
	    if($for_returns){
            $this->CI->session->set_userdata('sales_return_auth_code', $code);
        }else{
            $this->CI->session->set_userdata('sales_auth_code', $code);
        }

	}

	public function get_auth_code($for_returns = false)
	{
	    if($for_returns){
	        return $this->CI->session->userdata('sales_return_auth_code') ? $this->CI->session->userdata('sales_return_auth_code') : null;
        }
		return $this->CI->session->userdata('sales_auth_code') ? $this->CI->session->userdata('sales_auth_code') : null;
	}

	public function setTotalVat($totalVat)
	{
		$this->CI->session->userdata('total_vat', $totalVat);
	}

	public function getTotalVat()
	{
		return $this->CI->session->userdata('total_vat') ? $this->CI->session->userdata('total_vat') : 0;
	}
}
