<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once("Secure_Controller.php");
class Items extends Secure_Controller
{
	public function __construct()
	{
		parent::__construct('items');
		$this->load->library('item_lib');
		$this->load->library('sale_lib');
		$this->load->library('barcode_lib');
		$this->load->library('simpleXLSX');
	}
	public function index()
	{
		//$this->sale_lib->clear_all();
		$filters = array(
			'empty_upc' => FALSE,
			'low_inventory' => FALSE,
			'no_description'  => FALSE,
			'reorder_level'  => FALSE,
			'expiry' => FALSE,
			'apply_vat' => FALSE,
		);
		
//		$filledup = array_fill_keys($this->input->get('filters'), TRUE);
//		$filtes = array_merge($filters, $filledup);
		$item_location = $this->sale_lib->get_sale_location();
		$data['sale_stuff'] = $this->Item->get_sales();
		$data['notice'] = $this->sale_lib->notice_transfer_items($item_location);
		$data['table_headers'] = $this->xss_clean(get_items_manage_table_headers());
		//$data['table_headees'] = $this->xss_clean(get_items_manage_table_heders());
		$data['transfer'] = $this->sale_lib->global_transfer_items($item_location);
		$data['stock_location'] = $this->xss_clean($this->item_lib->get_item_location());
		//print_r($data); exit();
		$data['stock_locations'] = $this->xss_clean($this->Stock_location->get_allowed_locations());
		// filters that will be loaded in the multiselect dropdown
		$data['filters'] = array(
			'empty_upc' => $this->lang->line('items_empty_upc_items'),
			'low_inventory' => $this->lang->line('items_low_inventory_items'),
			'no_description' => $this->lang->line('items_no_description_items'),
			'reorder_level' => 'Reorder level items',
			'is_deleted' => "Deleted",
			'expiry' => 'Expiring',
			'apply_vat' => 'VATable Items'
		);
		//Add all categories to the filter
		$cats = $this->Item->categories_list();
		foreach ($cats as $row => $value) {
			$data['filters'][str_replace(' ', '_', $value['name'])] = $value['name'];
			// $data['filters'][str_replace(' ', '_', $value['type'])] = $value['type'];
		}
		$this->load->view('items/manage', $data);
	}
	public function receive_transfer()
	{
		// Save the data to the sales table
		$transfer_id = $this->input->post('transfer_id');
		$transfer_info = $this->Item->get_info_transfer($transfer_id);
		$this->sale_lib->set_transfer_id($transfer_id);
		$transfer_type = $transfer_info->transfer_type;
		//$data['cart']=array ( 1 => array ( 'item_id' => 1330,'item_location' => 1,'stock_name' => 'warehouse','line'=> 1, 'name' => 'Booyks','allow_alt_description' => 0,'is_serialized' => 0,'quantity' => 1,'discount' => 0,'in_stock' => 24.000,'price' => 4900,'wholeprice' => 3000,'total' => 8000,'discounted_total' => 7000,'print_option' => 1,'stock_type' => 0,'tax_category_id' => 0 ), 2 => array ( 'item_id' => 1331,'item_location' => 1,'stock_name' => 'warehouse','line' => 2, 'name' => 'Panadole','allow_alt_description' => 0,'is_serialized' => 0,'quantity' => 1,'discount' => 0,'in_stock' => 10.000,'price' => 4900,'wholeprice' => 3000,'total' => 8000,'discounted_total' => 7000,'print_option' => 1,'stock_type' => 0, 'tax_category_id' => 0 ) ) ;
		$data['cart'] = $this->sale_lib->get_pushedcart_reordered($transfer_id);
		if ($transfer_type == "PULL") {
			$data['cart'] = $this->sale_lib->get_pulledcart_reordered($transfer_id);
			$this->load->view('items/push_pull', $data);
		}
		if ($transfer_type == "PUSH") {
			$this->load->view('items/receive_transfer', $data);
		}
		$data['transfer_type'] = $transfer_type;
		//$customer_id=23;
		$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		//$this->load->view('items/receive_transfer', $data);
	}
	public function categories()
	{
		$cat_items = array();
		$dat = $this->Item->categories_list();
		$categories = array();
		foreach ($dat as $row => $value) {
			$categories[] = array('id' => $value['id'], 'name' => $value['name'], 'type' => $value['type']); //categorization
			// $categories[] = array('id' => $value['id'], 'name' => $value['name']);
		}
		$data['categories'] = $categories;
		$this->load->view('items/category', $data);
	}
	public function delete_category($id)
	{
		$this->db->delete('categories', array('id' => $id));
		$this->categories();
	}
	public function categories_list()
	{
		echo json_encode($this->get_categories());
	}
	public function get_categories()
	{
		$cat_items = array();
		$data = $this->Item->categories_list();
		foreach ($data as $row => $value) {
			$cat_items[] = array('id' => $value['id'], 'name' => $value['name'], 'type' => $value['type'], 'edit' => '<button type="button" id="getEdit" class="btn btn-primary btn-xs edit_cat" data-toggle="modal" data-target="#myModal" data-id="' . $value['id'] . '"><i class="glyphicon glyphicon-pencil">&nbsp;</i>Edit</button><a href="index.php?delete=' . $value['id'] . '" onclick="return confirm(\'Are You Sure ?\')" class="btn btn-danger btn-xs"><i class="glyphicon glyphicon-trash">&nbsp;</i>Delete</a>', 'delete' => '');
		}
		$results = array(
			"sEcho" => 1,
			"iTotalRecords" => count($cat_items),
			"iTotalDisplayRecords" => count($cat_items),
			"aaData" => $cat_items
		);
		return $results;
	}
	public function request_items_from_other_branch()
	{
		$data = array();
		$push = array();
		$employee = $this->Employee->get_logged_in_employee_info();
		$push = $this->sale_lib->get_push();
		$push_from_branch = $employee->branch_id;
		$items = 0;
		$status = 'PENDING';
		$transfer_type = 'REQ';
		$pushed_to_branch = $this->input->post('transfer_to_location');
		$transfered = $this->Sale->save_request($push, $items, $transfer_type, $push_from_branch, $pushed_to_branch, $status);
		if ($transfered > 0) {
			$data['push'] = $this->sale_lib->get_push();
			//show the receipt
			$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
			$employee_info = $this->Employee->get_info($employee_id);
			$data['employee'] = $employee_info->first_name . ' ' . $employee_info->last_name;
			$data['receipt_title'] = 'Items Request Receipt';
			$data['transaction_time'] = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'));
			$data['from_branch'] = $this->config->item('branch_name');
			$data['to_branch'] = $pushed_to_branch;
			$data['request_id'] = $transfered;
			$data['print_after_sale'] = 0;
			$data['barcode'] = $this->barcode_lib->generate_receipt_barcode('REQ ' . $transfered);
			$this->load->view("items/request_receipt", $data);
			$this->sale_lib->clear_all_push();
		} else {
			$data['error_message'] = "Product(s) request failed. Check for corrections and try again or contact administrator now!";
			$this->load->view('items/request_item', $data);
		}
	}
	/*
	Returns Items table data rows. This will be called with AJAX.
	*/
	public function transfer_items_to_other_branch()
	{
		$data = array();
		$push = array();
		$push = $this->sale_lib->get_transfer();
		$push_from_branch = $this->sale_lib->get_sale_location();
		$items = 0;
		$status = 0;
		$transfer_type = 'TRN';
		// $pushed_to_branch = $this->input->post('transfer_to_location');
		// $to_branch = 'maitama';
		$request_id = $this->input->post('request_id');
		// $to_branch = $this->input->post('to_branch');
		$to_branch = $this->sale_lib->get_transfer_branch();
		// 	print_r($push);
		// echo "branch id : ".$to_branch; exit();
		//echo "to branch : ".$to_branch; exit();
		$transfered = $this->Sale->save_transfer_of_items($push, $request_id, $items, $transfer_type, $to_branch, $status);
		if ($transfered > 0) {
			$data['push'] = $this->sale_lib->get_transfer();
			//show the receipt
			$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
			$employee_info = $this->Employee->get_info($employee_id);
			$data['employee'] = $employee_info->first_name . ' ' . $employee_info->last_name;
			$data['receipt_title'] = 'Items Transfer Receipt';
			$data['transaction_time'] = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'));
			// $data['to_branch'] = $this->CI->Stock_location->get_location_name($pushed_to_branch);
			$data['to_branch'] = $to_branch;
			$data['transfer_id'] = $transfered;
			$data['print_after_sale'] = 0;
			$data['barcode'] = $this->barcode_lib->generate_receipt_barcode('TRN ' . $transfered);
			$this->load->view("items/transfer_receipt", $data);
			$this->sale_lib->empty_transfer();
			$this->sale_lib->empty_transfer_branch();
		} else {
			$data['error_message'] = "Product(s) transfer failed. Check for corrections and try again or contact administrator now!";
			$this->load->view('items/request_item', $data);
		}
	}
	/*
	Returns Items table data rows. This will be called with AJAX.
	*/
    //endpoint for receipts after ajax items push
    public function push_receipt($pn,$fn=null){
        $pgN = $fn==null ? $pn : $fn.'/'.$pn;
        if(file_exists(VIEWPATH.'/'.$pgN.'.php')){
            $data = json_decode($this->input->post('data'),true);
            $this->load->view($pgN,$data);
        }else{
            show_404();
        }
    }
	public function global_item_push_transfer($aj_req = 0)
	{
		$data = array();
		if($aj_req == 1){
		    $push = json_decode($this->input->post('selected_items'),true);
        }else{
            $push = $this->sale_lib->get_push();
        }
		$push_from_branch = $this->sale_lib->get_sale_location();
		$items = 0;
		$status = "PENDING";
		$transfer_type = 'PUSH';
		$pushed_to_branch = $this->input->post('transfer_to_location');
		if(!is_numeric($pushed_to_branch)){
			$data['error_message'] = "You must Select vaild Branch";
			redirect("items/push");
			exit();
		}
		$transfered = $this->Sale->save_transfer($push, $items, $transfer_type, $push_from_branch, $pushed_to_branch, $status);
		if(is_string($transfered)){
            $data['error_message'] = $transfered;
        }
		if (!isset($data['error_message']) && $transfered > 0) {
//			$data['push'] = $this->sale_lib->get_push();
            $data['push'] = $push;
			//show the receipt
			$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
			$employee_info = $this->Employee->get_info($employee_id);
			$data["branch_details"]=$this->Stock_location->get_location_details($employee_info->branch_id);
			$data['employee'] = $employee_info->first_name . ' ' . $employee_info->last_name;
			$data['receipt_title'] = $this->lang->line('transfer_receipt');
			$data['transaction_time'] = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'));
			// $data['date'] = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), strtotime($data['meta']->transfer_time));
			$data['from_branch'] = $this->CI->Stock_location->get_location_name($push_from_branch);
			$data['to_branch'] = $this->CI->Stock_location->get_location_name($pushed_to_branch);
			$data['transfer_id'] = $transfered;
			$data['print_after_sale'] = 0;
			$data['barcode'] = $this->barcode_lib->generate_receipt_barcode('PUSH ' . $transfered);
			if($aj_req == 1){
			    echo json_encode(['success'=>"Item transferred!",'receipt_data'=>$data,'folder_name'=>'items','page'=>'local_transfer_receipt']);
            }else{
                $this->load->view("items/local_transfer_receipt", $data);
            }
			$this->sale_lib->clear_all_push();
			$this->session->set_userdata("my_transfer_branch_id","");
		} else {
			$data['error_message'] = "Product(s) transfer failed. Check for corrections and try again or contact administrator now!";
            if($aj_req == 1){
                echo json_encode(['error'=>"Product(s) transfer failed. Check for corrections and try again or contact administrator now!"]);
            }else{
                // $this->load->view('items/push', $data);
				$this->load->view('items/push_febd', $data);
            }
		}
		/*$data['sale_id_num'] = $this->Sale->save_transfer($items,$quantity,$request_branch,$transfer_branch,$status, $transfer_id);
				
				$data = $this->xss_clean($data);
				if($data['sale_id_num'] == -1)
				{
					$data['error_message'] = $this->lang->line('sales_transaction_failed');
				}*/
		/*if($this->Sale->save_transfer($items,$request_branch,$transfer_branch,$status, $transfer_id))
		{
			echo json_encode(array('success' => TRUE, 'message' => $this->lang->line('sales_successfully_updated'), 'id' => $sale_id));
		}
		else
		{
			echo json_encode(array('success' => FALSE, 'message' => $this->lang->line('sales_unsuccessfully_updated'), 'id' => $sale_id));
		}*/
	}
	public function global_item_pull_transfer()
	{
		$data = array();
		$pull = array();
		$pull_data = array();
		$unique_location = array();
		$pull = $this->sale_lib->get_push();
		$transfer_location = $this->sale_lib->get_sale_location();
		foreach ($pull as $row => $value) {
			array_push($pull_data, $value['branch_transfer']);
			//$check[]=$value['location'];
		}
		$unique_location = array_unique($pull_data);
		foreach ($unique_location as $row => $value) {
			$transfer_data = array();
			$items = 0;
			$transfer_type = 'PULL';
			$pushed_to_branch = $value;
			$push_from_branch = $transfer_location;
			$status = 0;
			$this->Sale->save_pull_transfer($pull, $items, $transfer_type, $push_from_branch, $pushed_to_branch, $status, $transfer_id = 0);
		}
		/*$data['sale_id_num'] = $this->Sale->save_transfer($items,$quantity,$request_branch,$transfer_branch,$status, $transfer_id);
				
				$data = $this->xss_clean($data);
				if($data['sale_id_num'] == -1)
				{
					$data['error_message'] = $this->lang->line('sales_transaction_failed');
				}*/
		/*if($this->Sale->save_transfer($items,$request_branch,$transfer_branch,$status, $transfer_id))
		{
			echo json_encode(array('success' => TRUE, 'message' => $this->lang->line('sales_successfully_updated'), 'id' => $sale_id));
		}
		else
		{
			echo json_encode(array('success' => FALSE, 'message' => $this->lang->line('sales_unsuccessfully_updated'), 'id' => $sale_id));
		}*/
		$this->sale_lib->clear_all_push();
		$data['pull'] = $this->sale_lib->get_push();
		$this->load->view('items/pull', $data);
	}
	public function check_price(){
		$this->load->view('items/check_price', array());
	}
	public function global_item_trans_search($query = ''){
		/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/
		$query = $this->input->get('query');
		$from_date="";
		$to_date="";
		if($this->input->get('daterange')!=""){
			$data["daterange"]=$daterange=$this->input->get('daterange');
			$date_segments=explode("-",$daterange);
			$from_date=date("Y-m-d",strtotime($date_segments[0]));
			$to_date=date("Y-m-d",strtotime($date_segments[1]));
		}
		
		$data = array();
		$data['search_query'] = $query;
		$data['items'] = $this->Item->global_item_trans_search_data(array("search_val"=>$query,"from_date"=>$from_date,"to_date"=>$to_date));
		$this->load->view('items/global_item_trans_search', $data);
	}
	public function global_search($query = ''){
		$query = $this->input->get('query');
		$data = array();
		$data['search_query'] = $query;
		$data['items'] = $this->Receiving->get_global_search($query);
		$this->load->view('items/global_search', $data);
	}
    public function create_stock_report(){
        $created_on=date("Y-m-d H:i:s");
        $empDet = $this->Employee->get_logged_in_employee_info();
        $saved=$this->Item->record_stock($created_on,$empDet->branch_id);
        if($saved){
        	redirect("Items/stock_report");
        }
    }
    function stock_report_delete($id){
    	$deleted=$this->Item->delete_stock_report_data($id);
    	if($deleted){
    		redirect("Items/stock_report");
    	}
    }
	public function stock_report(){
		/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/
		$empDet = $this->Employee->get_logged_in_employee_info();
		$data["list"]=$this->Item->get_stock_values($empDet->branch_id);
		$data["latest_stock_data"]=$this->Item->get_latest_stock_value($empDet->branch_id);
		// /print_r($data); exit();
		$this->load->view('items/stock_report', $data);
	}
	public function search()
	{
		$old_limit = ini_get('memory_limit');
		ini_set('memory_limit','-1');
		$search = $this->input->get('search');
		$limit = $this->input->get('limit');
		$offset = $this->input->get('offset');
		$sort = $this->input->get('sort');
		$order = $this->input->get('order');
		$this->item_lib->set_item_location($this->input->get('stock_location'));
		$filters = array(
			'start_date' => $this->input->get('start_date'),
			'end_date' => $this->input->get('end_date'),
			'stock_location_id' => $this->item_lib->get_item_location(),
			'empty_upc' => FALSE,
			'low_inventory' => FALSE,
			'is_serialized' => FALSE,
			'no_description' => FALSE,
			'search_custom' => FALSE,
			'is_deleted' => FALSE
		);
		// check if any filter is set in the multiselect dropdown
		$filledup = array_fill_keys($this->input->get('filters'), TRUE);
		$filters = array_merge($filters, $filledup);
		//$data['table_headers'] = $this->xss_clean(get_items_manage_table_headers($filters));
		$items = $this->Item->search($search, $filters, 0, $offset)->result();
		//$total_rows = $this->Item->get_found_rows($search, $filters);
		$found_items = array_slice($items, $offset, $limit); //limit is usually more than 0
		$total_rows = count($items);
		$data_rows = array();
		foreach ($found_items as $item) {
		    $itm = get_item_data_row($item, $this);
			if (count($itm) != 0) {
				$data_rows[] = $this->xss_clean($itm);
				if ($item->pic_filename != '') {
					$this->_update_pic_filename($item);
				}
			}
		}
		//$this->load->view('items/manage', $data);
		echo json_encode(array('total' => $total_rows, 'rows' => $data_rows,'all'=>$items));
		ini_set('memory_limit',$old_limit);
	}
	public function pic_thumb($pic_filename)
	{
		$this->load->helper('file');
		$this->load->library('image_lib');
		// in this context, $pic_filename always has .ext
		$ext = pathinfo($pic_filename, PATHINFO_EXTENSION);
		$images = glob('./uploads/item_pics/' . $pic_filename);
		// make sure we pick only the file name, without extension
		$base_path = './uploads/item_pics/' . pathinfo($pic_filename, PATHINFO_FILENAME);
		if (sizeof($images) > 0) {
			$image_path = $images[0];
			$thumb_path = $base_path . $this->image_lib->thumb_marker . '.' . $ext;
			if (sizeof($images) < 2) {
				$config['image_library'] = 'gd2';
				$config['source_image']  = $image_path;
				$config['maintain_ratio'] = TRUE;
				$config['create_thumb'] = TRUE;
				$config['width'] = 52;
				$config['height'] = 32;
				$this->image_lib->initialize($config);
				$image = $this->image_lib->resize();
				$thumb_path = $this->image_lib->full_dst_path;
			}
			$this->output->set_content_type(get_mime_by_extension($thumb_path));
			$this->output->set_output(file_get_contents($thumb_path));
		}
	}
	/*
	Gives search suggestions based on what is being searched for
	*/
	public function suggest_search()
	{
		$suggestions = $this->xss_clean($this->Item->get_search_suggestions(
			$this->input->post_get('term'),
			array('search_custom' => $this->input->post('search_custom'), 'is_deleted' => $this->input->post('is_deleted') != NULL),
			FALSE
		));
		echo json_encode($suggestions);
	}
	public function suggest()
	{
		$suggestions = $this->xss_clean($this->Item->get_search_suggestions(
			$this->input->post_get('term'),
			array('search_custom' => FALSE, 'is_deleted' => FALSE),
			TRUE
		));
		echo json_encode($suggestions);
	}
	public function complete_push()
	{
		/*$data = array();
		$data['dinner_table'] = $this->sale_lib->get_dinner_table();
		$data['push'] = $this->sale_lib->get_push();
		
		$data['sale_id_num'] = $this->Sale->save($data['push']);
		$data['sale_id'] = 'POS ' . $data['sale_id_num'];
				// Resort and filter cart lines for printing
		//$data['push'] = $this->sale_lib->sort_and_filter_cart($data['push']);
		$data = $this->xss_clean($data);
		if($data['sale_id_num'] == -1)
		{
			$data['error_message'] = $this->lang->line('sales_transaction_failed');
		}
		
		*/
	}
	public function suggest_kits()
	{
		$suggestions = $this->xss_clean($this->Item->get_kit_search_suggestions(
			$this->input->post_get('term'),
			array('search_custom' => FALSE, 'is_deleted' => FALSE),
			TRUE
		));
		echo json_encode($suggestions);
	}
	/*
	Gives search suggestions based on what is being searched for
	*/
	public function suggest_category()
	{
		$suggestions = $this->xss_clean($this->Item->get_category_suggestions($this->input->get('term')));
		echo json_encode($suggestions);
	}
	/*
	 Gives search suggestions based on what is being searched for
	*/
	public function suggest_location()
	{
		$suggestions = $this->xss_clean($this->Item->get_location_suggestions($this->input->get('term')));
		echo json_encode($suggestions);
	}
	/*
	 Gives search suggestions based on what is being searched for
	*/
	public function suggest_custom()
	{
		$suggestions = $this->xss_clean($this->Item->get_custom_suggestions($this->input->post('term'), $this->input->post('field_no')));
		echo json_encode($suggestions);
	}
	public function get_row($item_ids)
	{
		$item_infos = $this->Item->get_multiple_info(explode(":", $item_ids), $this->item_lib->get_item_location());
		$result = array();
		foreach ($item_infos->result() as $item_info) {
			$result[$item_info->item_id] = $this->xss_clean(get_item_data_row($item_info, $this));
		}
		echo json_encode($result);
	}
	public function view_update($item_id = -1)
	{
		ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
		$data['item_tax_info'] = $this->xss_clean($this->Item_taxes->get_info($item_id));
		$data['default_tax_1_rate'] = '';
		$data['default_tax_2_rate'] = '';
		$data["empDet"]=$empDet=$this->Employee->get_logged_in_employee_info();
		$data['item_kits_enabled'] = $this->Employee->has_grant('item_kits', $empDet->person_id);
		$item_info = $this->Item->get_info($item_id);
		//exit();
		$data['departments'] = ["pharmacy"=>"Pharmacy","superstore"=>"Superstore"];
		$data['selected_dept'] = $item_info->type;
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		if ($item_id == -1) {
			$data['default_tax_1_rate'] = $this->config->item('default_tax_1_rate');
			$data['default_tax_2_rate'] = $this->config->item('default_tax_2_rate');
			$item_info->receiving_quantity = 0;
			$item_info->reorder_level = 0;
			$item_info->item_type = '0'; // standard
			$item_info->stock_type = '0'; // stock
			$item_info->tax_category_id = 0;
		}
		$data['item_info'] = $item_info;
		$suppliers = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_all()->result_array() as $row) {
			$suppliers[$this->xss_clean($row['person_id'])] = $this->xss_clean($row['company_name']);
		}
		$categories = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_all_categories()->result_array() as $row) {
			$categories[$this->xss_clean($row['name'])] = $this->xss_clean($row['name']);
		}
		$data['categories'] = $categories;
		$data['suppliers'] = $suppliers;
		$data['selected_supplier'] = $item_info->supplier_id;
		$data['selected_category'] = $item_info->category;
		$data['selected_period'] = $item_info->period;
		$customer_sales_tax_support = $this->config->item('customer_sales_tax_support');
		if ($customer_sales_tax_support == '1') {
			$data['customer_sales_tax_enabled'] = TRUE;
			$tax_categories = array();
			foreach ($this->Tax->get_all_tax_categories()->result_array() as $row) {
				$tax_categories[$this->xss_clean($row['tax_category_id'])] = $this->xss_clean($row['tax_category']);
			}
			$data['tax_categories'] = $tax_categories;
			$data['selected_tax_category'] = $item_info->tax_category_id;
		} else {
			$data['customer_sales_tax_enabled'] = FALSE;
			$data['tax_categories'] = array();
			$data['selected_tax_category'] = '';
		}
		$data['logo_exists'] = $item_info->pic_filename != '';
		$ext = pathinfo($item_info->pic_filename, PATHINFO_EXTENSION);
		if ($ext == '') {
			// if file extension is not found guess it (legacy)
			$images = glob('./uploads/item_pics/' . $item_info->pic_filename . '.*');
		} else {
			// else just pick that file
			$images = glob('./uploads/item_pics/' . $item_info->pic_filename);
		}
		$data['image_path'] = sizeof($images) > 0 ? base_url($images[0]) : '';
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		$item_location = $this->sale_lib->get_sale_location();
		$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $item_location)->quantity);
		$quantity = ($item_id == -1) ? 0 : $quantity;
		//$location_name=$this->CI->Stock_location->get_location_name($item_location)
		$location_array[$item_location] = array('location_name' => $item_location, 'quantity' => $quantity);
		$per_pack = $item_info->pack !=0 ? $item_info->pack : 1;
		$item_info->package = $quantity / $per_pack;
		$data['stock_locations'] = $location_array;
		$period = array(
			'days' => 'days',
			'week' => 'Weeks',
			'month' => 'Months'
		);
		$data['period'] = $period;
		$product_type = array(
			'' => 'Select',
			'Syrup'		=>	'Syrup',
			'Tablet'	=>	'Tablet',
			'Eyedrops'	=>	'Eye drops',
			'Rub'		=>	'Rub',
			'Injection'	=>	'Injection',
			'Capsules'	=>	'Capsules',
			'Inhaler'	=>	'Inhaler',
			'Suspension'	=> 'Suspension',
			'Cream'		=>	'Cream',
			'Ointment'	=>	'Ointment',
			'Pant'		=> 'Pant',
			'Sweet'		=> 'Sweet',
			'Elixir'	=> 'Elixir',
			'Tonic'		=> 'Tonic',
			'Mixture'	=> 'Mixture',
			'Suppository'	=> 'Suppository',
			'Pessaries'		=> 'Pessaries',
			'Medical Device'	=> 'Medical Device',
			'Gel'				=> 'Gel',
			'Eye / Ear Drop'	=> 'Eye / Ear Drop',
			'Lotion'			=> 'Lotion',
			'Effrer'			=> 'Effrer',
			'Powder'			=> 'Powder',
		);
		$data['period'] = $period;
		$data['selected_period'] = $item_info->period;
		$data['selected_product_type'] = $item_info->formulation;
		$data['product_type'] = $product_type;
		$this->load->view('items/form_update', $data);
	}
    public function view_expiry_batch($item_id = -1)
    {
        $data['batches'] =$this->Item->fetch_item_batches($item_id,$this->Employee->get_logged_in_employee_info()->branch_id);
        $this->load->view('items/item_batches', $data);
    }
	public function pill(){
		$this->load->view('items/form', $data);
	}
	public function view($item_id = -1)
	{
		$data['item_tax_info'] = $this->xss_clean($this->Item_taxes->get_info($item_id));
		$data['default_tax_1_rate'] = '';
		$data['default_tax_2_rate'] = '';
		$data['item_kits_enabled'] = $this->Employee->has_grant('item_kits', $this->Employee->get_logged_in_employee_info()->person_id);
		$data['empDet']=$this->Employee->get_logged_in_employee_info();
		$item_info = $this->Item->get_info($item_id);
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		if ($item_id == -1) {
			$data['default_tax_1_rate'] = $this->config->item('default_tax_1_rate');
			$data['default_tax_2_rate'] = $this->config->item('default_tax_2_rate');
			$item_info->receiving_quantity = 0;
			$item_info->reorder_level = 0;
			$item_info->item_type = '0'; // standard
			$item_info->stock_type = '0'; // stock
			$item_info->tax_category_id = 0;
		}
		$data['item_info'] = $item_info;
		$suppliers = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_all()->result_array() as $row) {
			$suppliers[$this->xss_clean($row['person_id'])] = $this->xss_clean($row['company_name']);
		}
		$categories = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_all_categories()->result_array() as $row) {
			$item = $row['name'] . " ( " . strtoupper($row['type']) . " )"; //categorization
			// $item = $row['name'];
			$categories[$this->xss_clean($item)] = $this->xss_clean($item);
		}
		$data['categories'] = $categories;
		$data['suppliers'] = $suppliers;
		$data['selected_supplier'] = $item_info->supplier_id;
		$data['selected_category'] = $item_info->category;
		$data['selected_period'] = $item_info->period;
		$customer_sales_tax_support = $this->config->item('customer_sales_tax_support');
		if ($customer_sales_tax_support == '1') {
			$data['customer_sales_tax_enabled'] = TRUE;
			$tax_categories = array();
			foreach ($this->Tax->get_all_tax_categories()->result_array() as $row) {
				$tax_categories[$this->xss_clean($row['tax_category_id'])] = $this->xss_clean($row['tax_category']);
			}
			$data['tax_categories'] = $tax_categories;
			$data['selected_tax_category'] = $item_info->tax_category_id;
		} else {
			$data['customer_sales_tax_enabled'] = FALSE;
			$data['tax_categories'] = array();
			$data['selected_tax_category'] = '';
		}
		$data['logo_exists'] = $item_info->pic_filename != '';
		$ext = pathinfo($item_info->pic_filename, PATHINFO_EXTENSION);
		if ($ext == '') {
			// if file extension is not found guess it (legacy)
			$images = glob('./uploads/item_pics/' . $item_info->pic_filename . '.*');
		} else {
			// else just pick that file
			$images = glob('./uploads/item_pics/' . $item_info->pic_filename);
		}
		$data['image_path'] = sizeof($images) > 0 ? base_url($images[0]) : '';
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		$item_location = $this->sale_lib->get_sale_location();
		$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $item_location)->quantity);
		$quantity = ($item_id == -1) ? 0 : $quantity;
		//$location_name=$this->CI->Stock_location->get_location_name($item_location)
		$location_array[$item_location] = array('location_name' => $item_location, 'quantity' => $quantity);
		$per_pack = isset($item_info->pack) ? $item_info->pack : 1;
		$item_info->package = $quantity / $per_pack;
		$data['stock_locations'] = $location_array;
		$period = array(
			'days' => 'days',
			'week' => 'Weeks',
			'month' => 'Months'
		);
		$data['period'] = $period;
		$product_type = array(
			'' => 'Select',
			'syrup' => 'Syrup',
			'tablet' => 'Tablet',
			'Eyedrops' => 'Eye drops',
			'Rub' => 'Rub',
			'Injection' => 'Injection',
			'Capsules' => 'Capsules',
			'Inhaler' => 'Inhaler'
		);
		$data['period'] = $period;
		$data['selected_period'] = $item_info->period;
		$data['selected_product_type'] = $item_info->formulation;
		$data['product_type'] = $product_type;
		$this->load->view('items/form', $data);
	}
	public function clear_cache(){
		$this->db->cache_delete_all();
		echo "cleared";
	}
	public function item_search($for_dispatch = 0)
	{
		$suggestions = array();
		$receipt = $search = $this->input->get('term') != '' ? $this->input->get('term') : NULL;
		if ($this->sale_lib->get_mode() == 'return' && $this->Sale->is_valid_receipt($receipt)) {
			// if a valid receipt or invoice was found the search term will be replaced with a receipt number (POS #)
			$suggestions[] = $receipt;
		}
		$is_dispatch = $for_dispatch ==1;
		$branch_id = $this->Employee->get_logged_in_employee_info()->branch_id;
		$suggestions = array_merge($suggestions, $this->Item->get_search_suggestions($search, array('search_custom' => FALSE, 'is_deleted' => FALSE,'branch_id'=>$branch_id), TRUE,1000,$is_dispatch));
		//$suggestions = array_merge($suggestions, $this->Item_kit->get_search_suggestions($search));
		$suggestions = $this->xss_clean($suggestions);
		echo json_encode($suggestions);
	}
	public function batch_search()
	{
		$suggestions = array();
		$search = $this->input->get('term') != '' ? $this->input->get('term') : NULL;
		$suggestions = array_merge($suggestions, $this->Item->get_batchsearch_suggestions($search));
		$suggestions = $this->xss_clean($suggestions);
		echo json_encode($suggestions);
	}
	public function set_nearest_five()
	{
		$amount = $this->input->post("amount") ? floatval($this->input->post("amount")) : 0;
		echo json_encode(array("amount" => get_nearest_five($amount)));
		// echo json_encode(array("amount" => $amount));
	}
	public function test_5($amount){
		print_r(get_nearest_five($amount));
	}
	public function edit_item_received($line_id)
	{
		$data = array();
		$no_of_batch = $this->input->post('no_of_batch') == '' ? 0 : $this->input->post('no_of_batch');
		$value_changed = $this->input->post('value_changed');
		$reference = $this->input->post('reference');
		$line = $this->input->post('line');
		$item_id = $this->input->post('item_id');
		$quantity = $this->input->post('quantity');
		$request_from_branch_id = $this->input->post('request_from_branch_id');
		$request_to_branch_id = $this->input->post('request_to_branch_id');
		$received_quantity = $this->input->post('received_quantity');;
		$transfer_id = $this->input->post('transfer_id');
		$received_batch_quantity = $this->input->post('received_batch_quantity') == '' ? 0 : $this->input->post('received_batch_quantity');
		$unaccounted = $this->input->post('unaccounted');
		$batch_no = $this->input->post('batch_no');
		$expiry = $this->input->post('expiry');
		$itemset = $this->sale_lib->get_push();
		if ($no_of_batch == 0 && $reference == 0 && $received_quantity != 0) {
			$received_quantity = $this->input->post('received_quantity');
			$this->sale_lib->edit_received_items($line, $received_quantity, $batch_no, $expiry = null);
		}
		if (($reference == 0) && ($no_of_batch != 0)) {
			foreach ($itemset as $row => $value) {
				if ($value['reference'] == $line) {
					$this->sale_lib->delete_item_push($row);
					//$this->delete_received_item($row);
				}
			}
			for ($i = 0; $i < $no_of_batch; $i++) {
				$this->sale_lib->add_reciever_push($item_id, $quantity, $request_from_branch_id, $request_to_branch_id, $transfer_id, $received_batch_quantity, $unaccounted, $line, $batch_no, $expiry);
			}
		}
		if ($reference != 0 && $no_of_batch == 0) {
			$received_quantity = $this->input->post('received_quantity');
			$this->sale_lib->edit_received_items($line, $received_batch_quantity, $batch_no, $expiry);
		}
		$data['line'] = $line;
		$data['received_batch_quantity'] = $received_batch_quantity;
		$data['reference'] = $reference;
		$data['value_changed'] = $value_changed;
		$data['no_of_batch'] = $no_of_batch;
		$data['received_quantity'] = $received_quantity;
		$data['cart'] = $this->sale_lib->get_push();
		$this->load->view('items/receive_transfer', $data);
	}
	public function edit_item_batch_request($line_id)
	{
		$data = array();
		$item_location = $this->sale_lib->get_sale_location();
		$locator = array('' => "Select Branch");
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		//$this->form_validation->set_rules('quantity', 'lang:items_quantity', 'required|callback_numeric');
		$location = 'not needed'; //$this->input->post('location');
		$branch_transfer = 0; //$this->sale_lib->get_transfer_branch_id($location); //id of the location you just selected
		$item_name = $this->input->post('item_name');
		//$quantity = parse_decimals($this->input->post('quantity'));
		$stockno = parse_decimals($this->input->post('stockno'));
		$quantit = parse_decimals($this->input->post('quantity'));
		$quantity = parse_decimals($this->input->post('quantity'));
		//check whether quantity is normal or above what is present in stock
		$item_location = $this->input->post('item_location');
		$batch_id = $this->input->post('batch') == '' ? 0 : $this->input->post('batch');
		$batch_info = $this->Item->get_info_batch($batch_id);
		$batch_no = $batch_info->batch_no;
		$expiry = $batch_info->expiry;
		//$value_changed= $this->input->post('value_changed');
		$reference = $this->input->post('reference');
		$line = $this->input->post('line');
		$item_id = $this->input->post('item_id');
		//$quantity= $this->input->post('quantity');
		$request_from_branch_id = $this->input->post('request_from_branch_id');
		$pack_type = $this->input->post('pack_type');
		$transfer_price = $this->input->post('transfer_price'); //there is no need to validate this since is selection
		//Check whether the price is not over what is in the stock
		$item_quant = $this->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity;
		// if ($quantity > $item_quant || $quantity <= 0) {
		// 	$quantity = 1;
		// 	$data['warning'] = "Warning, Inputed Product Quantity is Insufficient or invalid,Reduce quantity to process transfer or contact Admin to update inventory";
		// }
		$request_to_branch_id = $this->input->post('request_to_branch_id');
		$received_quantity = $this->input->post('received_quantity');;
		$transfer_id = $this->input->post('transfer_id');
		$received_batch_quantity = $this->input->post('received_batch_quantity') == '' ? 0 : $this->input->post('received_batch_quantity');
		$unaccounted = $this->input->post('unaccounted');
		//$batch_no= $this->input->post('batch_no');
		//$expiry= $this->input->post('expiry');
		$itemset = $this->sale_lib->get_push();
		if ($batch_id == 0 && $reference == 0) {
			$received_quantity = $this->input->post('received_quantity');
			$this->sale_lib->edit_item_request($line, $item_name, $item_location, $quantity, $location, $branch_transfer, $batch_no = 0, $expiry = null);
			//$this->sale_lib->edit_pushed_items($line, $quantity,$batch_no=0,$expiry=null);
		}
		if (($reference == 0) && ($batch_id != 0)) {
			$this->sale_lib->add_item_request($item_id, $quantity, $request_from_branch_id, $request_to_branch_id, $transfer_id, $received_batch_quantity, $unaccounted, $line, $batch_no, $expiry);
		}
		if ($reference != 0 && $batch_id == 0) {
			$received_quantity = $this->input->post('received_quantity');
			$this->sale_lib->edit_requested_items($line, $batch_no, $expiry);
		}
		$branches = [
			"maitama" => "Maitama",
			"warehouse" => "Warehouse",
			"capitalhub" => "CapitalHub",
			"wuse" => "Wuse",
			"garki" => "Garki"
		];
		unset($branches[$this->config->item('branch_name')]);
		$data['branches'] = $branches;
		$data['line'] = $line;
		$data['received_batch_quantity'] = $received_batch_quantity;
		$data['reference'] = $reference;
		$data['value_changed'] = 0; ///$value_changed;
		$data['no_of_batch'] = $batch_id; //$no_of_batch;
		$data['received_quantity'] = $received_quantity;
		//$pack_type = array('single' => 'Single', 'pack' => 'Pack');
		$pack_type = array('single' => 'Single');
		$data['pack_type'] = $pack_type;
		$data['push'] = $this->sale_lib->get_push();
		$this->load->view('items/request', $data);
	}
	public function updateItemQuantity(){
    }
	public function get_transfers_cart(){
		echo "<pre>";
		print_r($this->sale_lib->get_transfer());
		echo "</pre>";
	}
	public function edit_item_batch_transfer($line_id, $request_id)
	{
		$data = array();
		$item_location = $this->sale_lib->get_sale_location();
		$locator = array('' => "Select Branch");
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		//$this->form_validation->set_rules('quantity', 'lang:items_quantity', 'required|callback_numeric');
		$location = 'not needed'; //$this->input->post('location');
		$branch_transfer = 0; //$this->sale_lib->get_transfer_branch_id($location); //id of the location you just selected
		$item_name = $this->input->post('item_name');
		//$quantity = parse_decimals($this->input->post('quantity'));
		$stockno = parse_decimals($this->input->post('stockno'));
		$quantit = parse_decimals($this->input->post('quantity'));
		$quantity = parse_decimals($this->input->post('quantity'));
		$accepted_quantity = parse_decimals($this->input->post('accepted_quantity'));
		//check whether quantity is normal or above what is present in stock
		$item_location = $this->input->post('item_location');
		$batch_id = $this->input->post('batch') == '' ? 0 : $this->input->post('batch');
		$batch_info = $this->Item->get_info_batch($batch_id);
		$batch_no = $batch_info->batch_no;
		$expiry = $batch_info->expiry;
		//$value_changed= $this->input->post('value_changed');
		$reference = $this->input->post('reference');
		$line = $this->input->post('line');
		$item_id = $this->input->post('item_id');
		//$quantity= $this->input->post('quantity');
		$request_from_branch_id = $this->input->post('request_from_branch_id');
		$pack_type = $this->input->post('pack_type');
		$transfer_price = $this->input->post('transfer_price'); //there is no need to validate this since is selection
		//Check whether the price is not over what is in the stock
		$item_quant = $this->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity;
		if ($accepted_quantity > $item_quant || $accepted_quantity <= 0) {
			$accepted_quantity = 0;
			$data['warning'] = "Warning, Inputed Product Quantity is Insufficient or invalid,Reduce quantity to process transfer or contact Admin to update inventory";
		}
		$request_to_branch_id = $this->input->post('request_to_branch_id');
		$received_quantity = $this->input->post('received_quantity');;
		$transfer_id = $this->input->post('transfer_id');
		$received_batch_quantity = $this->input->post('received_batch_quantity') == '' ? 0 : $this->input->post('received_batch_quantity');
		$unaccounted = $this->input->post('unaccounted');
		//$batch_no= $this->input->post('batch_no');
		//$expiry= $this->input->post('expiry');
		$itemset = $this->sale_lib->get_transfer();
		
		$check = $this->sale_lib->edit_item_transfer($line, $item_name, $item_location, $quantity, $accepted_quantity, $location, $branch_transfer, $batch_no = 0, $expiry = null);
		// 	if ($batch_id == 0 && $reference == 0) {
		// 	$received_quantity = $this->input->post('received_quantity');
		// 	$this->sale_lib->edit_item_transfer($line, $item_name, $item_location, $quantity, $accepted_quantity, $location, $branch_transfer, $batch_no = 0, $expiry = null, $transfer_price);
		// 	//$this->sale_lib->edit_pushed_items($line, $quantity,$batch_no=0,$expiry=null);
		// }
		// if (($reference == 0) && ($batch_id != 0)) {
		// 	$this->sale_lib->add_item_request($item_id, $quantity, $request_from_branch_id, $request_to_branch_id, $transfer_id, $received_batch_quantity, $unaccounted, $line, $batch_no, $expiry);
		// }
		// if ($reference != 0 && $batch_id == 0) {
		// 	$received_quantity = $this->input->post('received_quantity');
		// 	$this->sale_lib->edit_requested_items($line, $batch_no, $expiry);
		// }
		$data['request_id'] = $request_id;
		$data['line'] = $line;
		$data['received_batch_quantity'] = $received_batch_quantity;
		$data['reference'] = $reference;
		$data['value_changed'] = 0; ///$value_changed;
		$data['no_of_batch'] = $batch_id; //$no_of_batch;
		$data['received_quantity'] = $received_quantity;
		//$pack_type = array('single' => 'Single', 'pack' => 'Pack');
		$pack_type = array('single' => 'Single');
		$data['pack_type'] = $pack_type;
		$data['push'] = $this->sale_lib->get_transfer();
		$this->load->view('items/transfer', $data);
	}
	function after_transfer_branch_selection(){
		$branch_id=$this->input->get_post("location");
		$this->session->set_userdata("my_transfer_branch_id",$branch_id);
		redirect("items/push");
	}
	public function edit_item_batch_pushed($line_id)
	{
		$data = array();
		$item_location = $this->sale_lib->get_sale_location();
		$locator = array('' => "Select Branch");
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		//$this->form_validation->set_rules('quantity', 'lang:items_quantity', 'required|callback_numeric');
		$location = 'not needed'; //$this->input->post('location');
		$branch_transfer = 0; //$this->sale_lib->get_transfer_branch_id($location); //id of the location you just selected
		$item_name = $this->input->post('item_name');
		//$quantity = parse_decimals($this->input->post('quantity'));
		$stockno = parse_decimals($this->input->post('stockno'));
		$quantit = parse_decimals($this->input->post('quantity'));
		$pack_type = $this->input->post('pack_type');
		$quantity = parse_decimals($this->input->post('quantity'));
		//check whether quantity is normal or above what is present in stock
		$item_location = $this->input->post('item_location');
		/*if($this->form_validation->run() != FALSE)
		{
			$this->sale_lib->edit_item_push($item_id, $item_name, $item_location, $quantity, $location, $branch_transfer);
		}
		else
		{
			$data['error'] = $this->lang->line('sales_error_editing_item');
		}
		$data['warning'] = $this->sale_lib->out_of_stock($this->sale_lib->get_item_id($item_id), $item_location);*/
		$batch_id = $this->input->post('batch') == '' ? 0 : $this->input->post('batch');
		$batch_info = $this->Item->get_info_batch($batch_id);
		$batch_no = $batch_info->batch_no;
		$expiry = $batch_info->expiry;
		//$value_changed= $this->input->post('value_changed');
		$reference = $this->input->post('reference');
		$line = $this->input->post('line');
		$item_id = $this->input->post('item_id');
		//$quantity= $this->input->post('quantity');
		$request_from_branch_id = $this->input->post('request_from_branch_id');
		$pack_type = $this->input->post('pack_type');
		$transfer_price = $this->input->post('transfer_price'); //there is no need to validate this since is selection
		//Check whether the price is not over what is in the stock
		$item_quant = $this->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity;
		if ($quantity > $item_quant || $quantity <= 0) {
			$quantity = 1;
			$data['warning'] = "Warning: Inputted Product Quantity is Insufficient or invalid, update quantity to process transfer or contact Admin to update inventory";
		}
		$request_to_branch_id = $this->input->post('request_to_branch_id');
		$received_quantity = $this->input->post('received_quantity');;
		$transfer_id = $this->input->post('transfer_id');
		$received_batch_quantity = $this->input->post('received_batch_quantity') == '' ? 0 : $this->input->post('received_batch_quantity');
		$unaccounted = $this->input->post('unaccounted');
		//$batch_no= $this->input->post('batch_no');
		//$expiry= $this->input->post('expiry');
		$itemset = $this->sale_lib->get_push();
		if ($batch_id == 0 && $reference == 0) {
			//echo "edit item pushed"; exit();
			$received_quantity = $this->input->post('received_quantity');
			$this->sale_lib->edit_item_push($line, $item_name, $item_location, $quantity, $location, $branch_transfer, $batch_no = 0, $expiry = null, $transfer_price,$pack_type);
			//$this->sale_lib->edit_pushed_items($line, $quantity,$batch_no=0,$expiry=null);
		}
		if (($reference == 0) && ($batch_id != 0)) {
			//echo "add item pushed"; exit();
			$this->sale_lib->add_item_push($item_id, $quantity, $request_from_branch_id, $request_to_branch_id, $transfer_id, $received_batch_quantity, $unaccounted, $line, $batch_no, $expiry);
		}
		if ($reference != 0 && $batch_id == 0) {
			$received_quantity = $this->input->post('received_quantity');
			$this->sale_lib->edit_pushed_items($line, $batch_no, $expiry);
		}
		$data['line'] = $line;
		$data['received_batch_quantity'] = $received_batch_quantity;
		$data['reference'] = $reference;
		$data['value_changed'] = 0; ///$value_changed;
		$data['no_of_batch'] = $batch_id; //$no_of_batch;
		$data['received_quantity'] = $received_quantity;
		$pack_type = array('single' => 'Retail', 'pack' => 'Wholesale');
		//$pack_type = array('single' => 'Single');
		$data['pack_type'] = $pack_type;
		$data['push'] = $this->sale_lib->get_push();
		//print_r($data['push']); exit();
		$this->load->view('items/push_febd', $data);
		// $this->load->view('items/push', $data);
	}
	public function edit_item_batch_push_pull($line_id)
	{
		$data = array();
		$item_location = $this->sale_lib->get_sale_location();
		$locator = array();
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_name'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$this->form_validation->set_rules('quantity', 'lang:items_quantity', 'required|callback_numeric');
		$location = $this->input->post('location');
		$branch_transfer = $this->sale_lib->get_transfer_branch_id($location);
		$item_name = $this->input->post('item_name');
		//$quantity = parse_decimals($this->input->post('quantity'));
		$stockno = parse_decimals($this->input->post('stockno'));
		$quantit = parse_decimals($this->input->post('quantity'));
		$quantity = parse_decimals($this->input->post('quantity'));
		$item_location = $this->input->post('item_location');
		/*if($this->form_validation->run() != FALSE)
		{
			$this->sale_lib->edit_item_push($item_id, $item_name, $item_location, $quantity, $location, $branch_transfer);
		}
		else
		{
			$data['error'] = $this->lang->line('sales_error_editing_item');
		}
		$data['warning'] = $this->sale_lib->out_of_stock($this->sale_lib->get_item_id($item_id), $item_location);*/
		$batch_id = $this->input->post('batch') == '' ? 0 : $this->input->post('batch');
		$batch_info = $this->Item->get_info_batch($batch_id);
		$batch_no = $batch_info->batch_no;
		$expiry = $batch_info->expiry;
		//$value_changed= $this->input->post('value_changed');
		$reference = $this->input->post('reference');
		$line = $this->input->post('line');
		$item_id = $this->input->post('item_id');
		//$quantity= $this->input->post('quantity');
		$request_from_branch_id = $this->input->post('request_from_branch_id');
		$request_to_branch_id = $this->input->post('request_to_branch_id');
		$received_quantity = $this->input->post('received_quantity');
		$transfer_id = $this->input->post('transfer_id');
		$received_batch_quantity = $this->input->post('received_batch_quantity') == '' ? 0 : $this->input->post('received_batch_quantity');
		$unaccounted = $this->input->post('unaccounted');
		//$batch_no= $this->input->post('batch_no');
		//$expiry= $this->input->post('expiry');
		$itemset = $this->sale_lib->get_push();
		if ($batch_id == 0 && $reference == 0) {
			$received_quantity = $this->input->post('received_quantity');
			$this->sale_lib->edit_item_push($line, $item_name, $item_location, $quantity, $location, $branch_transfer, $batch_no = 0, $expiry = null);
			//$this->sale_lib->edit_pushed_items($line, $quantity,$batch_no=0,$expiry=null);
		}
		if (($reference == 0) && ($batch_id != 0)) {
			$this->sale_lib->add_item_pull($item_id, $quantity, $request_from_branch_id, $request_to_branch_id, $transfer_id, $received_batch_quantity, $unaccounted, $line, $batch_no, $expiry);
		}
		if ($reference != 0 && $batch_id == 0) {
			$received_quantity = $this->input->post('received_quantity');
			$this->sale_lib->edit_pushed_items($line, $batch_no, $expiry);
		}
		$data['cart'] = $this->sale_lib->get_push();
		$this->load->view('items/push_pull', $data);
	}
	public function edit_item_batch_pull($line_id)
	{
		$data = array();
		$item_location = $this->sale_lib->get_sale_location();
		$locator = array();
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_name'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$this->form_validation->set_rules('quantity', 'lang:items_quantity', 'required|callback_numeric');
		$location = $this->input->post('location');
		$branch_transfer = $this->sale_lib->get_transfer_branch_id($location);
		$item_name = $this->input->post('item_name');
		//$quantity = parse_decimals($this->input->post('quantity'));
		$stockno = parse_decimals($this->input->post('stockno'));
		//$quantit = parse_decimals($this->input->post('quantity'));
		$quantity = parse_decimals($this->input->post('quantity'));
		$item_location = $this->input->post('item_location');
		/*if($this->form_validation->run() != FALSE)
		{
			$this->sale_lib->edit_item_push($item_id, $item_name, $item_location, $quantity, $location, $branch_transfer);
		}
		else
		{
			$data['error'] = $this->lang->line('sales_error_editing_item');
		}
		$data['warning'] = $this->sale_lib->out_of_stock($this->sale_lib->get_item_id($item_id), $item_location);*/
		$batch_id = $this->input->post('batch') == '' ? 0 : $this->input->post('batch');
		$batch_info = $this->Item->get_info_batch($batch_id);
		$batch_no = $batch_info->batch_no;
		$expiry = $batch_info->expiry;
		//$value_changed= $this->input->post('value_changed');
		$reference = $this->input->post('reference');
		$line = $this->input->post('line');
		$item_id = $this->input->post('item_id');
		//$quantity= $this->input->post('quantity');
		$request_from_branch_id = $this->input->post('request_from_branch_id');
		//Check whether the price is not over what is in the stock
		$item_quant = $this->Item_quantity->get_item_quantity($item_id, $request_from_branch_id)->quantity;
		if ($quantity > $item_quant || $quantity <= 0) {
			$quantity = 1;
			$data['warning'] = "Warning, Inputed Product Quantity is Insufficient or invalid,Reduce quantity to process transfer or contact Admin to update inventory";
		}
		$request_to_branch_id = $this->input->post('request_to_branch_id');
		$stock_name = $this->CI->Stock_location->get_location_name($branch_transfer);
		$in_stock = $this->CI->Item_quantity->get_item_quantity($item_id, $branch_transfer)->quantity;
		$received_quantity = $this->input->post('received_quantity');;
		$transfer_id = $this->input->post('transfer_id');
		$received_batch_quantity = $this->input->post('received_batch_quantity') == '' ? 0 : $this->input->post('received_batch_quantity');
		$unaccounted = $this->input->post('unaccounted');
		//$batch_no= $this->input->post('batch_no');
		//$expiry= $this->input->post('expiry');
		$itemset = $this->sale_lib->get_push();
		//$received_quantity = $this->input->post('received_quantity');
		$this->sale_lib->edit_item_pull($line, $item_name, $item_location, $quantity, $location, $branch_transfer, $stock_name, $in_stock);
		//$this->sale_lib->edit_pushed_items($line, $quantity,$batch_no=0,$expiry=null);
		$data['pull'] = $this->sale_lib->get_push();
		$this->load->view('items/pull', $data);
	}
	public function receive_transfer_receipt()
	{
		// Save the data to the sales table
		$data = array();
		//$customer_id=$data['person_id'];
		$data['cart'] = $this->sale_lib->get_push();
		$transfer_id = $data['transfer_id'] = $this->sale_lib->get_transfer_id();
		$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		$employee_info = $this->Employee->get_info($employee_id);
		$data['employee'] = $employee_info->first_name . ' ' . $employee_info->last_name[0];
		$data['company_info'] = implode("\n", array(
			$this->config->item('address'),
			$this->config->item('phone'),
			$this->config->item('account_number')
		));
		$data['sale_status'] = '0'; // Complete
		$this->Sale->receive_transfer_save($data['cart'], $transfer_id, $employee_id);
		$this->load->view('items/receive_receipt', $data);
		$this->sale_lib->clear_all();
		//$this->load->view('sales/receipt', $data); //add_push
	}
	public function add_transfer()
	{
		//$data = array();
		//$item_inf=array();
		// check if any discount is assigned to the selected customer
		// if the customer discount is 0 or no customer is selected apply the default sales discount
		//$location = 'None';
		$quantity = 1;
		$item_location = $this->sale_lib->get_sale_location();
		$item_id_or_number_or_item_kit_or_receipt = $this->input->post('item');
		/*$locating=array();
		$locate = array('location' => $item['location']);
		foreach($locator as $row=>$value)
		{
			$locate[$row] = $value;
									
		}
		$data['locate'] = $locate;*/
		if (!$this->sale_lib->add_item_push($item_id_or_number_or_item_kit_or_receipt, $quantity, $item_location)) {
			$data['error'] = 'Unable to add product item. Item has exhausted or does not exist.'; //$this->lang->line('sales_unable_to_add_item');
			$this->transfer(-111); //i will use the number to track the error
		} else {
			$this->transfer();
		}
	}
	public function add_request()
	{
		$quantity = 1;
		$item_location = $this->sale_lib->get_sale_location();
		$item_id_or_number_or_item_kit_or_receipt = $this->input->post('item');
		if (!$this->sale_lib->add_item_request($item_id_or_number_or_item_kit_or_receipt, $quantity, $item_location)) {
			$data['error'] = 'Unable to add product item. Item has exhausted or does not exist.'; //$this->lang->line('sales_unable_to_add_item');
			$this->request_item(-111); //i will use the number to track the error
		} else {
			$this->request_item();
		}
	}
    public function get_item_with_batch_ajax(){
        if (!$this->input->is_ajax_request()) {
            echo json_encode(['error'=>"wrong request!\n Bye bye"]);
        }
        $item_id = $this->input->post('item');
        $response_arr = [];
        if($item_id != null){
            $item_location = $this->sale_lib->get_sale_location();
            $response_arr['item_selected'] = $this->Item->fetch_item_with_batch_numbers($item_id,$item_location);
        }
        echo json_encode($response_arr);
    }
	public function add_push($a_request = 0){
		//$data = array();
		//$item_inf=array();
		// check if any discount is assigned to the selected customer
		// if the customer discount is 0 or no customer is selected apply the default sales discount
		//$location = 'None';
		$quantity = 1;
		$pack_type='single';
		$item_location = $this->sale_lib->get_sale_location();
		$item_id_or_number_or_item_kit_or_receipt = $this->input->post('item');
		$itemInfo = $this->CI->Item->get_info_by_id_or_number($item_id,false,true);
        $item_identifier_type_arr = explode(' ',$this->input->post('item'));
        $is_id = true;
        if(count($item_identifier_type_arr) > 1){
            $is_id = false;
            $item_id_or_number_or_item_kit_or_receipt = end($item_identifier_type_arr);
            // echo "it sent";
            // var_dump($item_identifier_type_arr);
            // exit();
        }
		/*$locating=array();
		$locate = array('location' => $item['location']);
		foreach($locator as $row=>$value)
		{
			$locate[$row] = $value;
									
		}
		$data['locate'] = $locate;*/
//        var_dump($item_id_or_number_or_item_kit_or_receipt);
        $aj_request = $a_request == 1;
//        echo json_encode(["data_pushed"=>$this->sale_lib->add_item_push($item_id_or_number_or_item_kit_or_receipt, $quantity, $item_location)]);
//        exit();
		if (!$this->sale_lib->add_item_push($item_id_or_number_or_item_kit_or_receipt, $quantity, $item_location,0,0,0,0,0,0,null,$is_id,$pack_type)) {
//			$data['error'] = 'Unable to add product item. Item has exhausted or does not exist.'; //$this->lang->line('sales_unable_to_add_item');
			$this->push(-111,$aj_request); //i will use the number to track the error
		} else {
			//print_r($itemInfo); exit();
			if (empty($itemInfo)) {
				$this->push(-1,$aj_request);
			}else{
				$this->push($itemInfo->item_id,$aj_request);
			}
			
		}
	}
	public function add_pull()
	{
		$data = array();
		//$item_inf=array();
		// check if any discount is assigned to the selected customer
		// if the customer discount is 0 or no customer is selected apply the default sales discount
		//$location = 'None';
		$quantity = 1;
		$item_location = $this->sale_lib->get_sale_location();
		$item_id_or_number_or_item_kit_or_receipt = $this->input->post('item');
		/*$locating=array();
		$locate = array('location' => $item['location']);
		foreach($locator as $row=>$value)
		{
			$locate[$row] = $value;
									
		}
		$data['locate'] = $locate;*/
		if (!$this->sale_lib->add_item_push($item_id_or_number_or_item_kit_or_receipt, $quantity, $item_location)) {
			$data['error'] = 'Unable to add product item. Item has exhausted or does not exist.'; //$this->lang->line('sales_unable_to_add_item');
		}
		$data['pull'] = $this->sale_lib->get_push();
		//$locator = array('' => $this->lang->line('items_none'));
		$locator = array('' => $this->lang->line('items_none'));
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_name'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$data['selected_locator'] = $selected_locator;
		$this->load->view('items/pull', $data);
	}
	public function edit_item_push($item_id)
	{
		$data = array();
		$item_location = $this->sale_lib->get_sale_location();
		$locator = array();
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_name'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$this->form_validation->set_rules('quantity', 'lang:items_quantity', 'required|callback_numeric');
		$location = $this->input->post('location');
		$branch_transfer = $this->sale_lib->get_transfer_branch_id($location);
		$item_name = $this->input->post('item_name');
		//$quantity = parse_decimals($this->input->post('quantity'));
		$stockno = parse_decimals($this->input->post('stockno'));
		$quantit = parse_decimals($this->input->post('quantity'));
		if ($quantit > $stockno) {
			$quantity = 1;
			$data['warning'] = "Warning, Inputed Product Quantity is Insufficient,Reduce quantity to process sale or contact Admin to update inventory";
		} else {
			$quantity = parse_decimals($this->input->post('quantity'));
		}
		$item_location = $this->input->post('item_location');
		if ($this->form_validation->run() != FALSE) {
			$this->sale_lib->edit_item_push($item_id, $item_name, $item_location, $quantity, $location, $branch_transfer);
		} else {
			$data['error'] = $this->lang->line('sales_error_editing_item');
		}
		$data['warning'] = $this->sale_lib->out_of_stock($this->sale_lib->get_item_id($item_id), $item_location);
		$data['push'] = $this->sale_lib->get_push();
		// $this->load->view('items/push', $data);
		$this->load->view('items/push_febd', $data);
	}
	public function cancel()
	{
		$this->sale_lib->clear_all_push();
		$this->push();
//		$data['push'] = $this->sale_lib->get_push();
//        $data['push'] = [];
//        $this->load->view('items/push_has', $data);
//		$this->load->view('items/push', $data);
	}
	public function request_cancel()
	{
		$this->sale_lib->clear_all_push();
		$data['push'] = $this->sale_lib->get_push();
		$this->load->view('items/request', $data);
	}
	public function transfer_cancel()
	{
		$this->sale_lib->clear_all_push();
		$data['push'] = $this->sale_lib->get_push();
		$this->load->view('items/transfer', $data);
	}
	public function delete_item($item_number)
	{
		$this->sale_lib->delete_item_push($item_number);
		$locator = array();
		$item_location = $this->sale_lib->get_sale_location();
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_name'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$data['push'] = $this->sale_lib->get_push();
		// $this->load->view('items/push', $data);
		$this->load->view('items/push_febd', $data);
	}
	public function delete_pushed_item($item_number)
	{
		$this->sale_lib->delete_item_push($item_number);
		$data['push'] = $this->sale_lib->get_push();
		$this->load->view('items/push', $data);
	}
	public function delete_received_item($item_number)
	{
		$this->sale_lib->delete_item_push($item_number);
		$data['cart'] = $this->sale_lib->get_push();
		$this->load->view('items/receive_transfer', $data);
	}
	public function delete_reference_item($item_number)
	{
		$this->sale_lib->delete_reference_push($item_number);
		$data['cart'] = $this->sale_lib->get_push();
		$this->load->view('items/receive_transfer', $data);
	}
	public function transfer($item_id = -1)
	{
		//$data['cart'] = $this->sale_lib->get_cart();
		//$this->sale_lib->clear_all();
		$data['push'] = $this->sale_lib->get_push();
		$item_info = $this->Item->get_info($item_id);
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		if ($item_id == -1) {
			$item_info->receiving_quantity = 0;
			$item_info->reorder_level = 0;
			$item_info->item_type = '0'; // standard
			$item_info->stock_type = '0'; // stock
			$item_info->tax_category_id = 0;
		}
		$data['item_info'] = $item_info;
		$locator = array('' => "Select Receiving Branch");
		$item_location = $this->item_lib->get_item_location();
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$data['selected_locator'] = $selected_locator;
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		foreach ($stock_locations as $location) {
			$location = $this->xss_clean($location);
			$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $location['location_id'])->quantity);
			$quantity = ($item_id == -1) ? 0 : $quantity;
			$location_array[$location['location_id']] = array('location_name' => $location['location_name'], 'quantity' => $quantity);
			$data['stock_locations'] = $location_array;
		}
		//$pack_type = array('single' => 'Single', 'pack' => 'Pack');
		$pack_type = array('single' => 'Single');
		$data['pack_type'] = $pack_type;
		if ($item_id == -111) {
			//there is an error from add_item_push
			$data['error'] = 'Unable to add product item. Item has exhausted or does not exist.';
		}
		// echo '<pre>';
		// print_r($data);
		// die;
		$this->load->view('items/transfer', $data);
	}
	public function pending_requests()
	{
		$data = [];
		$data['table_headers'] = $this->xss_clean(get_pending_request_headers());
		$this->load->view("items/pending_requests", $data);
	}
	public function pending_requests_data()
	{
		$search = $this->input->get('search');
		$limit = $this->input->get('limit');
		$offset = $this->input->get('offset');
		$sort = $this->input->get('sort');
		$order = $this->input->get('order');
		$employee_id = "all";
		$employee = $this->Employee->get_logged_in_employee_info();
		if ($employee->role != 3) {
			///only admin can see all the transfers
			$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		}
		//echo "branch id : ".$employee->branch_id; exit();
		$filters = array(
			'start_date' 	=> $this->input->get('start_date'),
			'end_date' 		=> $this->input->get('end_date'),
			'employee_id' => $employee_id
		);
		//$total		= $this->Receiving->get_all_receivings($search, $filters);
		$data_all		= $this->Receiving->get_pending_requests(array("branch_id"=>$employee->branch_id,"search"=>$search,"limit"=>$limit,"offset"=>$offset,"sort"=>$sort,"order"=>$order));
		//$total		= $this->Receiving->get_all_receivings($search, 0, $offset, $sort, $order, $filters)->num_rows();
		$data =  array_slice($data_all, $offset, $limit); //limit is usually more than 0
		$data_rows	= array();
		foreach ($data as $d) {
			$data_rows[] = $this->xss_clean(get_pending_requests_data_row($d, $d['id'], $this));
		}
		echo json_encode(array('total' => count($data_all), 'rows' => $data_rows));
	}
	public function incoming_transfers()
	{
		$data = [];
		$data['table_headers'] = $this->xss_clean(get_incoming_transfers_headers());
		$this->load->view("items/incoming_transfers", $data);
	}
	public function incoming_transfers_data()
	{
		$search = $this->input->get('search');
		$limit = $this->input->get('limit');
		$offset = $this->input->get('offset');
		$sort = $this->input->get('sort');
		$order = $this->input->get('order');
		$employee_id = "all";
		$employee = $this->Employee->get_logged_in_employee_info();
		if ($employee->role != 3) {
			///only admin can see all the transfers
			$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		}
		$filters = array(
			'start_date' 	=> $this->input->get('start_date'),
			'end_date' 		=> $this->input->get('end_date'),
			'employee_id' => $employee_id
		);
		//$total		= $this->Receiving->get_all_receivings($search, $filters);
		$data_all		= $this->Receiving->get_incoming_transfers($this->config->item('branch_name'));
		//$total		= $this->Receiving->get_all_receivings($search, 0, $offset, $sort, $order, $filters)->num_rows();
		$data =  array_slice($data_all, $offset, $limit); //limit is usually more than 0
		$data_rows	= array();
		foreach ($data as $d) {
			$data_rows[] = $this->xss_clean(get_incoming_transfer_data_row($d, $d['id'], $this));
		}
		echo json_encode(array('total' => count($data_all), 'rows' => $data_rows));
	}
	public function view_transfer($id = -1)
	{
		if ($id == -1) {
			$this->incoming_transfers();
		}
		$items = $this->Receiving->get_incoming_transfer_by_id($this->config->item('branch_name'), $id);
		
		$data = array(
			// 'meta'	=> $receiving[0],
			'items'	=> $items
		);
		$this->load->view("items/view_transfer", $data);
	}
	public function accept_transfer($id){
		$data = array();
		$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		$receive_status = '0';
		// $items_to_accept = $this->Receiving->get_incoming_transfer_by_id($this->config->item('branch_name'), $id);
		$items_to_accept = $this->Receiving->accept_transfers($this->config->item('branch_name'), $id);
		if($items_to_accept == false){
			$data['error_message'] = "Invalid data record! Please check with the administrator";
			$this->load->view('items/request_item', $data);
		}else{
			$recv = $this->Receiving->accept_transfer($receive_status, $items_to_accept['items'], $items_to_accept['to_branch'], $employee_id);
			if ($recv > 0) {
				$data['items'] = $items_to_accept['items'];
				$data['from_branch'] = $items_to_accept['to_branch'];
				//show the receipt
				$employee_info = $this->Employee->get_info($employee_id);
				$data['employee'] = $employee_info->first_name . ' ' . $employee_info->last_name;
				$data['receipt_title'] = 'Accepted Transfer Receipt';
				$data['transaction_time'] = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'));
				$data['receivings_id'] = $recv;
				$data['print_after_sale'] = 0;
				$data['barcode'] = $this->barcode_lib->generate_receipt_barcode('TRN ' . $recv);
				$this->load->view("items/accepted_transfer_receipt", $data);
			} else {
				$data['error_message'] = "Action failed. Check for corrections and try again or contact administrator now!";
				$this->load->view('items/request_item', $data);
			}
		}
	}
	//pending item
	public function pending_items()
	{
		$data = [];
		$data['table_headers'] = $this->xss_clean(get_pending_item_headers());
		$this->load->view("items/pending_items", $data);
	}
	public function pending_items_data()
	{
		$search = $this->input->get('search');
		$limit = $this->input->get('limit');
		$offset = $this->input->get('offset');
		$sort = $this->input->get('sort');
		$order = $this->input->get('order');
		$employee_id = "all";
		$employee = $this->Employee->get_logged_in_employee_info();
		if ($employee->role != 3) {
			///only admin can see all the transfers
			$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		}
		$filters = array(
			'start_date' 	=> $this->input->get('start_date'),
			'end_date' 		=> $this->input->get('end_date'),
			'employee_id' => $employee_id
		);
		//$total		= $this->Receiving->get_all_receivings($search, $filters);
		$data_all		= $this->Receiving->get_pending_items($this->config->item('branch_name'));
		//$total		= $this->Receiving->get_all_receivings($search, 0, $offset, $sort, $order, $filters)->num_rows();
		$data =  array_slice($data_all, $offset, $limit); //limit is usually more than 0
		$data_rows	= array();
		foreach ($data as $d) {
			$data_rows[] = $this->xss_clean(get_pending_items_data_row($d, $d['id'], $this));
		}
		echo json_encode(array('total' => count($data_all), 'rows' => $data_rows));
	}
	public function view_pending_item($id = -1)
	{
		if ($id == -1) {
			$this->pending_items();
		}
		$items = $this->Receiving->get_pending_item_by_id($this->config->item('branch_name'), $id);
		
		$data = array(
			// 'meta'	=> $receiving[0],
			'items'	=> $items
		);
		$this->load->view("items/view_pending_item", $data);
	}
	public function accept_item($id){
		$data = array();
		$item = $this->Receiving->get_pending_item_by_id($this->config->item('branch_name'), $id);
		// echo "<pre>";
		// print_r($item);
		// echo "</pre>";
		// die();
		$check = $this->Receiving->accept_items($this->config->item('branch_name'), $id);
		if($check == 0){
			$data['error_message'] = "Invalid data record! Please check with the administrator";
			$this->load->view('items/request_item', $data);
		}else{
			$item_data = array(
				"name" => $item['name'],
				"category" => $item['category'],
				"item_number" => $item['item_number'],
				"cost_price" => $item['cost_price'],
				"unit_price" => $item['unit_price'],
				"whole_price" => $item['whole_price'],
				"pack" => $item['pack'],
				"prescriptions" => $item['prescriptions'],
				"apply_vat" => $item['apply_vat'],
				"wholesale_price_markup" => $item['wholesale_price_markup'],
				"unit_price_markup" => $item['unit_price_markup'],
				"description" => empty($item['description']) ? " " : $item['description'],
				"company" => $item['company'],
			);
			$save = $this->Item->accept_item($item_data);
			if ($save == true) {
				$data['item'] = $item_data;
				$data['content'] = 'Item successfully Accepted';
				$this->load->view('items/item_created', $data);
			} else {
				$data['item'] = $item_data;
				$data['content'] = 'Item NOT accepted. Contact Administrator';
				$this->load->view('items/item_created', $data);
			}
		}
	}
	public function request_item($item_id = -1)
	{
		$data['push'] = $this->sale_lib->get_push();
		$item_info = $this->Item->get_info($item_id);
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		if ($item_id == -1) {
			$item_info->receiving_quantity = 0;
			$item_info->reorder_level = 0;
			$item_info->item_type = '0'; // standard
			$item_info->stock_type = '0'; // stock
			$item_info->tax_category_id = 0;
		}
		$data['item_info'] = $item_info;
		$locator = array('' => "Select Receiving Branch");
		$item_location = $this->item_lib->get_item_location();
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$this->load->model("Branch","br");
		$rows=$this->br->branch_list();
		$branches=array();
		foreach($rows as $row){
			$branches[$row->location_id]=$row->location_name;
		}
		$employee = $this->Employee->get_logged_in_employee_info();
		
		unset($branches[$employee->branch_id]);
		$data['branches'] = $branches;
		$data['selected_locator'] = $selected_locator;
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		foreach ($stock_locations as $location) {
			$location = $this->xss_clean($location);
			$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $location['location_id'])->quantity);
			$quantity = ($item_id == -1) ? 0 : $quantity;
			$location_array[$location['location_id']] = array('location_name' => $location['location_name'], 'quantity' => $quantity);
			$data['stock_locations'] = $location_array;
		}
		//$pack_type = array('single' => 'Single', 'pack' => 'Pack');
		$pack_type = array('single' => 'Single');
		$data['pack_type'] = $pack_type;
		if ($item_id == -111) {
			//there is an error from add_item_push
			$data['error'] = 'Unable to add product item. Item has exhausted or does not exist.';
		}
		// echo '<pre>';
		// print_r($data);
		// die;
		$this->load->view('items/request', $data);
	}
	public function transfer_item($request_id = -1)
	{
		$item_id = -1;
		//$data['cart'] = $this->sale_lib->get_cart();
		$this->sale_lib->empty_transfer();
		$this->sale_lib->empty_transfer_branch();
		$employee = $this->Employee->get_logged_in_employee_info();
		//get items to push from curl
		$items_from_server = $this->Receiving->get_pending_requests_by_id($employee->branch_id, $request_id);
		foreach($items_from_server as $item){
			$this->sale_lib->add_item_to_transfer($item['item_number'], $item['pushed_quantity'], $item['received_quantity'], $request_id);
		}
		$data['push'] = $this->sale_lib->get_transfer();
		$data['request_id'] = $request_id;
		$det=$this->Receiving->get_specific_request_data($request_id);
		$data['to_branch'] =$det->request_from_branch_id;
		$this->sale_lib->set_transfer_branch($det->request_from_branch_id);
		// echo "<pre>";
		// print_r($data['to_branch']);
		// echo "</pre>";
		// die();
		$item_info = $this->Item->get_info($item_id);
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		if ($item_id == -1) {
			$item_info->receiving_quantity = 0;
			$item_info->reorder_level = 0;
			$item_info->item_type = '0'; // standard
			$item_info->stock_type = '0'; // stock
			$item_info->tax_category_id = 0;
		}
		$data['item_info'] = $item_info;
		$locator = array('' => "Select Receiving Branch");
		$item_location = $this->item_lib->get_item_location();
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$data['selected_locator'] = $selected_locator;
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		foreach ($stock_locations as $location) {
			$location = $this->xss_clean($location);
			$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $location['location_id'])->quantity);
			$quantity = ($item_id == -1) ? 0 : $quantity;
			$location_array[$location['location_id']] = array('location_name' => $location['location_name'], 'quantity' => $quantity);
			$data['stock_locations'] = $location_array;
		}
		//$pack_type = array('single' => 'Single', 'pack' => 'Pack');
		$pack_type = array('single' => 'Single');
		$data['pack_type'] = $pack_type;
		if ($item_id == -111) {
			//there is an error from add_item_push
			$data['error'] = 'Unable to add product item. Item has exhausted or does not exist.';
		}
		// echo '<pre>';
		// print_r($data);
		// die;
		$this->load->view('items/transfer', $data);
	}
	public function push($item_id = -1,$a_p_request = false)
	{
		/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/
		//echo "item id : ".$item_id; exit();
		//$data['cart'] = $this->sale_lib->get_cart();
		//$this->sale_lib->clear_all();
		$data['push'] = $this->sale_lib->get_push();
		/*echo "<pre>";
		print_r($data); exit();*/
        if($a_p_request){
            $last_inserted = $this->CI->session->userdata('last_inserted');
            echo json_encode(['pushed_items'=>$data['push'],'last_inserted'=>$last_inserted]);
            exit();
        }
		$item_info = new stdClass();
		if($item_id != -1){
		    $item_info = $this->Item->get_info($item_id);
            foreach (get_object_vars($item_info) as $property => $value) {
                $item_info->$property = $this->xss_clean($value);
            }
        }elseif ($item_id == -111) {
            //there is an error from add_item_push
            $data['error'] = 'Unable to add product item. Item has exhausted or does not exist.';
        }else{
            $item_info->receiving_quantity = 0;
            $item_info->reorder_level = 0;
            $item_info->item_type = '0'; // standard
            $item_info->stock_type = '0'; // stock
            $item_info->tax_category_id = 0;
        }
		$data['item_info'] = $item_info;
		$locator = array('' => "Select Receiving Branch");
		$item_location = $this->item_lib->get_item_location();
		$selected_locator = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_loc($item_location)->result_array() as $row) {
			$locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_name']);
			$selected_locator[$this->xss_clean($row['location_id'])] = $this->xss_clean($row['location_id']);
		}
		$data['locator'] = $locator;
		$data['selected_locator'] = $selected_locator;
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		foreach ($stock_locations as $location) {
			$location = $this->xss_clean($location);
			$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $location['location_id'])->quantity);
			$quantity = ($item_id == -1) ? 0 : $quantity;
			$location_array[$location['location_id']] = array('location_name' => $location['location_name'], 'quantity' => $quantity);
			$data['stock_locations'] = $location_array;
		}
		/*echo "item id : ".$item_id; exit();
		print_r($item_info); exit();*/
		if($item_info->pack>0){
			$pack_type = array('single' => 'Retail', 'pack' => 'Wholesale');
		}else{
			$pack_type = array('single' => 'Single');
		}
		
		//$pack_type = array('single' => 'Retail', 'pack' => 'Wholesale');
		
		$data['pack_type'] = $pack_type;
		$this->load->view('items/push_febd', $data);
		// $this->load->view('items/push_has', $data);
	}
	public function pull($item_id = -1)
	{
		//now available now
		redirect('items');
		//$data['cart'] = $this->sale_lib->get_cart();
		$this->sale_lib->clear_all();
		$data['push'] = $this->sale_lib->get_push();
		$item_info = $this->Item->get_info($item_id);
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		if ($item_id == -1) {
			$item_info->receiving_quantity = 0;
			$item_info->reorder_level = 0;
			$item_info->item_type = '0'; // standard
			$item_info->stock_type = '0'; // stock
			$item_info->tax_category_id = 0;
		}
		$data['item_info'] = $item_info;
		//$data['image_path'] = sizeof($images) > 0 ? base_url($images[0]) : '';
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		foreach ($stock_locations as $location) {
			$location = $this->xss_clean($location);
			$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $location['location_id'])->quantity);
			$quantity = ($item_id == -1) ? 0 : $quantity;
			$location_array[$location['location_id']] = array('location_name' => $location['location_name'], 'quantity' => $quantity);
			$data['stock_locations'] = $location_array;
		}
		$this->load->view('items/pull', $data);
	}
	public function inventory($item_id = -1)
	{
		$item_info = $this->Item->get_info($item_id);
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		$data['item_info'] = $item_info;
		$data['stock_locations'] = array();
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		foreach ($stock_locations as $location) {
			$location = $this->xss_clean($location);
			$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $location['location_id'])->quantity);
			$data['stock_locations'][$location['location_id']] = $location['location_name'];
			$data['item_quantities'][$location['location_id']] = $quantity;
		}
		$this->load->view('items/form_inventory', $data);
	}
	public function count_details($item_id = -1)
	{
		$item_info = $this->Item->get_info($item_id);
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		$data['item_info'] = $item_info;
		$data['stock_locations'] = array();
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		foreach ($stock_locations as $location) {
			$location = $this->xss_clean($location);
			$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $location['location_id'])->quantity);
			$data['stock_locations'][$location['location_id']] = $location['location_name'];
			$data['item_quantities'][$location['location_id']] = $quantity;
		}
		/*echo "<pre>";
		print_r($data); exit();*/
		$this->load->view('items/form_count_details', $data);
	}
	public function print_inventory_count($item_id = -1, $start_date = 2, $end_date = null)
	{
		//echo "end date : ".$end_date; exit();
		// $item_id = $this->input->post('item_id');
		// $start_date = $this->input->post('start_date');
		// $end_date = $this->input->post('end_date');
		if ($item_id <= 0) {
			//redirect to items index page
			//redirect('items');
		}
		if ($start_date != null) {
			$start_date = $start_date . ' 00:00:00';
		}
		if ($end_date != null) {
			$end_date = $end_date . ' 23:59:59';
		}
		$current_location_id = $this->Employee->get_logged_in_employee_info()->branch_id;
		$data["current_quantity"] = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $current_location_id)->quantity);
		//$current_location_id = $this->input->post('stock_location');
		$current_location_name = "";
		$item_info = $this->Item->get_info($item_id);
		foreach (get_object_vars($item_info) as $property => $value) {
			$item_info->$property = $this->xss_clean($value);
		}
		$data['item_info'] = $item_info;
		$data['start_date'] = $start_date;
		$data['end_date'] = $end_date;
		$data['stock_locations'] = array();
		$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
		foreach ($stock_locations as $location) {
			if ($location['location_id'] == $current_location_id) {
				$current_location_name = $location['location_name'];
			}
			$location = $this->xss_clean($location);
			$quantity = $this->xss_clean($this->Item_quantity->get_item_quantity($item_id, $location['location_id'])->quantity);
			$data['stock_locations'][$location['location_id']] = $location['location_name'];
			$data['item_quantities'][$location['location_id']] = $quantity;
		}
		$data['stock_location_id'] = $current_location_id;
		$data['stock_location_name'] = $current_location_name;
		$data['print_after_sale'] = 0;
		/*echo "<pre>";
		print_r($data); exit();*/
		$this->load->view('items/inventory_count', $data);
	}
	public function generate_barcodes($item_ids)
	{
		$this->load->library('barcode_lib');
		$item_ids = explode(':', $item_ids);
		$result = $this->Item->get_multiple_info($item_ids, $this->item_lib->get_item_location())->result_array();
		$config = $this->barcode_lib->get_barcode_config();
		$data['barcode_config'] = $config;
		// check the list of items to see if any item_number field is empty
		foreach ($result as &$item) {
			$item = $this->xss_clean($item);
			// update the UPC/EAN/ISBN field if empty / NULL with the newly generated barcode
			if (empty($item['item_number']) && $this->config->item('barcode_generate_if_empty')) {
				// get the newly generated barcode
				$barcode_instance = Barcode_lib::barcode_instance($item, $config);
				$item['item_number'] = $barcode_instance->getData();
				$save_item = array('item_number' => $item['item_number']);
				// update the item in the database in order to save the UPC/EAN/ISBN field
				$this->Item->save($save_item, $item['item_id']);
			}
		}
		$data['items'] = $result;
		// display barcodes
		$this->load->view('barcodes/barcode_sheet', $data);
	}
	public function bulk_edit()
	{
		$suppliers = array('' => $this->lang->line('items_none'));
		foreach ($this->Supplier->get_all()->result_array() as $row) {
			$row = $this->xss_clean($row);
			$suppliers[$row['person_id']] = $row['company_name'];
		}
		$data['suppliers'] = $suppliers;
		$data['allow_alt_description_choices'] = array(
			'' => $this->lang->line('items_do_nothing'),
			1  => $this->lang->line('items_change_all_to_allow_alt_desc'),
			0  => $this->lang->line('items_change_all_to_not_allow_allow_desc')
		);
		$data['serialization_choices'] = array(
			'' => $this->lang->line('items_do_nothing'),
			1  => $this->lang->line('items_change_all_to_serialized'),
			0  => $this->lang->line('items_change_all_to_unserialized')
		);
		$this->load->view('items/form_bulk', $data);
	}
	public function save_category($item_id = -1)
	{
		//Save item data
		$item_data = array(
			'name' => $this->input->post('category_name'),
		);
		$this->Item->save_category($item_data);
		$this->load->view('items/category', array());
	}
	public function category_apply_vat($cate)
	{
		$name = '';
		$dat = $this->Item->categories_list();
		$categories = array();
		foreach ($dat as $row => $value) {
			if ($value['id'] == $cate) {
				$name = $value['name'];
			}
			$categories[] = array('id' => $value['id'], 'name' => $value['name']);
		}
		$this->db->where('category', $name);
		$this->db->update('items', array('apply_vat' => 'YES'));
		$cat_items = array();
		$data['categories'] = $categories;
		$data['message'] = 'Vat has been applied to all ' . $name . ' Product items';
		$this->load->view('items/category', $data);
	}
	public function remove_vat_category($cate)
	{
		$name = '';
		$dat = $this->Item->categories_list();
		$categories = array();
		foreach ($dat as $row => $value) {
			if ($value['id'] == $cate) {
				$name = $value['name'];
			}
			$categories[] = array('id' => $value['id'], 'name' => $value['name']);
		}
		$this->db->where('category', $name);
		$this->db->update('items', array('apply_vat' => 'NO'));
		$cat_items = array();
		$data['categories'] = $categories;
		$data['message'] = 'Vat has removed from all ' . $name . ' Product items';
		$this->load->view('items/category', $data);
	}
	public function save_item_category($item_id = -1)
	{
		//Save item data
		$category = $this->input->post('category');
		if ($category == '') { //create new category
			$item_data = array(
				'name' => $this->input->post('category_name'),
				'type' => $this->input->post('dept'), //categorization
			);
			$this->Item->save_category($item_data);
		} else {
			$new_cate = $this->input->post('category_name');
			$new_dept = $this->input->post('dept'); //categorization
			$new_item_data = array(
				'name' => $new_cate,
				'type' => $new_dept, //categorization
			);
			$this->Item->update_category($new_item_data, $category);
		}
		redirect('items/categories');
	}
	public function save($item_id = -1)
	{
		$upload_success = $this->_handle_image_upload();
		$upload_data = $this->upload->data();
		$employee = $this->Employee->get_logged_in_employee_info();
		$employee_id = $employee->person_id;
		//Save item data
		// $unit_price_markup = floatval($this->CI->config->item('unit_price_markup'));
		// $wholesale_price_markup = floatval($this->CI->config->item('wholesale_price_markup'));
		$unit_price_markup = $this->input->post('unit_price_markup');
		$wholesale_price_markup = floatval($this->input->post('wholesale_price_markup'));
		$unit_price = $this->input->post('unit_price');
		$whole_price = $this->input->post('whole_price');
		$pack = (int) $this->input->post('items_per_pack');
		if ($unit_price_markup > 0) {
			$unit_price = get_nearest_five($unit_price_markup *  floatval($this->input->post('cost_price')));
		}
		if ($wholesale_price_markup > 0 ) {
			/*$whole_price = get_nearest_five($wholesale_price_markup *  floatval($this->input->post('cost_price')) * $pack);*/
			if($employee->branch_id=="11"){
				/*$whole_price = ceil($wholesale_price_markup *  floatval($this->input->post('cost_price')));*/
				$whole_price = ceil($wholesale_price_markup *  floatval($this->input->post('cost_price'))*100)/100;
			}else{
				$whole_price = get_nearest_five($wholesale_price_markup *  floatval($this->input->post('cost_price')));
			}
			
		}
		$item_data = array(
			'name' => $this->input->post('name'),
			'description' => $this->input->post('description'),
			'category' => $this->input->post('category'),
			'company' => $this->input->post('company') == '' ? NULL : $this->input->post('company'),
			'apply_vat' => $this->input->post('apply_vat') == '' ? 'NO' : $this->input->post('apply_vat'),
			'expiry_days' => $this->input->post('expiry_days') == '' ? 0 : $this->input->post('expiry_days'),
			'grammage' => $this->input->post('grammage') == '' ? NULL : $this->input->post('grammage'),
			'formulation' => $this->input->post('product_type') == '' ? NULL : $this->input->post('product_type'),
			'prescriptions' => $this->input->post('prescriptions') == '' ? 'NO' : $this->input->post('prescriptions'),
			'shelf' => $this->input->post('shelf') == '' ? NULL : $this->input->post('shelf'),
			'period' => $this->input->post('period') == '' ? 'days' : $this->input->post('period'),
			'pack' => $this->input->post('items_per_pack'),
			'item_type' => '0',
			'stock_type' => '0',
			'supplier_id' => $this->input->post('supplier_id') == '' ? NULL : $this->input->post('supplier_id'),
			'item_number' => $this->input->post('item_number') == '' ? NULL : $this->input->post('item_number'),
			'cost_price' => $this->input->post('cost_price'),
			'unit_price' => $unit_price,
			'unit_price_markup' => $unit_price_markup,
			'reorder_level' => parse_decimals($this->input->post('reorder_level')),
			'receiving_quantity' => 0,
			'allow_alt_description' => 0,
			'is_serialized' => 0,
			'deleted' => 0,
			'whole_price' => $whole_price,
			'wholesale_price_markup' => $wholesale_price_markup,
			'custom6' => $this->input->post('custom6') == NULL ? '' : $this->input->post('custom6'),
			'custom7' => $this->input->post('custom7') == NULL ? '' : $this->input->post('custom7'),
			'custom8' => $this->input->post('custom8') == NULL ? '' : $this->input->post('custom8'),
			'custom9' => $this->input->post('custom9') == NULL ? '' : $this->input->post('custom9'),
			'custom10' => $this->input->post('custom10') == NULL ? '' : $this->input->post('custom10')
		);
		if (!empty($upload_data['orig_name'])) {
			// XSS file image sanity check
			if ($this->xss_clean($upload_data['raw_name'], TRUE) === TRUE) {
				$item_data['pic_filename'] = $upload_data['raw_name'];
			}
		}
		
		$cur_item_info = $this->Item->get_info($item_id);
		$is_warehouse = $this->config->item('is_warehouse') == 'YES' && $item_id == -1;
		if ($this->Item->save($item_data, $item_id, $is_warehouse)) {
			$success = TRUE;
			$new_item = FALSE;
			/* Add new product :  post product data to wp */
			if( !empty($sku) ){
				$this->load->library('External_calls');
				$j_data = ['sku'=>$sku, 'item_id'=>null,'name'=>$item_data['name'],'unit_price'=>$item_data['unit_price'],'quantity'=>0];
				$url = WOO_BASE_URL.'/product';
				$response =  External_calls::makeRequest($url,$j_data,'POST');
			}
			/* end */
			//New item
			if ($item_id == -1) {
				$item_id = $item_data['item_id'];
				$new_item = TRUE;
				//add the quantity
				$new_quantities = array(
					'item_id' => $item_id,
					'location_id' => $employee->branch_id,
					'quantity' => 0
				);
				$this->Item_quantity->save($new_quantities, $item_id, $employee->branch_id);
			}
			if ($success && $upload_success) {
				$message = $this->xss_clean($this->lang->line('items_successful_' . ($new_item ? 'adding' : 'updating')) . ' ' . $item_data['name']);
				echo json_encode(array('success' => TRUE, 'message' => $message, 'id' => $item_id));
			} else {
				$message = $this->xss_clean($upload_success ? $this->lang->line('items_error_adding_updating') . ' ' . $item_data['name'] : strip_tags($this->upload->display_errors()));
				echo json_encode(array('success' => FALSE, 'message' => $message, 'id' => $item_id));
			}
		} else //failure
		{
			$message = $this->xss_clean($this->lang->line('items_error_adding_updating') . ' ' . $item_data['name']);
			echo json_encode(array('success' => FALSE, 'message' => $message, 'id' => -1));
		}
	}
	public function checkceil(){
		// print_r('jude');
		$vat_value = 1 + ($this->config->item('vat') / 100);
				$unit_price = (700 / $vat_value);
		echo $unit_price;
	}
	public function save_update($item_id = -1)
	{
		$upload_success = $this->_handle_image_upload();
		$upload_data = $this->upload->data();
		$employee = $this->Employee->get_logged_in_employee_info();
		$employee_id = $employee->person_id;
		//Save item data
		// $unit_price_markup = floatval($this->CI->config->item('unit_price_markup'));
		// $wholesale_price_markup = floatval($this->CI->config->item('wholesale_price_markup'));
		$unit_price_markup = $this->input->post('unit_price_markup');
		$wholesale_price_markup = floatval($this->input->post('wholesale_price_markup'));
		$unit_price = $this->input->post('unit_price');
		$whole_price = $this->input->post('whole_price');
		$pack = (int) $this->input->post('items_per_pack');
		$current_apply_vat = $this->input->post('current_apply_vat');
		$apply_vat = $this->input->post('apply_vat');
		$global_price=$this->input->post('global_price');
		//calculate selling price
		if($unit_price_markup > 0){
			$unit_price = get_nearest_five($unit_price_markup *  floatval($this->input->post('cost_price')));
		}
		
		// if ($unit_price_markup > 0) {
		// 	// $unit_price = get_nearest_five($unit_price_markup *  floatval($this->input->post('cost_price')));
		// 	$unit_price = $unit_price_markup *  floatval($this->input->post('cost_price'));
		// 	// $vat_value = 1 + ($this->config->item('vat') / 100);
		// 	$vat_value = 1.075;
		// 	if($current_apply_vat == 'NO' && $apply_vat == 'YES'){
		// 		$unit_price = ($unit_price / $vat_value);
		// 	}
		// 	// else if($current_apply_vat == 'YES' && $apply_vat == 'NO'){
		// 	// 	$unit_price = $unit_price;
		// 	// }
		// 	if($current_apply_vat != 'NO' && $apply_vat != 'YES'){
		// 		// $unit_price = ($unit_price / $vat_value);
		// 		$unit_price = get_nearest_five($unit_price);
		// }
		// 	// $unit_price = get_nearest_five($unit_price);
			
		// 	//if apply_vat is YES, calculate
		// 		//unit_price = (unit_price / VAT_VALUE)
		// 	//VAT_VALUE = 1 +  (vat / 100)
		// 	// $unit_price = get_nearest_five($unit_price_markup *  floatval($this->input->post('cost_price')));
		// }
		if ($wholesale_price_markup > 0 ) {
			/*$whole_price = get_nearest_five($wholesale_price_markup *  floatval($this->input->post('cost_price')) * $pack);*/
			if($employee->branch_id=="11"){
				/*$whole_price = ceil($wholesale_price_markup *  floatval($this->input->post('cost_price')) );*/
				$whole_price = ceil($wholesale_price_markup *  floatval($this->input->post('cost_price'))*100)/100;
			}else{
				$whole_price = get_nearest_five($wholesale_price_markup *  floatval($this->input->post('cost_price')) );
			}
			
		}
		//restore deleted
		$restore = $this->input->post('is_deleted') ? 1 : 0;
//		echo json_encode(["error"=>"Testing error","restore"]);
//		exit();
		$item_data = array(
			'name' => $this->input->post('name'),
			'description' => $this->input->post('description'),
			'category' => $this->input->post('category'),
			'company' => $this->input->post('company') == '' ? NULL : $this->input->post('company'),
			'apply_vat' => $this->input->post('apply_vat') == '' ? 'NO' : $this->input->post('apply_vat'),
			'expiry_days' => $this->input->post('expiry_days') == '' ? 0 : $this->input->post('expiry_days'),
			'grammage' => $this->input->post('grammage') == '' ? NULL : $this->input->post('grammage'),
			'formulation' => $this->input->post('product_type') == '' ? NULL : $this->input->post('product_type'),
			'prescriptions' => $this->input->post('prescriptions') == '' ? 'NO' : $this->input->post('prescriptions'),
			'shelf' => $this->input->post('shelf') == '' ? NULL : $this->input->post('shelf'),
			'period' => $this->input->post('period') == '' ? 'days' : $this->input->post('period'),
			'pack' => $pack,
			'item_type' => '0',
			'stock_type' => '0',
			'supplier_id' => $this->input->post('supplier_id') == '' ? NULL : $this->input->post('supplier_id'),
			'item_number' => $this->input->post('item_number') == '' ? NULL : $this->input->post('item_number'),
			/*'cost_price' => $this->input->post('cost_price'),
			'unit_price' => $unit_price,
			'unit_price_markup' => $unit_price_markup,*/
			/*'reorder_level' => parse_decimals($this->input->post('reorder_level')),*/
			'receiving_quantity' => 0,
			'allow_alt_description' => 0,
			'is_serialized' => 0,
			'deleted' => $restore,
			'type' =>$this->input->post('dept'),
			// 'whole_price' => $whole_price,
			// 'wholesale_price_markup' => $this->input->post('wholesale_price_markup'),
			'custom6' => $this->input->post('custom6') == NULL ? '' : $this->input->post('custom6'),
			'custom7' => $this->input->post('custom7') == NULL ? '' : $this->input->post('custom7'),
			'custom8' => $this->input->post('custom8') == NULL ? '' : $this->input->post('custom8'),
			'custom9' => $this->input->post('custom9') == NULL ? '' : $this->input->post('custom9'),
			'custom10' => $this->input->post('custom10') == NULL ? '' : $this->input->post('custom10')
		);
		if (!empty($upload_data['orig_name'])) {
			// XSS file image sanity check
			if ($this->xss_clean($upload_data['raw_name'], TRUE) === TRUE) {
				$item_data['pic_filename'] = $upload_data['raw_name'];
			}
		}
		
		//$cur_item_info = $this->Item->get_info($item_id);
		//$categoryData = $this->Item->get_item_category_by_name($item_data['category']);
		// I removed this section due to the fact that production schema has no category_id column.
		// if ($categoryData === FALSE) {
		// 	echo json_encode(array('success' => FALSE, 'message' => 'Unknown category selected! Please select a valid category.'));
		// 	exit;
		// }
		// $item_data['category_id'] = $categoryData->id;
		$item_data['slug'] = str_replace(' ', '-', strtolower($item_data['name']));
		// get the item from db; for update scenarios
		$existingItem = $this->Item->get_item_by_item_number($item_data['item_number']);
		if ($item_id == -1) {
			// creating a new item.
			// check the item number to be sure its unique.
			if ($existingItem) {
				// there is an item with the same item_number and it has not been deleted.
				echo json_encode(array('success' => FALSE, 'message' => 'An item with this Batch number' . $item_data['item_number'] . 'already exists!'));
				exit;
			}
		} else {
			// updating not so sure of what to do here!
			// echo json_encode(array('success' => FALSE, 'message' => $existingItem));
			// exit;
			if ($existingItem) {
				unset($item_data['item_number']);
			}
		}
		/*echo "item id : ".$item_id;
		echo "<br/>Branch id : ".$employee->branch_id; exit();*/
		if ($this->Item->save($item_data, $item_id)) {
			$success = TRUE;
			$new_item = FALSE;
			//New item
			if ($item_id == -1) {
				$item_id = $item_data['item_id'];
				$new_item = TRUE;
				//add the quantity
				$new_quantities = array(
					'item_id' => $item_id,
					'location_id' => $employee->branch_id,
					'quantity' => 0,
					'cost_price' => $this->input->post('cost_price'),
					'unit_price' => $unit_price,
					'unit_price_markup' => $unit_price_markup,
			 		'whole_price' => $whole_price,
					'wholesale_price_markup' => $this->input->post('wholesale_price_markup'),
					'reorder_level' => parse_decimals($this->input->post('reorder_level'))
				);
				$this->Item_quantity->save($new_quantities, $item_id, $employee->branch_id);
			}else{
				$quantities_data = array(
					'cost_price' => $this->input->post('cost_price'),
					'unit_price' => $unit_price,
					'unit_price_markup' => $unit_price_markup,
			 		'whole_price' => $whole_price,
					'wholesale_price_markup' => $this->input->post('wholesale_price_markup'),
					'reorder_level' => parse_decimals($this->input->post('reorder_level'))
				);
				$this->Item_quantity->save($quantities_data, $item_id, $employee->branch_id);
				if($global_price=="YES"){
					$this->Item_quantity->savePriceGlobally($quantities_data, $item_id);
					$title="Item Named ".$item_data['name']." Price Updated Globally";
					$content="Item Name : ".$item_data['name']."<br/>Item Number : ".$item_data['item_number']."<br/> Category : ".$item_data['category']."<br/> New Cost Price :".$this->input->post('cost_price')." <br/> New Retail Price : ".$this->input->post('unit_price')."<br/> Price Updated On : ".date('Y-m-d H:i:s')."<br/> Updated By : ".$employee->username;
					$this->Employee->save_notification(array("created_by"=>$employee_id,"created_on"=>date('Y-m-d H:i:s'),"title"=>$title,"details"=>$content,"type"=>2));
				}
			}
			//$stock_locations = $this->Stock_location->get_undeleted_all()->result_array();
			$item_location = $this->sale_lib->get_sale_location();
			//check ifthe zero quantity is selected 
			if ($item_id > 0) {
				$zero = ($this->input->post('zero_quantity')) ? $this->input->post('zero_quantity') : 0;
				if ($zero) {
					$this->zero_quantity($item_id, $item_location, $employee_id);
				}
			}
			//Save item quantity
			if ($success && $upload_success) {
				if($restore==1){
					$title="Item Named ".$item_data['name']." deleted";
					$content="Item Name : ".$item_data['name']."<br/>Item Number : ".$item_data['item_number']."<br/> Category : ".$item_data['category']."Deleted On : ".date('Y-m-d H:i:s')."<br/> Deleted By : ".$employee->username;
					$this->Employee->save_notification(array("created_by"=>$employee_id,"created_on"=>date('Y-m-d H:i:s'),"title"=>$title,"details"=>$content,"type"=>1));
					$message = $item_data['name']. " Deleted Successfully";
				}else{
					$message = $this->xss_clean($this->lang->line('items_successful_' . ($new_item ? 'adding' : 'updating')) . ' ' . $item_data['name']);
				}
				
				echo json_encode(array('success' => TRUE, 'message' => $message, 'id' => $item_id));
			} else {
				$message = $this->xss_clean($upload_success ? $this->lang->line('items_error_adding_updating') . ' ' . $item_data['name'] : strip_tags($this->upload->display_errors()));
				echo json_encode(array('success' => FALSE, 'message' => $message, 'id' => $item_id));
			}
		} else //failure
		{
			$message = $this->xss_clean($this->lang->line('items_error_adding_updating') . ' ' . $item_data['name']);
			echo json_encode(array('success' => FALSE, 'message' => $message, 'id' => -1));
		}
	}
	public function check_item_number()
	{
		$exists = $this->Item->item_number_exists($this->input->post('item_number'), $this->input->post('item_id'));
		echo !$exists ? 'true' : 'false';
	}
	public function zero_quantity($item_id, $item_location, $employee_id)
	{
		//get current quantity
		$item_quantity = $this->Item_quantity->get_item_quantity($item_id, $item_location);
		if ($this->Item->exists($item_id)) {
			//zero the quantity
			$this->Item_quantity->save(array(
				'quantity'		=> 0,
				'item_id'		=> $item_id,
				'location_id'	=> $item_location,
			), $item_id, $item_location);
			//Add it to the inventory for tracking
			$inv_data = array(
				'trans_date'		=> date('Y-m-d H:i:s'),
				'trans_items'		=> $item_id,
				'trans_user'		=> $employee_id,
				'trans_location'	=> $item_location,
				'trans_comment'		=> "Product Quantity Zeroed",
				'trans_inventory'	=> $item_quantity->quantity * -1,
				'trans_remaining' => 0
			);
			$this->Inventory->insert($inv_data);
		}
	}
	/*
	If adding a new item check to see if an item kit with the same name as the item already exists.
	*/
	public function check_kit_exists()
	{
		if ($this->input->post('item_number') === -1) {
			$exists = $this->Item_kit->item_kit_exists_for_name($this->input->post('name'));
		} else {
			$exists = FALSE;
		}
		echo !$exists ? 'true' : 'false';
	}
	private function _handle_image_upload()
	{
		/* Let files be uploaded with their original name */
		// load upload library
		$config = array(
			'upload_path' => './uploads/item_pics/',
			'allowed_types' => 'gif|jpg|png',
			'max_size' => '100',
			'max_width' => '640',
			'max_height' => '480'
		);
		$this->load->library('upload', $config);
		$this->upload->do_upload('item_image');
		return strlen($this->upload->display_errors()) == 0 || !strcmp($this->upload->display_errors(), '<p>' . $this->lang->line('upload_no_file_selected') . '</p>');
	}
	public function remove_logo($item_id)
	{
		$item_data = array('pic_filename' => NULL);
		$result = $this->Item->save($item_data, $item_id);
		echo json_encode(array('success' => $result));
	}
	public function save_inventory($item_id = -1)
	{
		$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		$cur_item_info = $this->Item->get_info($item_id);
		$location_id = $this->input->post('stock_location');
		$inv_data = array(
			'trans_date' => date('Y-m-d H:i:s'),
			'trans_items' => $item_id,
			'trans_user' => $employee_id,
			'trans_location' => $location_id,
			'trans_comment' => $this->input->post('trans_comment'),
			'trans_inventory' => parse_decimals($this->input->post('newquantity'))
		);
		$this->Inventory->insert($inv_data);
		//Update stock quantity
		$item_quantity = $this->Item_quantity->get_item_quantity($item_id, $location_id);
		$item_quantity_data = array(
			'item_id' => $item_id,
			'location_id' => $location_id,
			'quantity' => $item_quantity->quantity + parse_decimals($this->input->post('newquantity'))
		);
		if ($this->Item_quantity->save($item_quantity_data, $item_id, $location_id)) {
			$message = $this->xss_clean($this->lang->line('items_successful_updating') . ' ' . $cur_item_info->name);
			echo json_encode(array('success' => TRUE, 'message' => $message, 'id' => $item_id));
		} else //failure
		{
			$message = $this->xss_clean($this->lang->line('items_error_adding_updating') . ' ' . $cur_item_info->name);
			echo json_encode(array('success' => FALSE, 'message' => $message, 'id' => -1));
		}
	}
	public function bulk_update()
	{
		$items_to_update = $this->input->post('item_ids');
		$item_data = array();
		foreach ($_POST as $key => $value) {
			//This field is nullable, so treat it differently
			if ($key == 'supplier_id' && $value != '') {
				$item_data["$key"] = $value;
			} elseif ($value != '' && !(in_array($key, array('item_ids', 'tax_names', 'tax_percents')))) {
				$item_data["$key"] = $value;
			}
		}
		//Item data could be empty if tax information is being updated
		if (empty($item_data) || $this->Item->update_multiple($item_data, $items_to_update)) {
			$items_taxes_data = array();
			$tax_names = $this->input->post('tax_names');
			$tax_percents = $this->input->post('tax_percents');
			$tax_updated = FALSE;
			$count = count($tax_percents);
			for ($k = 0; $k < $count; ++$k) {
				if (!empty($tax_names[$k]) && is_numeric($tax_percents[$k])) {
					$tax_updated = TRUE;
					$items_taxes_data[] = array('name' => $tax_names[$k], 'percent' => $tax_percents[$k]);
				}
			}
			if ($tax_updated) {
				$this->Item_taxes->save_multiple($items_taxes_data, $items_to_update);
			}
			echo json_encode(array('success' => TRUE, 'message' => $this->lang->line('items_successful_bulk_edit'), 'id' => $this->xss_clean($items_to_update)));
		} else {
			echo json_encode(array('success' => FALSE, 'message' => $this->lang->line('items_error_updating_multiple')));
		}
	}
	public function delete()
	{
		$items_to_delete = $this->input->post('ids');
		if ($this->Item->delete_list($items_to_delete)) {
			$message = $this->lang->line('items_successful_deleted') . ' ' . count($items_to_delete) . ' ' . $this->lang->line('items_one_or_multiple');
			echo json_encode(array('success' => TRUE, 'message' => $message));
		} else {
			echo json_encode(array('success' => FALSE, 'message' => $this->lang->line('items_cannot_be_deleted')));
		}
	}
	public function apply_vat()
	{
		$items_to_apply_vat = $this->input->post('ids');
		if ($this->Item->apply_vat_to_list($items_to_apply_vat)) {
			$message = $this->lang->line('items_successful_apply_vat') . ' ' . count($items_to_apply_vat) . ' ' . $this->lang->line('items_one_or_multiple');
			echo json_encode(array('success' => TRUE, 'message' => $message));
		} else {
			echo json_encode(array('success' => FALSE, 'message' => $this->lang->line('items_cannot_be_apply_vat')));
		}
	}
	/*
	Items import from excel spreadsheet
	*/
	public function excel()
	{
		$name = 'import_items.csv';
		$data = file_get_contents('../' . $name);
		force_download($name, $data);
	}
	public function excel_import()
	{
		$this->load->view('items/form_excel_import', NULL);
	}
	public function do_excel_import()
	{
		if ($_FILES['file_path']['error'] != UPLOAD_ERR_OK) {
			echo json_encode(array('success' => FALSE, 'message' => $this->lang->line('items_excel_import_failed')));
		} else {
			if (($handle = fopen($_FILES['file_path']['tmp_name'], 'r')) !== FALSE) {
				// Skip the first row as it's the table description
				fgetcsv($handle);
				$i = 1;
				$failCodes = array();
				while (($data = fgetcsv($handle)) !== FALSE) {
					// XSS file data sanity check
					$data = $this->xss_clean($data);
					/* haven't touched this so old templates will work, or so I guess... */
					if (sizeof($data) >= 23) {
						$item_data = array(
							'name'					=> $data[1],
							'description'			=> $data[11],
							'category'				=> $data[2],
							'cost_price'			=> $data[4],
							'unit_price'			=> $data[5],
							'reorder_level'			=> $data[10],
							'supplier_id'			=> $this->Supplier->exists($data[3]) ? $data[3] : NULL,
							'allow_alt_description'	=> $data[12] != '' ? '1' : '0',
							'is_serialized'			=> $data[13] != '' ? '1' : '0',
							'pack'				=> $data[14],
							'custom5'				=> $data[18],
							'custom6'				=> $data[19],
							'custom7'				=> $data[20],
							'custom8'				=> $data[21],
							'custom9'				=> $data[22],
							'custom10'				=> $data[23],
							'prescriptions'				=> $data[27],
							'grammage'				=> $data[28],
							'formulation'				=> $data[29],
							'shelf'				=> $data[30]
						);
						/* we could do something like this, however, the effectiveness of
						  this is rather limited, since for now, you have to upload files manually
						  into that directory, so you really can do whatever you want, this probably
						  needs further discussion  */
						$pic_file = $data[24];
						/*if(strcmp('.htaccess', $pic_file)==0) {
							$pic_file='';
						}*/
						$item_data['pic_filename'] = $pic_file;
						$item_number = $data[0];
						$invalidated = FALSE;
						if ($item_number != '') {
							$item_data['item_number'] = $item_number;
							$invalidated = $this->Item->item_number_exists($item_number);
						}
					} else {
						$invalidated = TRUE;
					}
					if (!$invalidated && $this->Item->save($item_data)) {
						$items_taxes_data = NULL;
						//tax 1
						if (is_numeric($data[7]) && $data[6] != '') {
							$items_taxes_data[] = array('name' => $data[6], 'percent' => $data[7]);
						}
						//tax 2
						if (is_numeric($data[9]) && $data[8] != '') {
							$items_taxes_data[] = array('name' => $data[8], 'percent' => $data[9]);
						}
						// save tax values
						if (count($items_taxes_data) > 0) {
							$this->Item_taxes->save($items_taxes_data, $item_data['item_id']);
						}
						// quantities & inventory Info
						$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
						$emp_info = $this->Employee->get_info($employee_id);
						$comment = 'Qty CSV Imported';
						$cols = count($data);
						// array to store information if location got a quantity
						$allowed_locations = $this->Stock_location->get_allowed_locations();
						for ($col = 25; $col < $cols; $col = $col + 2) {
							$location_id = $data[$col];
							if (array_key_exists($location_id, $allowed_locations)) {
								$item_quantity_data = array(
									'item_id' => $item_data['item_id'],
									'location_id' => $location_id,
									'quantity' => $data[$col + 1],
								);
								$this->Item_quantity->save($item_quantity_data, $item_data['item_id'], $location_id);
								$excel_data = array(
									'trans_items' => $item_data['item_id'],
									'trans_user' => $employee_id,
									'trans_comment' => $comment,
									'trans_location' => $data[$col],
									'trans_inventory' => $data[$col + 1]
								);
								$this->Inventory->insert($excel_data);
								unset($allowed_locations[$location_id]);
							}
						}
						/*
						 * now iterate through the array and check for which location_id no entry into item_quantities was made yet
						 * those get an entry with quantity as 0.
						 * unfortunately a bit duplicate code from above...
						 */
						foreach ($allowed_locations as $location_id => $location_name) {
							$item_quantity_data = array(
								'item_id' => $item_data['item_id'],
								'location_id' => $location_id,
								'quantity' => 0,
							);
							$this->Item_quantity->save($item_quantity_data, $item_data['item_id'], $data[$col]);
							$excel_data = array(
								'trans_items' => $item_data['item_id'],
								'trans_user' => $employee_id,
								'trans_comment' => $comment,
								'trans_location' => $location_id,
								'trans_inventory' => 0
							);
							$this->Inventory->insert($excel_data);
						}
					} else //insert or update item failure
					{
						$failCodes[] = $i;
					}
					++$i;
				}
				if (count($failCodes) > 0) {
					$message = $this->lang->line('items_excel_import_partially_failed') . ' (' . count($failCodes) . '): ' . implode(', ', $failCodes);
					echo json_encode(array('success' => FALSE, 'message' => $message));
				} else {
					echo json_encode(array('success' => TRUE, 'message' => $this->lang->line('items_excel_import_success')));
				}
			} else {
				echo json_encode(array('success' => FALSE, 'message' => $this->lang->line('items_excel_import_nodata_wrongformat')));
			}
		}
	}
	/**
	 * Guess whether file extension is not in the table field,
	 * if it isn't, then it's an old-format (formerly pic_id) field,
	 * so we guess the right filename and update the table
	 * @param $item the item to update
	 */
	private function _update_pic_filename($item)
	{
		$filename = pathinfo($item->pic_filename, PATHINFO_FILENAME);
		if ($filename == '') {
			// if the field is empty there's nothing to check
			return;
		}
		$ext = pathinfo($item->pic_filename, PATHINFO_EXTENSION);
		if ($ext == '') {
			$images = glob('./uploads/item_pics/' . $item->pic_filename . '.*');
			if (sizeof($images) > 0) {
				$new_pic_filename = pathinfo($images[0], PATHINFO_BASENAME);
				$item_data = array('pic_filename' => $new_pic_filename);
				$this->Item->save($item_data, $item->item_id);
			}
		}
	}
	private function startsWith($string, $startString)
	{
		$len  = strlen($startString);
		return (substr($string, 0, $len) === $startString);
	}
	public function getItem($data)
	{
		$item_data = array(
			'name' => $data[0],
			'description' => '',
			'category' => '',
			'company' => '',
			'expiry_days' => 0,
			'pack' => 0.00,
			'item_type' => '0',
			'stock_type' => '0',
			'item_number' => $data[1],
			'cost_price' => $data[3],
			'unit_price' => $data[6],
			'reorder_level' => 0.00,
			'receiving_quantity' => 0.00,
			'allow_alt_description' => 0,
			'is_serialized' => 0,
			'tax_category_id' => 0,
			'deleted' => 0,
			'created_at' => time(),
			'whole_price' => 0.00,
			'period' => ' ',
			'custom3' => ' ',
			'custom4' => ' ',
			'custom5' => ' ',
			'custom6' => ' ',
			'custom7' => ' ',
			'custom8' => ' ',
			'custom9' => ' ',
			'custom10' => ' '
		);
		return $item_data;
	}
	function wholesale_price_updation($offset=0,$limit=500){
		// caution dont run this process unless you know what you are doing ....
		exit();
		ini_set('memory_limit', '-1');
		ini_set('max_input_time', 3600);
		ini_set('max_execution_time', 3600);
		$offset_final=$limit*$offset;
		/*$found=$this->db->select("count(item_id) as found")->from("items")->get()->row()->found;*/
		/*if($found<$offset_final){exit("all data updation done");}*/
		$this->db->select("cost_price,wholesale_price_markup,item_id,id");
		$this->db->from("item_quantities");
		$this->db->where("whole_price >",0);
		//$this->db->limit($limit,$offset_final);
		$items=$this->db->get()->result();
		//echo $this->db->last_query(); exit();
		foreach($items as $it){
			$whole_price=floatval($it->cost_price)*floatval($it->wholesale_price_markup);
			//echo "<br/>item number : ".$it->item_number;
			echo "<br/>cost price : ".$it->cost_price;
			echo "<br/> markup : ".$it->wholesale_price_markup;
			echo "<br/>whole price : ".$whole_price;
			$this->db->update("item_quantities",array("whole_price"=>$whole_price),array("id"=>$it->id),1);
			echo "<br/>".$this->db->last_query();
		}
		echo "updation done";
		//$offset++;
		/*sleep(3);
		redirect("Items/wholesale_price_updation/".$offset);*/
	}
	function virtual_stock_reorder_level_check(){
		ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
		$item_id=$this->input->get_post("item_id");
		$quantity=$this->input->get_post("quantity");
		if($this->input->get_post("request_from_branch_id")){
			$branch_id=$this->input->get_post("request_from_branch_id");
		}else{
			$employee = $this->Employee->get_logged_in_employee_info();
			$branch_id = $employee->branch_id;
		}
		
		$old_value=$this->input->get_post("old_quantity");
		$this->load->model("item");
		$info=$this->item->get_info($item_id,$branch_id);
		$virtual_stock=$info->quantity-$quantity;
		if($virtual_stock<=$info->reorder_level){
			$msg="reorder level of ".$info->name." is ".intval($info->reorder_level)." after this transaction done stock will become ".$virtual_stock;
			echo json_encode(array("error"=>1,"msg"=>$msg,"old_quantity"=>$old_value));
		}else{
			echo json_encode(array("error"=>0));
		}
	}
	function update_global_markup($offset=0,$total=""){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		$employee=$this->Employee->get_logged_in_employee_info();
		if($employee->branch_id!=2){
			exit("You are not authorized to run this process");
		}
		$limit=3000;

		$retail_price_markup=$this->input->get_post("retail_price_markup");
		$wholesale_price_markup=$this->input->get_post("wholesale_price_markup");
		if($offset==0){
			$total=$this->Item_quantity->count_all_item_quantities();
		}
		//echo "total : ".$total; exit();

		$item_quantities=$this->Item_quantity->get_all_item_quantities($offset,$limit);
		


		$counter=0;
		foreach($item_quantities as $row){
			$update_data=array();
			if($retail_price_markup!=""){
				$cost_price=$row->cost_price;
				$update_data["unit_price"]=$row->cost_price*$retail_price_markup;
				$update_data["unit_price_markup"]=$retail_price_markup;
				// $update_data["sync_status"]=0;
			}
			if($wholesale_price_markup!=""){
				$update_data["whole_price"]=$row->cost_price*$wholesale_price_markup;
				$update_data["wholesale_price_markup"]=$wholesale_price_markup;
				// $update_data["sync_status"]=0;
			}
			if(sizeof($update_data)>0){
				$this->Item_quantity->update_item_qunatity_data($update_data,$row->id);
				
			}
			$counter++;
			//exit();
		}
		$total_update_done=$counter+$offset;
		/*echo "data effected rows : ".$total_update_done;
		echo "<br> out of ".$total;*/
		//exit();
		$new_offset=$offset+$limit;
		if($new_offset<$total){
			
			redirect("items/update_global_markup/".$new_offset."/".$total."?retail_price_markup=".$retail_price_markup."&wholesale_price_markup=".$wholesale_price_markup);
		}else{
			redirect("items/update_global_markup_final?retail_price_markup=".$retail_price_markup."&wholesale_price_markup=".$wholesale_price_markup);

		}
	}

	function update_global_markup_final($offset=0,$total=""){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		$retail_price_markup=$this->input->get_post("retail_price_markup");
		$wholesale_price_markup=$this->input->get_post("wholesale_price_markup");
		$employee=$this->Employee->get_logged_in_employee_info();
		if($employee->branch_id!=2){
			exit("You are not authorized to run this process");
		}
		$limit=1500;
		if($offset==0){
			$total=$this->Item->count_all_products();
		}
		$all_master_items=$this->Item->get_all(-1,$limit,$offset)->result();

		$counter=0;
		foreach($all_master_items as $row){
			$update_data=array();
			if($retail_price_markup!=""){
				$cost_price=$row->cost_price;
				$update_data["unit_price"]=$row->cost_price*$retail_price_markup;
				$update_data["unit_price_markup"]=$retail_price_markup;
			}
			if($wholesale_price_markup!=""){
				$update_data["whole_price"]=$row->cost_price*$wholesale_price_markup;
				$update_data["wholesale_price_markup"]=$wholesale_price_markup;
			}
			if(sizeof($update_data)>0){
				$this->Item->save($update_data,$row->item_id);
				
			}
			$counter++;
			//exit();
		}
		$total_update_done=$counter+$offset;
		/*echo "data effected rows : ".$total_update_done;
		echo "<br> out of ".$total;*/
		//exit();
		$new_offset=$offset+$limit;
		if($new_offset<$total){
			redirect("items/update_global_markup_final/".$new_offset."/".$total."?retail_price_markup=".$retail_price_markup."&wholesale_price_markup=".$wholesale_price_markup);
		}else{
			$title="Price Markup Updated Globally";
			$content="Price Markup Updated Globally <br/>
			Retail Price Markup : $retail_price_markup <br/>
			Wholesale Price Markup : $wholesale_price_markup <br/>
			Udated On : ".date('Y-m-d H:i:s')."<br/> Updated By : ".$employee->username;
			$this->Employee->save_notification(array("created_by"=>$employee->person_id,"created_on"=>date('Y-m-d H:i:s'),"title"=>$title,"details"=>$content,"type"=>4));

			echo "<h2>Update Done Successfully<br/><a href='".base_url('items')."'>Go Back</a></h2>";
		}
		
	}
}
